META
key;value
description;District PB in Warszawa, Śródmieście
country;Poland
unit;Warszawa
district;Śródmieście
subunit;Śródmieście
instance;2024
num_projects;51
num_votes;4044
budget;4665648
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1593;129208;1669;Odbetonowanie Zakątka Ujazdowskiego - ratujemy zieleń;public transit and roads,environmental protection,public space,sport;children,seniors;1;52.22387275;21.029611073702956
1616;300300;1650;Nie jesteś sam - pierwsza pomoc psychologiczna dla dzieci i młodzieży. Teraz też w Śródmieściu;education;children;1;;
1730;87000;1542;Chronimy jerzyki i wróble w Śródmieściu - konserwacja oraz zawieszenie nowych skrzynek lęgowych dla tych ptaków;environmental protection;;1;;
670;585000;1426;Nasadzenia krzewów, bylin i roślin cebulowych na ul. Waryńskiego (odc. Pl. Konstytucji - Al. Armii Ludowej);public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.217651608088374;21.0152149193031
885;10000;1342;Rowerowe połączenie alei parkowej Pola Mokotowskiego z drogą rowerową po zachodniej stronie ul. Waryńskiego;public transit and roads,public space;seniors;1;52.214963101336764;21.016019361250997
839;70000;1317;Ułatwienie dojazdu rowerem do Krakowskiego Przedmieścia i Nowego Światu z poprzecznych uliczek;public transit and roads,public space;seniors;1;52.23795580642396;21.017413794994358
354;656300;1283;Zieleń dla Powiśla - kwiecista aleja na skarpie warszawskiej;public transit and roads,culture,environmental protection,public space,sport,urban greenery;children,seniors;1;52.23866762165176;21.021480560302738
793;271680;1260;Prototypowanie zieloności, czyli rozpłytowanie i zazielenienie nieużytkowych części chodników przy ul. Wilczej, Hożej i Św. Barbary;environmental protection,public space,urban greenery;children,seniors;1;52.225290729166666;21.010000742482948
200;61000;1244;Tulipany, krokusy, przebiśniegi, narcyze w Śródmieściu;environmental protection,public space,urban greenery;children,seniors;1;;
654;118660;1157;Jadłodzielnia w Śródmieściu;education,environmental protection,welfare;children,seniors;1;52.2350687;21.002416118140587
695;700000;1151;Rozbetonowanie i zazielenienie podwórka na Muranowie;environmental protection,public space,urban greenery;children,seniors;1;52.253316430772735;20.993113517761234
138;930000;1149;Odbudowa i naprawa elementów małej architektury w Parku im. Rydza Śmigłego na Powiślu;public transit and roads,culture,public space,urban greenery;children,seniors;1;52.22956925251959;21.030235701119228
1383;484000;1021;Zielona i sportowa Górnośląska;education,public space,sport;children,seniors;1;52.22387275;21.029611073702956
82;42300;931;Defibrylatory AED i szkolenia z pierwszej pomocy dla uczniów śródmiejskich szkół;education;children,seniors;1;52.236873;21.017601833587168
70;300000;846;Zbiory dla bibliotek;education,culture,public space;children,seniors;0;;
762;26500;841;Instalacja ławek po nieparzystej stronie Marszałkowskiej;public transit and roads,public space;children,seniors;1;52.21559991089527;21.020107269287113
1255;17000;818;Drzewo na ulicy Długiej;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.24750105;21.004652647997414
490;32700;793;Tętno Stolicy-AED dla Śródmieścia;education,public space;children,seniors;1;;
374;88500;774;Aleja drzew na ulicy Sempołowskiej, zieleń dla mieszkańców i uczniów szkoły podstawowej.;environmental protection,public space,urban greenery;children,seniors;1;52.21897025;21.02026723059617
445;99100;762;Oddychający zielenią mural podświetlany energią ze słońca (budynek hali sportowej przy Karmelickiej 13);education,culture,environmental protection,public space,sport,urban greenery;children,seniors;0;52.24729983756614;20.99234104156494
1204;420000;741;Zielona i przyjazna ulica Szwoleżerów;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.2162518304089;21.04201984431711
787;40500;738;Wieże kwiatowe na ulicy Polnej;public transit and roads,environmental protection,public space;children,seniors;1;52.214969674901404;21.019292997509147
728;41100;661;Instalacja ławek po parzystej stronie ul. Waryńskiego;public transit and roads,public space;children,seniors;0;52.215074851803635;21.01667404174805
80;634998;657;Mini drewniany park linowy pod Skarpą Warszawską;education,public space,sport;children;0;52.234554576883156;21.02770328521729
1326;620000;655;Skwer Fogga od nowa;environmental protection,public space,urban greenery;children,seniors;0;;
791;19500;629;Krzewy zimozielone w misach drzew ulicy Oleandrów;culture,environmental protection,public space,urban greenery;children,seniors;0;52.216731355163695;21.018433570861816
149;100000;619;Oświetlenie skweru przu ul. Ludnej (skwer Jerzego Janickiego);public transit and roads,public space;children,seniors;0;52.230074470800126;21.03394746780396
559;1000;611;Biblioteki śródmiejskie dłużej otwarte;education,culture;children,seniors;1;;
79;843000;583;Klimatyczne miejsce zabaw nad Wisłą przy Pomniku Syrena;education,public space;children;0;52.239169572511095;21.03165149688721
406;28000;496;Zbiory w Bibliotece Nr 97;education,culture,public space;children,seniors;0;52.22710445;21.039677517202932
407;25000;479;EKOmural na Drewnianej;environmental protection,public space,sport;children;0;52.2397696;21.02603807064004
588;113300;458;Cyfrowy Senior;education,welfare;seniors;0;;
462;802500;454;Pastorały - czyli historyczny wzór latarni na ul. Nowogrodzkiej;public transit and roads,public space;children,seniors;0;52.22850849585869;21.010030746983833
105;40000;439;Spotkania autorskie, warsztaty, koncerty;education,culture,public space;children,seniors;0;52.225523225;21.02754558495514
246;20000;435;Spotkania z Powstańcami w Śródmieściu;education,culture;children,seniors;0;;
502;60000;435;Relaks pod Mądrą Sową - odpocznij na hamaku lub zrób szach-mat warszawiaku;education,public space;children,seniors;0;52.2397696;21.02603807064004
657;160000;426;Spotkajmy się na Twardej w ogrodzie;education,welfare,urban greenery;children,seniors;0;;
854;142600;411;Festiwal „Lato Seniora” w ogrodzie;culture,welfare;seniors;0;;
1180;480000;406;Drobne zmiany nad Kanałem Piaseczyńskim;environmental protection,public space,sport,urban greenery;children,seniors;0;52.21886499885882;21.040813922882084
1723;595000;405;Modernizacja siłowni plenerowej na Polu Mokotowskim;public space,sport;children,seniors;0;52.21599513907494;21.00341320037842
247;34300;374;Największa impreza w Polsce – silent disco na Placu Zamkowym;culture,public space;seniors;0;52.247696062082674;21.01358823202003
1393;30000;354;Zrobię to sam/a - slip kajakowy przy pomoście w Porcie Czerniakowskim;public space,sport;children,seniors;0;52.22068091326597;21.048710346221924
1335;36550;350;Warsztaty dla seniorów w Małym CAM - Centrum Aktywności Międzypokoleniowej;education,culture,welfare;children,seniors;0;52.21749960336129;21.020107269287113
1582;59000;337;Zagrajmy w kajak polo - bezpłatne zajęcia sportowe w Porcie Czerniakowskim;education,public space,sport,urban greenery;children,seniors;0;52.22103271681407;21.047015190124515
824;15000;334;Prywatka dla Seniora w Śródmieściu;welfare,sport;seniors;0;;
402;64200;332;Nie samym chlebem człowiek żyje – czyli kultura dla każdego;education,culture,welfare;seniors;0;;
441;47150;331;Tai chi nie tylko pod chmurką;education,culture,welfare,sport;seniors;0;52.21515198236164;21.015353211902195
243;15000;275;Zrób to sobie samodzielnie czyli kreatywne rękodzieło;education,culture,environmental protection;seniors;0;52.217727499999995;21.019912311016945
150;500000;236;Festiwal Kultury „Emilian” na zielonym dziedzińcu szkoły;education,culture,public space,urban greenery;children,seniors;0;52.2372708;21.021420339940242
852;12000;236;Śródmiejski karnawał. Międzypokoleniowy Kurs Tańca Towarzyskiego z instruktorem;education,culture,welfare;seniors;1;52.215518349999996;21.017251032874213
424;100000;113;Gra ŚRÓDLE dla mieszkańców Dzielnicy Śródmieście;education,culture,public space,urban greenery;children,seniors;0;;
VOTES
voter_id;vote;age;sex
11;1326,728,854,791,588,1335,1255,670,762,374,1616,559,654;27;M
33;70,82,1255,762,502,1335,1616,445,654,824,247;41;F
38;654,246,1255,1730,82,695,762,1335,791,787,728,1326,670;75;M
51;670;47;M
53;1593,1383;26;F
121;1593,1383;43;F
185;150;36;F
234;1393,1582;47;M
244;150,1593,1180,839,885;43;M
248;247,200,82,246,424,824;30;M
294;105,559,1593,852,885,445,654,839,82,1255,70,695,1730,406,1616;38;F
318;1593,1383;34;F
366;839,1616,559,885,441,1393,1582;38;F
375;243,354,793,502,374,885,138,1326,670,247,80,79,424,1593,1180;39;F
381;1593,1383;;F
425;1593;8;F
427;852;83;M
447;1593,1383;8;F
475;247,70,243,824,1616,559,852,441,654,1582;71;F
500;441,445;50;F
566;1383,1593;30;F
631;138,657,247,695,70,243,839,445;41;M
641;150;35;M
665;728,654,885,852,559,839,243,79,762,82,695,200,247,80,1616;34;F
686;82;45;F
702;502,407;39;M
720;1593,1383;43;F
721;150;43;F
725;441,1730,150;48;F
874;80,1723,149,787,728,670,695,374,839,1204,1593,354,1383,138,885;22;M
890;150;45;M
899;150;15;F
901;1730,654,445,354,1616,246,150;16;F
922;1730,374,105,243,588,559,1593,654;70;F
928;150;42;F
936;247,1730,200,150,82,1616,657;45;F
949;657,441,654,462,885,150;49;F
962;793,695,150,82,502,374,354,885,445,670,200,1730;53;F
986;150;46;F
1000;80,1616,138,1730,82,79,885,490;36;M
1002;150;54;F
1007;839,354,885,138;38;M
1014;670,695,82,150;58;F
1021;150,82;41;F
1028;150;38;M
1044;406,654;16;M
1057;150;50;F
1062;445;62;M
1069;150;47;F
1122;1593,1383;11;M
1147;150;43;F
1157;150;71;F
1180;490;60;F
1198;490,243,1616,82,150;49;F
1214;445;63;F
1239;1593,1383;37;M
1277;150;45;F
1312;793,200,1730,1616,150;53;F
1345;787,82,670,247,79,839,1616,1204,354,885,149,1383,1180,490,138;24;F
1346;150;33;M
1375;150;44;F
1401;1255,885,149,1383,787,728,670,793,200,1730,762,374,791,1593,1180;37;M
1407;559,1616,1730,1593,200,695,70,1255,354,445;48;F
1429;354,1204,82,138,793,1326,695,70,1616;43;F
1445;150;47;F
1497;1204,791,243,79,80,374,762,82,1730,200,247,695,105,1616,445;21;F
1595;670,1730,695,243,839,1616,885,445;25;F
1720;1593,1383;41;F
1762;150;51;F
1793;243,1393,1582;37;F
1808;150;44;F
1810;762,402,105,246,588,824,1616,1204,354,445,854,787,654,490,138;22;F
1834;150,82;42;F
1837;150;47;F
1858;657,728,1326,670,793,247,80,79,839,1616,885,445,1393,407,502;39;F
1891;200,762,1616,654,490;36;F
1896;70,150;44;F
1918;1326,79,670,793,1204,1593,441,657,1180,654,462,354,695,1730,200;54;F
1974;82;46;F
1984;82;16;M
2037;885,1616,839,150;49;F
2044;1730,793,1326,670,200,82,374,1616,791,1204,1593,462,787,1180,490;67;F
2061;354,149,138;36;M
2071;246,839,1616,559,354,82;34;M
2075;1204,1180,149,1593,406,1730,793,138;53;F
2077;445;13;F
2193;105,79,1723,1616,1593,1383,490,82,1730,247,670,502,407,246,852;42;F
2205;670,793,200,374,1616,1204,1593,354,462,787,695,1255,445;66;F
2212;407,1393,1582;19;M
2264;793,728;35;F
2342;1255,654,1383,445,462,824,588,105,1335,82,1730,695,402,854,490;45;F
2364;150;43;F
2368;793,354,138,1180,149,885,82,839,1593,1383,1393;16;M
2424;82;46;F
2478;793,1730,82,502,762,1616,150;38;F
2482;1326,791,1204,728,793,670,200,1730,762,374,1593,462,1383,787,1180;73;F
2492;150;17;M
2509;1730,150,839;52;F
2528;793;36;M
2549;150;62;M
2553;1730,695,1335,839,885,445,854,138;63;F
2559;588,243,1335,70,670,374,1616,728,406,559,1593,885,1383;52;F
2572;406;65;F
2775;1393,1582;39;F
2781;70,762,1255,1616,1593,354,149,1383,787,1582,654,138,728,79,406;44;M
2814;728,150,1335,791,354,462,1393,1582,138,1730,1255,502,105,79,243;79;F
2890;824,70,406;60;F
2894;79,407,793,854,654,728,200,1730,80,1616,1593,445,490,670,885;32;F
2975;150;51;F
2986;1723,793,670,200,762,1335,588,824,1616,791,1593,885,787,728,1326;36;M
3052;406;77;F
3072;150,82,1616;47;F
3078;445;66;F
3086;1616,70,82,445;41;F
3089;150;46;M
3103;79,728,150,402,80,1335,105,246,1616,787,654;32;F
3111;441,200,1730,695,445;44;F
3113;138,490,654,787,445,1204,1255,200,695,839,1616,1593,354,885,728;32;F
3193;1255,695,445,200,1730,1616;25;F
3273;1383,1616,79,82,150;40;F
3288;138,149,79,559,1593,354;31;M
3336;502,407;43;F
3349;354,885,149,1383,138,70,502,407,839,406,559,1582,490;41;F
3365;1326,670,793,1730,695,588,654,441,138,885,839,354,80,1723,445;50;M
3372;247,1730,79,1616,354,445,490;40;M
3392;654,852,1582,1393;51;F
3393;695,793,200,1730,762,105,79,791,559,1204,1593,354,445,787,654;22;F
3401;150;43;F
3417;1730,654,490,150,82,1616;42;F
3523;695,374;32;M
3550;502,407;36;F
3690;670,762,374,839,1723,791,1204,354,149,787;51;F
3704;839,885,1393,1582;37;F
3735;150;53;F
3751;1383,1593;39;F
3756;1383,1593;42;M
3765;1593,1383;25;M
3807;138,787,200,1326,670,793,1255,80,79,839,1593,354,445;46;F
3821;150;14;F
3839;150;15;F
3841;150;15;F
3852;885,1593,824,1255,82,670,793,1730,695,762,839,462,445;59;M
3862;149,1383,654,138,502,407;55;F
3881;1180,1593,1383;41;M
3886;150;16;F
3943;1593,1383;39;F
3970;1383,1593;9;F
3999;1730,839,1593,1383;9;F
4013;787,1383,462,885,354,1593,1204,791,839,374,1255,82,695,670,793;19;M
4023;1383,1593;5;M
4055;1593,1383;8;M
4071;1616,791,559,1593,1383,854,793,695,150,82;40;F
4104;670,793,695,1255,374,839,354,885,138;33;M
4107;150;39;F
4124;150;19;F
4141;1593,1383;6;M
4220;1383;36;M
4243;695,762,839,728,588,200,1730,654,670,793,1204,354,70,406,559;34;F
4253;490,149,138,1255,82,247,1730,70,502,80,407,79,559,354,885;66;F
4258;1393;75;M
4262;150,1593,149,728;58;F
4289;70,762,885,728,138,839,80,82,200,670,654,1180,1616,1730,793;51;F
4369;200,1730,407,839,1204,791,787,1383,80,762,82,490,138;40;M
4410;374,1255,670,793,200,1730,695,1616,1204,1593,354,149,1383,654,138;45;F
4421;670,1326,200,1730,79,1616,445,138,502,407;42;F
4446;82,1326,150;45;F
4450;1730,695,1255,839,1616,1593,885;27;M
4467;79,670,762,1616,885;39;F
4469;1326,762,1723,1616,1204,728,1383,354,1593,80,374,670,105,406,654;26;F
4489;374,787,695,670,200,1730,502,80,105,246,839,1616,885,728,445;14;F
4627;670,762,588,402,79,839,793,1326,354,885,657,695,80,1616,445;48;F
4647;793,695,243,654,490;28;F
4726;885,150;48;F
4786;502,670,200,1730,695,402,80,79,588,1616,354,149,1383,490,138;69;F
4803;502,407;10;M
4851;150,82,1616,1393;34;F
4869;1393,1616,80,150;35;F
4897;82;49;F
4906;670,200,695,70,1255,839,1723,1593,793,1730,791,559,728;29;F
4912;1393,445,1255,246,839,1593,885,1730,502,407;46;F
4913;1730,839,1723,885,82,150;46;F
4929;502,407;42;F
5072;441,445;17;F
5098;670,793,1326,200,1204,354,445,1180,138,1593,1255,695,1730,462,1393;30;F
5133;1582,490,657,200,1730,243,1616,1204,1593,354,149,1383,1393,654,138;52;F
5174;839,200,1730,354,824,588,695,670,762,1335,1616,1593,854,787,654;32;M
5190;200,695,762,502,374,80,79,424,243,839,1616,885,445;39;F
5198;200,1730,695,374,80,79,424,1616,445;36;F
5276;670,246,793,1255,374,854,149,824,1204,1730,695,1616,1593,490,657;28;F
5279;490,588,1326,670,793,1730,1255,1593,354,657,247,695,1616,654,441;26;F
5291;79,1204,1593,670,1255,374,793,80,406,559,354,149,462,1383,138;61;F
5436;1593,1383;42;M
5443;1593,1383;45;F
5463;82;65;F
5469;885,354,150;65;F
5646;670,793,502,79,149,1255,1593,354,885,1383,138;62;F
5648;445;38;F
5669;762,374,79,791,445,654;38;F
5681;1204,839,762,200,1326,793,670,374,791,1255,695,1616;44;M
5740;407,502;41;F
5799;654,1393,445,1616,243,246,79,105,1335,80,402,82,150;51;F
5807;82,402,374,105,588,1723,824,559,885,490,150,246,839,1616,654;31;F
5814;354;55;M
5847;1616,70,82,793,1326,200,695,354,138,670,502,80,407,79,839;43;F
5854;445;56;F
5918;762,502,80,246,588,1723,1204,1593,354,885,462,1582,695,839,654;38;F
5939;441,445;41;F
5977;70,1616,1730,243,406,559,654;40;M
5991;70,406;57;F
5999;200,1730,695,82,1616,445;46;F
6003;695,1255,445,462,79,1326,374,1616,670,793,200,1730,559,354,657;36;M
6011;150;18;F
6053;445;43;F
6072;441,445;14;M
6080;793,1255,670,200,695,762,354,490,839,1593,885;22;M
6136;1326,402,791,839,1204,354,670,793,1730,695,1255,374,1616,1593,885;36;F
6142;200,82,374,1616,791,559,1593,354,138,728,70,762,885,787,654;57;F
6156;445,441;13;M
6243;670,1730,70,243,885,445;10;F
6259;150;36;M
6266;791,1593,354,445,793,1326,247,1730,695,70,246,1616,559,654,490;29;F
6269;670,762,374,1335,1616,654;44;F
6270;1326,1593,787,670,1730,374,839,1204,885,80,695,445,200,1255,354;48;M
6330;445;10;M
6340;150,728;43;F
6366;839,885;39;M
6383;670,70,762,374,1616,559,1593,654,138,728;56;F
6396;150;47;F
6429;762,1255,670,793,1730,70,502,80,407,79,839,462,787,654,138;47;M
6456;1335,588,1730,1616,1393,654,490;18;F
6489;1730,1326,793,200,246,424,406,791,1593,1383,787,1180,728;25;M
6494;670,793,200,1730,82,246,1616,1593,354;33;F
6520;670,793,1326,695,82,79,1723,1204,1593,354,885;16;M
6535;728;54;F
6563;1730,695,1255,445;47;M
6612;670,793,200,695,82,1255,374,839,559,354,885,1393,1180,490,657;43;M
6627;445,200,695,762,462;34;F
6630;1204,1593,354,1383,787,200,1730,695,70,1255,105,246,839,406,1616;20;F
6701;150;45;M
6745;200,1616,654,70,406;71;M
6767;728,762,82,374,588,490,1593,1204,695,793,839,885;24;F
6777;1593,1383;35;M
6865;502,1335,839,854,1393,441,138,247,1730,824,1616,852,885,1383,1582;64;F
6922;1593,1383;13;M
6924;445,441;18;M
6929;246;20;M
6975;1593,854,138,728,670,1730,695,82,105,1616,885,445,490,402,839;29;F
7010;1393,1582;37;F
7012;1180,793,670,70,1255,885,762,79,839,1723,406,559,1204,1593,1383;13;M
7055;1582;29;F
7065;1180;52;M
7072;150;43;F
7100;247,82,1255,762,246,839,1616,559,885,490,1593,1383;29;M
7121;82;16;F
7243;79,791,354,885,445,787,728,670,247,793,839,1204,149,1593,1383;40;F
7250;791,374,762,1255,70,1326,1593,670,793,200,695,839,354,462,787;38;M
7294;1593,1383;14;F
7312;670,354,885,149,1383,138,793,839;39;F
7348;200,1730,70,82,762,1335,424,1723,354,854,654,490,441,657,728;79;F
7365;150;39;F
7374;824,559,1593,462,445,728,670,1326,200,762,246,791,885,787,654;44;M
7410;1204,1593,1326,1616,885,654,657,374,354,670,793,200,1730,445,787;33;F
7427;82;64;F
7432;1593,1383;39;F
7462;1383,1593;41;F
7471;82,1616,1593,1383;45;M
7485;854,406,402,762,695,670,200,1730,70,246,839,559,885,441,654;51;F
7534;654,1593,1383;9;M
7539;793,200,1730,502,80,407,79,839,1593,354,885,149,1180,490,138;38;M
7545;502,79,407;42;F
7563;1730,670,200,787;88;M
7592;502,407;34;M
7603;502,407;10;M
7614;1593,1383;19;M
7626;793,374,80,79,839,791,1204,1593,354,885,149,1383,1393,787,1180;9;F
7651;82;16;M
7684;82,762,374,407,1335,1723,824,1616;36;F
7729;670,1730,200,695,70,1255,406,354;54;F
7742;670,793,762,374,80,407,79,839,1204,1593,354,149,462,1383,787;7;M
7857;445,490,200,793,670,1730,502,80,407,79,1616,354,1582,441,138;42;F
7935;1593,1383;45;F
7958;885,445,1730,70,762,407,839,406;42;F
7972;1393,670,1326,80,1383,885,1593,1723,502,247,70,839,559,654,490;43;M
7976;200,1730,695,1616;49;F
7981;1593,1383;37;M
8036;1730,70,82,1255,762,502,402,374,80,1335,407,79,246,654,445;36;M
8037;1255,406,200,695,82,1616,445;68;F
8058;402;64;M
8061;354,407,80,247,1255,1204,462,445,1383,787,441,1326,670,1730,885;43;F
8073;1616,559,885,374,1723,1393;48;M
8075;787,791,1326;41;M
8090;670,407,839,1204,1593,354,885,462,1582,1180,138;43;F
8127;82,502,79,490,138,1180,839,1204,885,80,1593,1383;47;M
8129;354,670,793,1730,82,839,1616,791,1204,1593,885,1393,787,1180,490;28;M
8130;793,200,695,70,1255,105,839,406,559,1204,1593,885,149,1383,654;45;F
8149;407,79,793,1326,502,354,149;71;F
8159;1204,695,1255,791,354,1180,138,728,670,762,374,1593,885,462,787;31;M
8162;1730,695,70,105,445,854;65;F
8164;559,1593,354,1383,854,1393,1582,1180,1730,82,588,1616,149,490,138;47;M
8182;70,1616,502,407;39;F
8187;654,149,462,885,588,793,1730,695,762,374,246,839,1616,490,138;38;M
8191;1593,1383;45;F
8204;138,670,80,1180,839,82,1593,885,1335,374,1723;43;F
8220;728,138,839,1255,670,1204,787,149,1180,490,354,695,82,1616,885;16;M
8291;105,407,502,70,793,1326,200,1730,80,839,1593,354,149,1383,138;47;M
8298;670,793,374,80,1204,1593,354,654,138;22;F
8334;793,1255,402,138,728,787,885,791,1616,1723,839,762,1730,200,670;27;F
8364;1593,149,445,138,839,1723,791,885,462,787,670,247,1730,374,728;31;F
8371;243;44;F
8418;402,502,762,1255,82,70,150,695,1730,200,247,1326,793,670,445;14;M
8436;1593,1383;48;M
8444;150;47;F
8446;80,246,1393,441,1730,424,839,1616,1593,354,885,1383,1582,654,138;44;F
8513;1723,588,824,1593,852;67;F
8559;762,79;41;F
8561;70;61;F
8619;1730,762,490,654,1383,588,82,1616;26;F
8623;670,406,559,1593,885,1383,1180,80,79,1616,354,149,1393,1582,138;42;F
8669;150,246,424,791,243,354,852,445,441,138,70,1335,105,406,559;73;F
8674;1593,1383;40;F
8711;1593,1383;9;F
8721;445,793,670,200,695,762,374,354,654,1383,885,1593,791,1616;38;F
8724;670,793,728,839,1255;69;F
8744;70;84;F
8757;1593,1383;44;F
8827;445;48;M
8838;1204,354,885,654,728,1326,762,374,791,787,1180,138,670,200,1730;34;M
8847;654,657,1204,824,402,374,839,1616,791,1730,670,793,200,1255,354;49;F
8872;105,839,559,1593,885,1393,1180,490,82,80,79,1616,1204,1383,1582;40;F
8874;1593,1383;10;M
8929;1593,1383;44;M
8961;1593,1383;7;M
8977;588,407,402,82,70,200,1730,150,79,839,1616,149,854,654,138;64;F
8983;588,407,402,82,70,200,1730,150,79,839,1616,149,854,654,138;68;M
9023;793,247,200,82,1255,762,374;25;M
9047;150;49;M
9060;1204,1180,670,247,200,82,374,80,839,1616,1593,354,1383,787,138;17;F
9072;374,1326,670,1730,695,82,839,354,1204,1593,1383,1582,885,654,1180;38;F
9085;82;50;M
9089;1730,200,1616,695;45;F
9120;79,588,1616,791,1593,852,885,787,670,793;30;F
9126;654,670,1326,138,1593,1204,791,839,793,200,1730,1255,354,1383,787;58;M
9199;1730,839,1616,654,441,150,402,80,105,79,243,852,1383,1582,138;45;F
9201;588,1335,200,247,793,670,70,762,402,105,791,885,787,728,1326;42;M
9347;374,149,200,670,82,1326,70,80,762,406,791,1204,354,462,138;30;M
9352;1255,1616,852,657,728,654,787,445,462,885,791,839,762,1730,200;51;M
9355;1616,79,407,80,502,247,82,246,839;23;M
9356;670,247,695,70,762,80,79,1723,791,559,445,654,839,1616,885;44;M
9392;657,138,1383,354,1593,1204,1723,200,670,793,1326,1730,695,1255,462;59;M
9397;762,80,374,839,1616,791,1204,1593,354,885,149,1383,1393,138,728;50;F
9404;200,247,80,424,1723,406,787,695,762,839,1616,885,1383,654,728;24;M
9429;670,793,695,762;58;F
9444;824,1204,885,462,657,138,490,654,1383,445,762,70,80,246,1616;40;F
9462;354,462,138,1723,670,793,200,1730,762,374,839,1593,885,787,728;44;M
9471;670,793,247,200,1730,695,82,502,374,588,839,1616,1393,490,138;26;M
9593;670,793,200,1730,762,654;32;M
9675;670,793,200,1730,839,1616,885;37;F
9694;354,787,728,670,793,200,374,1383,654,1593,1204,791,1616,695,1730;33;F
9704;79,70,406,149;48;F
9729;791,406,70,670,793,1730,695,1255,762,1335,824,559,854,787,654;32;F
9753;1593,1383;43;F
9790;243,70,374,80,406,791,559,885,1383,1393,1582,728,149,462,138;16;M
9815;82,1723,1616,1593,654;40;F
9824;695,374,839,1383,787,657,670,70,1593,354,138;38;M
9839;502,407;16;F
9863;793,670,70,374,80,839,1723,406,559,885,462,1383,1393,1582,728;56;F
10001;695,793,1730,1593,354;23;F
10061;150,354,559;15;M
10094;1393,150,374,654,787,852,354,200,670,1730,80,839,1616,885,1582;19;F
10170;791,138,1180,354,1204,1255,1730,200,670,793,374,695,839,885,654;36;M
10181;670,793,695;39;M
10199;728;66;M
10200;1255,1204,728,670,793,247,1730,762,502,839,1723,791,885,787,654;28;M
10257;105,885,1582;39;M
10270;695,1723,791,354,839,885,445,1393,1180,793,1730,1255,1204,138,657;35;F
10273;1730,793,670,762,79,839,1723,885,149,1180,787,138,728;36;M
10282;70,695,200,793,80,79,1723,1593,82,839,1616,149,654,490,657;18;F
10291;406,559,354,1582,490,138,82;35;F
10310;149,854,82,402,1335,407,1730,588,1616,559,445,1582,654,490,138;28;F
10312;1326,670,200,1730,762,374,1593,354,462,1383,787,138,839,1255,695;26;M
10366;728;16;M
10397;762,246,354,885,445,654;28;M
10428;791,490,654,445,1383,762,502,1730,670,793,247,354,1593,885,138;26;F
10523;200,407,1616,490;32;M
10540;1255,490,138,793,670,695,246,1616,1593,885;26;M
10570;670,70,762,374,246,1616,791,559,1593;41;M
10581;374,407,839,787,1180,138,1326,695,1255,762,1204,354,885,728,793;28;M
10615;793,670,1730,246,1616,728;22;F
10634;793,695,502,407,1723,1593,885,462,787,445,441,670,149,728,138;15;M
10695;445;37;M
10730;1730;45;M
10753;80,402,200,105,406,1616,354,149,1383,138;63;F
10771;885,1616;26;F
10794;791,787,670;30;M
10796;247,82,246,243,588,1616,852,654,490;19;M
10807;82,138,490,787,1593,791,793,670,657,1180,728,247,839,885;25;M
10811;1255,839,1593,670,138,728,885,1723,791,793,462;26;M
10865;374;44;M
10892;445;36;F
10914;1255,70,588,559,1393,82,839,406,1616,791,885,149,445,654,490;32;F
10915;150;45;M
10924;1616,82,445;43;F
10934;82,1335,824,1616,791,445,787,654,728,490,885,670,247,374,80;35;F
10945;200,1730,762,79,1616,1393,1180,1326,839,1723,791,885,787;36;M
10973;787,762,200,1326,1593,490,885,1723,793,138,80,79,354,839,1255;35;F
10992;1593,1383;68;F
11002;793,1730,695,1255,839,1723,791,1204,354,885,445,1393,1180,138,657;34;M
11018;80,1593,1383;8;M
11021;1593,1383;71;F
11040;80,839,82,502,138,1393,1582;38;F
11066;695,1255,80,79;46;M
11074;654,787,670,793,200,80,839,502,695,150,247,105,354,1180,885;26;M
11077;670,1730,70,1255,80,559,462;50;M
11163;670,793,695,374,1616,791,885,462;46;F
11172;445;24;F
11215;200,1255,502,374,79,839,1616,1204,1593,354,787,654,670,695,445;45;F
11217;787,200,1255,243,1204,1616,149,1393,793,670,1730,1335,354,654,138;43;M
11219;82,402,588,824,654,490,441,1616;33;M
11232;149,445,1393,657,670,200,1730,762,559,885,462,787,654,490,728;35;F
11234;374,728;7;M
11279;374,728;4;F
11374;670,200,1730,762,374,654;41;M
11395;695,200,1326,793,670,82,1723,824,354,885,445,1383,854,654,490;16;F
11403;670,762,1616,654,490;26;M
11419;670,793,247,200,79,1335,762,695,82,407,246,588,490,654;31;F
11427;445;32;F
11432;728;34;M
11446;150;17;M
11487;654,490,138,1180,445,885,354,1593,1616,246,762,82,200,695,839;50;F
11555;1335,200,1326,670,1730,70,762,402,243,824,559,852,885,854,654;68;F
11557;885,200,1255,502,246,839,1616,445,654,490,82,70,670,1730,695;39;F
11578;1326,200,1730,80,588,839,885,1582,138,657,402,79,1616,1383,654;39;M
11584;247,695,82,402,105,243,1616,445;21;F
11597;1593,1383;9;F
11603;374,791,354,793,670,1326,200,1730,839,1593,885,149,787,1180,138;43;F
11616;374;34;F
11647;150;47;M
11662;1593,149,1383,138;52;M
11667;490,138,1180,654,1582,1393,149,1593,354,1204,559,1616,406,1730,793;58;F
11674;670,793,1326,1730,82,79,246,1204,1593,149,1383,654,490,138,1616;36;F
11698;70,839,559,354,654;38;F
11759;839,1723,791,1204,1593,445,854,787,70,407,246,354,149,654;39;F
11780;1383;43;F
11805;200,70,407;35;M
11814;670,200,70,82,374,1593,787;38;F
11846;200,70,502,80,406,824,1593,354,149,1383,138;55;F
11849;1326,695,374,728,1393,1616,1723,588,762,793,1730,70,79;44;M
11914;1593,1383;45;F
11915;354,407;43;M
11920;588,105,1255,70,200,793,670,1730,1393,490;49;M
11940;588,854,654,793,1730,70,839,1616,1593,885,1383,80,406,354,138;41;M
11957;1616,1593,1383,854,787,654,441,657,839,588,695,79,354,885,728;32;F
11988;82,354,445,787,490,793,1730,70,1255,762,1616,559,462,654,657;48;F
12053;1326,445,490;34;F
12099;150;50;F
12143;445,441,247,695,1255,502,839,728;42;F
12179;149,80,1616,1593,1383;40;F
12207;1255,728;32;M
12221;79,1204,1593,670,793,200,441,654,854,1616,588,1335,150;47;F
12277;1204,885,149,728,138,654,445,354,1616,1723,839,588,407,762,670;22;F
12329;824,885,462,445,787,654,490,728,670,200,82,762,79,1723,1616;40;F
12380;1616,70,445;44;F
12385;445,246,1335,1255,762,1326,588,824,1616,852,854,490,657,1730,695;26;M
12402;70,1326,670,793,1730,82,374,839,1616,1593,354,149,462,1180,138;55;F
12426;149,559,1616,79,407,80,138;43;F
12448;82,1616,441,445;32;F
12453;445;25;F
12463;79,407,105,462,445,793,670,247,695,243,839,354,885,854,654;20;F
12490;1616,824,246,79,407,374,402,762,150,695,1730,200,793,670,354;72;F
12492;490;15;F
12497;445;34;M
12515;374,670,1616,791,559,1593,1383;39;F
12521;1593,1383;8;M
12534;82;16;M
12575;670,793,1326,695,80,1593,354,885,138;34;M
12586;445;28;M
12587;374,82,1255,670,793,407,1730,695,1616,791,885,654,1180,490;27;M
12634;82,728;16;F
12646;1326,670,793,200,1730,695,246,824,1616,149,1383,854,441,138,728;53;F
12659;1582;15;M
12663;793,200,1730,1616,559,852;49;F
12672;445,670,793,200,695,762,502,1616,1204,1593,354,149,1383,441,787;28;F
12690;502,1335,407,824,1616,559,852,885,445;26;F
12707;150,793,79,839,1255,695,80,354,1204,1180,462,105,1582;30;M
12710;462,1582,793,695,402,374,243,588,1723,1593,445,654,138,885,839;30;F
12774;80,1180,1730,839,354,138;44;M
12785;445,559,70,1730,1723,406,885,654,670,762,1335,791,787,728,1326;37;M
12794;138,1180,149,354,1593,1204,839,200,670,793,1326,1730,588,885,462;40;M
12807;138,149,502,80,407,79,354,490;43;M
12817;670,793,200,1730,695,243,839,1204,1593,354,885,787,1582,654,657;25;F
12842;1593,1204,791,79,374,502,762,1255,695,1326,793,670,80,1723,354;35;M
12861;200,82,1335,246,354,462,445,654,138,407,79,1616,728;35;F
12893;1335,839,654,462,138,885,445,854,1255,82,70,695,1730,200,490;28;M
12922;670,354,149,462,138;41;M
12931;654,490,138,657,1616,588,502,793,1326,200,695,82,762,80,354;49;F
12958;374,670,793,1730,695,70,1255,502,80,407,79,1616,1204,1593,354;50;F
12961;445;65;M
13022;787,1383,839,80,762,200,793,670,1730,374,1616,559,1593,885,138;44;F
13118;1582,1393,1383,885,1616,1723,839,246,200,793,670,247,762,79,1593;21;F
13175;793,885,839,695;49;M
13270;82;17;F
13307;80,79,1204,1593,354,149,445,1383,654,1180,138,406;65;F
13340;728,885,559,762,247;20;F
13373;70,200,670,80,559,1593,1383,1582,138;45;F
13425;247,839,1723,559,354,885,149;22;F
13446;670,793,1326,762,80,79,1723;36;F
13447;462,149,885,354,1204,791,824,1723,839,793,1326,200,1730,695,82;47;F
13456;670,793,1326,82,490;15;F
13463;490,654,1616,588,402,793;16;F
13470;82;15;M
13475;82;15;M
13484;374,1723,885,462;48;M
13499;1180,1204,1326,787,1593,839,793,670,1730,885,441;31;F
13500;82,791,1593,1204,354,445,670,793,695,1255,1616,462,654,490,728;36;F
13503;70,762,246,839,791,885,149,1393,1582,1180,80,406,1593,1383,138;42;M
13506;374;48;F
13547;839,406,1616,1393,138,793,1730,695,374,1204,1593,885;34;M
13560;762,793,1730,200,695,1204,149,728,787,885,354,1593,670,462,839;24;M
13566;588,246,79,374,762,70,150,695,200,247,793,670,1730,82,490;23;M
13578;1730,695,82,1255,1335,246,588,824,1616,852,445,854,654,490,657;26;F
13611;670,1616;29;M
13621;1616,1204,1593,354,885,852,149,445,787,654,138,441,657,728,695;24;F
13634;149,852,791,839,374,502,70,1255,354,885,654,441,138;45;M
13635;1335,787,1383,885,354,1593,1204,791,1616,839,1255,695,793,670,1730;32;M
13637;670,793,247,200,762,885,462,787,657;28;F
13725;1335,407,1730,200,1326,670,445,1383,854,787,138,70,406,559,885;58;F
13778;670,80,839,406,1616,1204,1593,354,885,149,1383,1393,1582,1180,138;4;M
13783;490,657,762,588,793,70,80,1616,462,354,138,79;78;M
13792;670,793,200,695,762,374,839,1723,1204,1593,354,885,149,1383,138;37;M
13797;82,839,1723,1616,149,787,490;25;M
13896;824,885,1383,246,1616,559,441,1730,82;47;M
13937;150;19;F
13956;793,1730,80,79,839,406,1616,1204,1593,354,885,1383,1393,1180,138;7;M
13996;1593,1383;41;M
14005;105,1730,200,695,502,839,1723,1593,1204,354,787,138,670,793,1393;15;M
14007;588,854,654,657;47;F
14017;1593,1383;10;F
14031;670,82,374,1723,791,1593,885,787;45;F
14069;105,839,1616,406,559,1593,885,1730,1255;54;F
14070;1255,839,354,149,787,728,670,793,1326,200,762,1204,462,1180,138;41;M
14104;793,247,200,695,1255,246,839,885,657;33;M
14181;1255,885,839;42;M
14184;695,374,79,839,1723,791,1204,1593,885,149,787,80,354,462,138;48;M
14221;502,407;38;F
14227;670,1326,200,1730,762,791,1593,787;29;F
14228;654,885,354,1593,1204,559,1616,406,839,374,402,70,1730,793,670;61;M
14294;1204,354,1383,1393,1180,1582;28;M
14312;502,407,839;34;F
14334;138,670;36;M
14337;502,793,80,1383,138,670,1730,695,70,1255,407,1616,1204,1593,354;11;M
14338;670,1326,70,762,791,559,1204,354,149,462,1383,787,1180,138,728;46;M
14348;445;43;F
14352;1616;37;M
14366;70,670,1730,1255,149,1383,407,588,246,1335,138,441,354,1593,1616;39;F
14370;695;32;F
14390;247,200,1730,79,839,1616,885,1582,490,138;27;M
14422;1326,1593;18;M
14423;138,490,654,1204,791,246,670,1730,82,1255;31;M
14439;149,787,728,670,793,1326,1255,762,839,1204,1593,354,462,1180,138;70;F
14456;82,1730,502;51;F
14501;374,670;38;F
14512;695,1204,149,1393,80,839,406,1593,885,1383,1582,1180;40;F
14519;80,1335,407,791,1204,354,246,445,1730,70,588,406,1616,559,654;40;F
14521;1335,588,824,657,854,247,1730,695,82,502,79,839,1616,654;33;M
14527;1255,1326,793,762,354,138,728,1593,407,670,200,1730,1204,885,1180;30;F
14549;445;12;M
14557;246,839,1616,354,1393,1582,441,1730,79,559,1204,1593,149,1383,138;76;F
14593;1180,138,728,657,762,1730,247,793,670,839,791,1593,354,885,462;26;M
14597;445;12;F
14637;150;64;M
14639;657,1393,839,762,1326,793,200,1730,80,1616,1593,354,149,1383,138;50;F
14661;670,149,728,354,1383,1393,1180,762,138,246,839,885;30;M
14681;354;34;M
14713;670,793,200,1730,695,1255,374,407,588,791,1204,1593,354,445,787;22;F
14741;138,728,670,1326,1730,200,793,247,695,762,839,1593,354,445,462;37;M
14768;654,200,1730,695,70,82,1616,445;36;F
14813;150,670,762,588,354,1383,854,138;60;F
14819;1326,793,1730,695,82,1255,1335,824,354,657,1616,854,654,490,138;27;F
14824;1730,670,200,695,82,374,885,854,490;26;F
14826;670,200,374,791;48;M
14828;1616,1593,70,402,1335,105,79,246,406,824,852,149,854,1180,138;61;F
14851;82,374,728,200,1730,1255,762,1335,246,588,839,1616,354,885,787;38;F
14852;82;15;F
14857;200,695,70,762,502,79,839,406,885,445;41;F
14861;149,559,406,374,793,1730,695,70,1255,839,1204,1593,885,490,138;31;F
14868;70,354,138,82,80,79,1616,1730,200,150,502,407;31;F
14917;839,559,854,70,406,1616,654,657,445;49;F
14920;150;17;F
14924;695,200,1730,1255,1335,1593,354,445;62;F
14928;793,1255,839,1730,762,374,80,1616,1593,462,445,854,654,728;46;F
14951;793,1326,407,79,839,791,354,885,1582,1393,490,200,1730,424,445;23;M
14956;354,885,462,654,490,793,695,839,445,787;25;M
15003;374;53;M
15007;787,445,462,354,1593,1616,80,1255,1730,200,793,670,79,839,885;36;F
15008;407,1383,588,402,462,787,728,762,839,1723,1593,354,1393,654,247;20;F
15018;445,885,406,839,695,200,1326,670,70,246,1616,559,1593,441,657;35;F
15043;1204,791,1616,82,1326,793,200,1730,695,1255,374,407,1593,445,490;35;F
15048;1730,695,1204,1593,1383,1180,490;17;M
15106;1393,1582;19;M
15111;1393,1582;52;M
15142;1723,1616,791,1204,1593,354,885,149,462,445,1383,787,654,793,1730;61;F
15180;839,1616,1204,1593,149,462,657,374,762,793,200,1326,138,1723,80;47;M
15245;105,1616,1383,728;24;F
15282;445;46;F
15303;138;50;M
15308;374,80,502,82,1730,200,793,839,1616,1593,354,149,1383,787,138;16;F
15313;762,70,670,793,200,852,1255,1730,82,1335,824,559,854,490,657;27;F
15354;79,502,1730,793,670,70,80,407,588,559,824,654,138,1593,1383;13;M
15395;374,1730,793,247,200,695,82,1255,762,402,839,824,1616,462,445;51;F
15410;200,1335,588,839,1616,885,149,138;53;F
15453;793,1730,374,407,1616,1593,462,787,445,728;26;F
15456;445;69;F
15471;1730,149,445,1180,490,670,1326,200,82,374,80,1616,354,654,138;34;F
15472;374,559,82,654,445,1616,79,80,1255,70,1730,200,793,670,695;36;F
15477;445;39;F
15479;670,1255,1335,559,787,490,728,82,762,374,406,243,654,1593,1383;42;M
15536;1326,793,374,588,1204,1616,462,445,885,490,657,670,247;23;M
15669;200,1730,762,839,406,791,1593,354,445,885,787,728,670,793,70;75;F
15771;1383,728,670,793,1326,374,1335,885;39;M
15817;1204,791,1723,374,1326,728,670,793,200,762,354,885,787,695,138;41;M
15819;1730,1180,441,243,79,80,1616,407,502;39;F
15835;793,1730,79,839,1616,791,559,1593,885,854,654;36;F
15870;793,695,1204,1593,1393,1582,490;28;M
15889;150;34;M
15893;1723,885,654,138,200,1730,82,79,839,824,854,490;31;M
15945;406;65;M
15947;445,885,402,502,762,1255,82,200,1730,70,246,839,406,1616,654;49;F
15956;354,70,402,559,105,852,1393,441,138,1730,406,1616,1582,502,407;46;F
15972;1326,406,885,728,762,82,793,670,70,1730,374,80,138;40;F
15978;70,1255,762,839,1593,885,728,200,793;42;M
15996;502,407,243,1616,559,1204;46;M
16058;1255,695,247,791,885,654,793,670,200,70,80,406,354,787,490;34;F
16069;559,1204,445,787,1593,1616,80,793,200,1730,695,762,79,654,490;34;F
16078;1593,1383;57;F
16080;82,854,654,657,793,670,588,1616,246,200,1730,695,1255,762,445;59;F
16112;1326,657,1616;53;F
16113;1593,1383;52;F
16163;200,1616,1204,1730,1593,1383;42;F
16181;150,445,490;46;F
16263;138,787,1383,149,354,1593,1204,791,374,695,1730,200,1326,670,793;29;M
16264;1593,1383;43;F
16305;138,1723,839,885,1593,654,695,670,793;34;M
16352;200,402,406,1204,1593,885,787,654,1180,138,1616,793,670,374,246;24;M
16406;1180,885,354,1593,80,839,1393,1582;35;M
16416;1593,695,247,1730,138;28;F
16435;588,246,105,1335,402,70,1616,559,1593,354,885,149,445,1383,654;30;M
16457;406,462,657,1335,1593,354,445,787,654,670,1326,791,559,885,728;67;F
16459;1593,82,1383;28;F
16463;82,502,80,79,839,1723,1616,1204,1593,885,657,1383,1582,654,1180;28;F
16475;839,354,885,445,787,657,793,670,200,695,1383,80;23;M
16479;1593,1383;5;F
16486;1593,1383;8;F
16528;441,588,1335,1255,70,762,246,1723,406,559,728;72;F
16548;1616,588,82,1730,70,406,559,1204,1593,354,149,1383,654,1180,138;68;F
16561;490;15;F
16567;839,824,559,1593,852,445,1582,654,1180,441,728,762,374,791,885;38;M
16693;657,728,138,787,149,354,1593,1204,791,79,762,1730,200,793;24;F
16713;402,502,762,1255,82,695,1730,200,247,1616,559,354,885,787,1582;19;F
16718;695,1326,70,1255,374,138,670,793,200,82,762,246,588,839,885;50;M
16763;559,885;24;F
16821;374;41;M
16825;445,728;53;F
16827;793,670,695,1255,762,1723,791,1204,1593,885,1383,1393,138,657,728;25;M
16861;1582;15;M
16863;445;64;M
16879;70,82,406,1616,445;39;F
16896;462,374,1326,1593,354,854,654,138,70,670,793,200,1730,695,445;49;F
16935;885,462,1393,787,490,670,247,200,762,374,80,79,1593;31;F
17001;374,80,79,839,1204,354,885,445,1383,1393,1582,654,490,441,138;17;F
17003;793,670,695,839,885,441;28;M
17027;695,670,1730,793,762,1335,839,1593,885,445,854,654,490,657,1582;25;F
17034;150,82;49;F
17049;243,824,1616,852,445;39;F
17054;1730,80,407,502;69;F
17080;200,1255,791,1204,1593,885,149,787,654,657,728;46;M
17085;354,885,149,657,728,670,793,200,1730,1255,791,1593,445,787,654;45;F
17088;670,793,200,695,1255,374,407,1204,1593,885,445,787,654,657,728;75;F
17097;670,1255,762,374,407,839,1204,1593,354,445,1383,787,654,657,728;72;F
17102;1616,1730,200,793,670,441,1204,1180,1393,1582,1383,1593,138,406,105;48;M
17220;670,793,200,1730,70,762,1723,406,791,1593,854,787,654,728;67;F
17221;243,246,105,70,1730,80,445;11;F
17223;670,793,200,70,762,374,406,1616,885,490;39;F
17227;490,728,243,424,762,1730,200,670,82,374,1616,791,1593;47;F
17273;462,445,490,670,793,200,695,70,82,246,559;59;F
17283;80,105,243,406,824,445;10;F
17305;695,82,490;42;M
17325;793,1255,1616,1204,1383,1593;13;M
17336;82,695,490,445;41;M
17354;1730,200,246,243,406,559,852,462,1582,1393,1383,82,1723,149,490;32;F
17362;670,793,200,695,70,82,80,246,559,1593,354,462,445,490;65;M
17386;445,1723;42;M
17400;791,374,762,728,441,670,1326,1255,354,885,793,200,695,839,1616;22;F
17472;1616,138,791,1593,354,787,657,670,793,1326,1730,695,762,1204,462;34;M
17523;885,787,654,138,407,762,1255,695,200,1326,793,670,354,1723,791;28;M
17613;728,1593,762,1616;40;M
17635;1335,762,1255,695,200,247,793,1730,1616,1593,885,462,1383,654,490;55;F
17646;247,1730,82,839,1616,854,1393,654,406,149,1383,138;33;F
17658;1326,695,1255;48;M
17660;490;15;F
17775;793,670,70,200,247,80,79,1723,1616,1593,354,462,1383,654,138;41;F
17781;70,406,559,885,1383,138;43;M
17798;1393,1582;46;F
17804;1593,885,445,105,793,1730,1616,1204,559,406,354,839,149,70,138;65;F
17825;407,70,82,502,80,79;41;F
17850;82,787,80,839,1616,885,462,793,200,791,1593,1383,670,374,243;42;F
17958;1326,1255,1335,839,1723,885,854,654,1180,1730,82,1616,1593,1393,1582;47;M
17986;445;51;M
18014;791,354,80,787,793,670,1326,762,839,1255,79,1723,885,657,728;64;F
18028;79,588,1593,490,70,82,402,246,1616,354,1383,406,559,149,138;58;F
18034;445;43;F
18082;82;18;F
18119;445,793,1326,200,1730,695,1255,374,839,1616,1204,1593,354,885,138;30;M
18161;1326;45;M
18188;70,1326,670,793,200,1730,762,839,1616,1204,354,462,1393,1255,695;35;M
18200;695,70,1255,374,105,246,406,1616,1204,1593,885,445,654,441,657;20;M
18242;1730,200,70,1335,406,559,854,787;60;F
18252;490;49;F
18267;654,149,885,354,1593,791,670,793,200,1730,695,82,374,839,1616;30;M
18302;490;19;F
18345;670,793,1326,1730,695,791,1204,354,462,728;40;M
18371;1383,1593;48;M
18375;200,354,839,588,246,762,1255,82,70,1616,885;34;F
18391;695,1616,354,852,441,138,657,654,445,559,406,79,407,80,70;39;F
18393;793,200,1730,70,1255,762,1335,246,588,824,791,1204,354,462,787;42;M
18396;793,200,1730,695,70,1255,762,374,246,588,406,559,1593;40;F
18399;670,1730,695,374,1335,246,1616,791,885,654,441;39;M
18435;1593,1383;13;F
18447;374,402,70,1730,247,793,670,105,839,1616,885,1383,1180,1255,728;50;F
18459;1593,1383;47;F
18501;70,852,728,138,406,246,79,670,402,588,824,559,462,854,654;44;F
18530;793,670,200,1730,695,82,762,1723,1616,1204,1593,354,787,654;15;F
18548;80,885;29;M
18573;791,82,1593,354,1180,138,670,793,1730,70,839,406,1616,1204,885;30;F
18591;588,490;45;M
18602;374,793,1326,402,1335,654,670,200,1730,1616,1593,354,462,854,787;58;F
18614;1180,490,728,82,1730,670,70,762,374,406,243,1616,885,654,441;49;F
18665;406,246,839,1180,138,793,374,885,354,70,559,1204,1593,1393,1582;47;F
18675;502,407;72;F
18777;1335,762,1255,793,670,246,588,1616;21;F
18807;200,247,1326,793,670,728,657,787,1383,445,354,839,762,1255,695;29;M
18834;79,82,374,1335,824,1730,70,1255,402,246,1723,1616,1593,854,654;22;F
18836;502,1730,80,407,79,1616,1204,1593,354,149,1383,1393,1582,1180,138;30;F
18839;793,839,885;51;M
18878;445;49;F
18880;1326,247,79,695,445;35;F
18997;1730,1616,1593,354,852,885,149,1383,138;45;F
19071;1180,138,670,793,200,1730,1255,374,79,839,1204,1593,354,885,728;47;M
19090;1593,1383;56;F
19102;670,1730,1255,354,885,490,793,200,839,657;48;M
19153;1393,1582;60;F
19166;445;36;F
19167;247;28;F
19168;1326,695,105,502,70,793,670,200,1730,79,1616,354,445,654,657;52;F
19199;79,502,1326,138;30;F
19221;354,885,462,854,657,728,793,1326,1730,695,1255,374,791,1204,1593;31;F
19224;138,787,462,354,1593,80,374,762,793,695,70,82,1255,445,654;38;F
19252;1180,490,462,654,728,406,762,1255,70,588,793,150,1616,559;70;F
19265;246,654,490,588,138,424,402,502,1730,70,82,407,79,1616,559;59;F
19291;82,149,462,559,70,1326,793,138,1593,695,1730,1255,588,1616,445;62;M
19294;70,82,654,441;34;F
19315;82,588,149,1393,728,70,559,1180,138,1730,246,243,406,1582,490;31;M
19326;82,406,1616,149,1383,490,70,559,138;42;F
19347;1326;34;M
19349;445;54;F
19373;445;56;M
19415;787,654,490,138,200,824,762,402,1616,1393,728,374,1730,670,1383;63;F
19421;670,793,200,695;36;F
19440;82,1593,1383;40;F
19470;1204,149,490,728,670,793,200,695,70,374,839,1616,354,885,138;25;M
19499;79,354,1593,1383;9;F
19561;402,374,80,588,1723,1204,670,1326,824,1616,791,1593,854,787,654;34;F
19564;654,728,138,1582,1393,854,149,559,1723,406,588,243,246,70,82;59;F
19572;502,407;14;M
19574;407,80,502,82;16;F
19575;787,670,793,200;41;M
19608;1730,70,1255,654;67;F
19609;502,407,824,1593,1383,854,654,138;55;F
19621;1593,1383;46;F
19695;854,490,1326,793,1730,762,402,105,246,243,839,1616,559,885,654;38;F
19712;1326,695,762,1593,462;57;M
19713;885,839,406,559,1593,1383;37;F
19758;588,1616,149,462,654,490,138,728;21;M
19780;1593,1383;47;F
19817;200,1730,70,1255,654;72;M
19839;670,793,695,82,1616,490;44;F
19850;1593,1383;28;M
19875;246,1204,149,138;27;M
19881;885,839,406,559,1593,1383;2;M
19899;670,793,200,1730,70,407,354,138,82,762,1593,1383,1616;16;F
19936;839,1593,462,1383,787,138;25;M
20011;762,502,791,839,407,1255,200,670,793,1730,354,138,728;35;F
20041;150;72;M
20087;1593,1383;60;M
20090;150;16;F
20096;247,200,695;23;M
20109;200,246,824,1593,1393,247,70,79,406,1616,1204,852,149,654,138;15;F
20135;670,354,654,490,246,793,200,1730,695,1255,762,462,445;44;F
20142;728;31;M
20144;200,1730,70,1255,654;44;M
20163;670,793,200,1730,762,80,79,839,885,1383,787,1180,138;29;M
20190;1582;52;M
20361;149,445,1383,243,424,79,1326,200,82,80,105,407,246,1616,138;34;F
20516;424,1723,670,839,885;28;F
20549;1383;38;F
20588;670,793,200,791,445,657,1326,728;36;F
20617;1255,70,695,670,200,762,246,824,1616,1593,462,854;27;F
20655;1593,1383;39;F
20690;1593,1383;9;M
20697;490;13;M
20818;246,80,374,502,793,695,839,885,1616;23;M
20869;1326,246,588,824,1593,354,854,793,670,1255,1335,839,1616,1730,654;34;F
20948;588,1616,1593,654,490,200,70,82,406,559,1204,354,149,1383,138;66;F
20949;502,407;15;M
20956;791,354,1204,1326,670,1730,79,80,793,695,374,885,1255,1593,839;38;M
21033;200,1255,839,1616,1593,885,1383;26;F
21054;1582,1255,793,1730,839,1593,885,462,1383,138;32;M
21134;1204,1383,374,787,793,1730,695,82,1255,1616,1593,354,1393,654,1582;56;F
21234;200,354,502,407,79,1616,149,462,654,1180,138;73;M
21277;445,1593,839,762,70,200,670,1255,407,246,354,885,462,787,654;18;M
21301;150,374,1616,559,852,1383,670,793,402,406,1593,354,654,1730,70;68;F
21303;200,839,354,885,462,1616,149,138;38;M
21308;1616,839,200;29;F
21315;150,200,1326,374,1730,695,82,1255,1335,79,246,1616,1593,462,445;37;F
21378;1393,1582;49;F
21379;138;39;M
21393;82,1616,1593,149,462,445,138,695;33;F
21445;149,854,1393,1582,654,490,1730,79,246,588,1204,1593,354,1180,138;73;M
21556;1616,354,654,490;43;F
21565;441,82,105,559,654,138,1730,402,200,354,885,445,1383,1393,490;57;M
21573;1730,885,670,79,149,462,1383,787,728,1593,657,354,138,80,407;11;M
21636;70,105,406,559;65;M
21643;695,793,670,1326,1730,1335,1616,791,787;31;F
21686;839,559,1593,885,1383;41;M
21718;502,407,138,1326,793,200,1730,79,1204,1593,80,839,354,885,1383;38;F
21733;354,149,445,1383,787,490,657,670,793,200,1730,695,374,839,1593;32;F
21773;1255,824,243,424,502,402,80,407,105,79,839,1616,354,138,728;45;F
21778;82,1616,502,1255,354,490,200,1730,70,406,559;75;M
21781;502,407;9;F
21782;243,406,559,852,885,149,1393,1582,105;34;F
21787;445,441;48;F
21798;695,1335,243,839,791,1204,354,462,787,588,885,670,200,1730,374;30;F
21800;1326,80,1593,1383,657,149,1616,839,1255,1730,502,407,79,354,138;47;M
21803;695,1730,406,728,762,793,1255,105,791,654,490;20;M
21816;1204,374,200,793,670,1730,1616,354,885,787,1255,695,80,79,1593;19;M
21822;149,138,1383;25;F
21847;670;39;F
21858;247,200,150,70,82;14;F
21874;150;44;F
21929;200,1730,70,82,1255,762,406,1616,559,354,490;76;F
22005;1593,138,1383;39;F
22029;824,588,1335,374,762,1255,1730,670,200,70,246,406,1593,787,138;33;F
22035;79,407,1335,402,82,1326,200,1730,246,824,1616,1593,462,654,138;39;F
22037;1335,407,588,824,354,149,854,787,654,490,82,839,1616,559,657;28;F
22049;246,1723,791,1593,1383,1582,670,200,1616,885,787,654,728;41;F
22064;80,854,588,1335,793,670,82,839,1616,559,354,885,654,490,138;27;F
22071;138,490,1593,1383;12;M
22123;839,354,149,654,138;31;F
22140;80,839,654,787,462,885,354,1593,1204,791,1616,1730,670,200,824;27;F
22201;138,247,695,82,105,839,654;23;F
22220;200,407,1616,354,1393,1326,70,502,80,79,246,839,559,138;40;F
22250;80,354,149,138;35;F
22296;247,200,407,246,243,824,354,149,654,1730,82,79,1616,445,490;27;F
22381;695,424,1616,854,1393;30;F
22455;1593,354,138,728,670,793,1326,200,695,1255,407,80,79,1204,445;44;M
22483;670,200,1730,70,82,374,246,406,1616,791,559,885,149,490,138;25;F
22500;793,200,695,1255,762,502,402,407,1616,1593,354,885,787,138,657;44;M
22560;354,1204,824,588,839,670,793,1730,374,1335,1593,1255,695,1616,654;24;F
22607;670,1326,246,424,588,1616,791,1204,354,490,200,695,462,654,138;29;F
22619;670,793,762,839,1593,354,885,1393,728;51;M
22620;150,70,82,1723,406,1616,462,654,138;62;F
22624;793,70,762,1335,839,1723,559,885,654,657;33;F
22659;1593,1383;12;F
22695;1730,762,502,105,246,1723,462,728,441,1582,1393,885,559,406,70;52;F
22740;762,354,787,728,657,138,670,793,200,1730,695,80,246,1616,441;28;F
22748;670,1730,82,762,374,80,1616,791,1593,354,445,787,654,490,728;82;F
22750;502,407;33;F
22751;82;48;M
22752;885,462,445,787,138,728,670,200,1730,695,762,839,1616,1204,1593;30;M
22757;839,793,670,1326,200,1730,1723,559,1593,885,787,105,243,445,728;23;F
22778;1723,445,670,793,200,402,407,105,1616,791,559,885,787,728;25;M
22781;1383,1204,791,1616,839,695,670,793,1730,1255,1593,354,885,854,654;53;M
22782;1180,657,728,787,839,670,1326,200,695,82,762,1616,462,490,138;32;F
22835;695,588,824,1616,354,854,654,490,793,762,149,462,728,657,138;38;M
22854;70,200,670,793,80,79,406,791,762,885,854,654,728,374,1616;32;F
22882;149,791,1616,670,200,1730,839,1723,885,138,657,728;32;F
22908;695,200,1326,793,670,854,588,246,1335,502,1730,824,1616,654,490;28;F
22949;695,1204,149,490,657,200,1255,374,1616,791,1593,354,885,445,441;54;F
23004;670,200,1723,354,462,787,1383,793,695,1255,374,80,79,1593;36;F
23036;1335,80,1730,1326,670,1593,885,1383,854,654,138,200,1723,824,1616;31;F
23052;793,200,1730,695,82,1255,762,374,588,839,1593,885,149,138,657;27;F
23057;787,670,793,200,1730,695,1255,762,374,407,243,1723,1616,1593,654;27;F
23136;70,657,670,1616,490,695,654,793,200,1730,1255,885,82,105,138;57;F
23145;1393,1582;15;F
23152;149,445,462,1383,854,1393,787,1582,654,1180,490,441,138,728,150;17;M
23157;1326,670,200,1730,1616,791,354,1383,787,657,728;34;F
23176;150;19;F
23209;402,374,407,1616,791,1204,1593,354,885,149,445,1383,787,654,728;22;M
23247;354,1593,791,79,374,1255,1730,695,82,502,80,407,839,1616,445;36;F
23283;588,149,654,490,441,138,728,1730,502,1335,105,246,1616,854,1383;29;F
23375;1730,246,407,82,247,824,445,854,654,657,1616,588,1335,695,728;39;F
23382;695,82,762,80,79,1616,1593,445;40;F
23398;787,441,793,200,695,70,82,1255,105,243,839,1616,445,654,490;55;F
23415;654,490,1730,1326,1383,854,138,793,695,82,1255,588,1616,1593,885;45;F
23534;885,149,1393,654,490,138;30;F
23547;1383;7;M
23573;1383;4;M
23652;695,445;33;M
23653;728,490,787,1383,445,354,1204,791,1730,670,82,374,80,1616,1593;31;F
23662;885,445,1383,787,138,695,200,793,670,407,490,82,1616,354,149;20;F
23675;490,445;13;F
23732;79,1593,354,695,1730,1255,1616,445;43;F
23742;1383;46;F
23779;657,445,462,354,588,695,793;24;M
23786;793,374,839,1204,885,354,1393,138;38;F
23809;1204,138,1730,762,1255,80,79,791,354,885,793,695,374,839,1593;42;M
23832;654,885,559,791,1616,406,839,79,1335,70,670,793,200,762,80;43;M
23844;354,138;53;M
23848;82,70,695,793,839,246,1730,1616,1593,354,885,149,1383,1180,138;57;F
23850;70,762,406,441,82,1582,654,138,502,80,407,79,1616,559,354;38;F
23856;1326,200,695,1180,1383,138,354,80,793,1730,402,105,1593,70,406;44;F
23866;354,1593,1204,791,246,374,670,247,762,839,852,885;25;F
23894;138,354;53;F
23955;1255,695,1326,70,354,82,150,1730,200,793,670,1616,559,654,490;45;F
23960;657,1326,1180,670,695,1616,354,793,1730,70,105,406,1593,1383,138;19;F
23985;793,1730,1255,402,246,559;43;M
24044;1730,1180,1335,1383,1326,1616,1582,1723,1255,502,1593,793,247,445,695;27;F
24045;1730,762;42;F
24051;424,1616,1204,1383,854,1393,787,490,1326,1730,82,80,354,149,138;36;F
24069;150;45;F
24077;138,654,1593,1204,791,374,793,247,407,1616,354;17;F
24202;670,762,1616,787,728;55;M
24208;1593,445;24;M
24224;588,490,657,654,854,885,1593,762,1255,695,1730,200,670,793,1326;26;F
24251;406,1204,1593,354,670,793,200,1730,695,1335,839,1616,885,445,854;39;F
24267;824,852,854,441,200,1730,70,502,80,407,79,839,1616,654,138;48;F
24351;1730,695,82,1255,80,79,839,1616,791,559,1204,1593,354,885,138;35;F
24354;79,824,149,854,138,728,793,1730,762,80,839,1616,354,654,490;32;F
24362;793,670,200,1730,695,762,502,374,80,1723,1593,354,445,787,728;28;F
24378;1616,793,670,247,200,1730,695,762,80,79,407,1593,354,445,654;52;F
24398;200,695,82,839,824,445,787,1582;35;F
24646;374;65;F
24756;654;26;F
24779;839,1593,885;48;M
24800;1593,1383,490;44;F
24837;1326,138,149,1593,1255,200,502,374,728,670,793,695,1723,1616,787;20;M
24847;79,1204,1593,490,670,1730,762,246,839,1616,885,695,445,200,654;36;F
24852;1593,1383;47;M
24877;670,1326,70,82,762,791,559,354,149,462,1383,787,490,138,728;72;F
24890;1730,793,243,839,1593,885,462,445,1393,654,490,441,138,728,1616;34;F
24891;695,80,445;10;M
24899;762,70,200,1335,105,588,1723,824,1616,559,852,854,654,441,657;73;F
24962;490;71;M
24983;138,728,787,791,1255,82,200,247,1326,670,793,839,1723,559,885;20;M
24988;502,407,1204,138,728,243,79,762,70,695,1730,1326,854,654,1616;29;F
24992;1593,1383;46;F
24996;670,762,1723,728,1616,885;38;F
25021;1255,791,490,793,670,657,1326,80,1383,138,354;36;M
25036;445;43;F
25059;407,80,374,70,695,1730,670,79,445,1616,1593,1383;10;M
25114;695,762,374,407,246,839,791,1593,354,885,1383,1393,787,1180,138;52;M
25131;1593,1383;14;M
25141;670,695,70;43;F
25145;70,839,559;43;M
25162;695,762,670,1255,105,70,82,374,839,406,1616,559,885,149,462;40;F
25171;200,70,885,787,654,657,695,1723,1593,354,490,793,247,839,791;26;F
25173;1593,1383,854;43;F
25209;1326;41;M
25257;657,824,1335,502,793,670,200,402,1204,354,787,490,839;29;F
25388;670,1326,762,791,1204,1593,787;33;M
25397;793,200,695,1393,1180,1730,1255,839,791,1593,885,1616,445;39;F
25403;200,441,490;48;F
25442;82;40;F
25470;1204,885,149,462,657,1326,1255,728,793,670,200,1730,762,374,787;49;F
25474;670,793,200,1730,695,70,1255,374,588,1616,1593,1383,854,654,490;50;M
25530;1730,791,1204,149,657,670,200,695,1255,762,374,1593,885,787,728;74;F
25550;1730,695,839,354,149,1180,138,657;31;M
25556;1180,138,105,695,354,787,559,1204,1593,149,670,793,200,70,406;25;F
25571;728,1255,1723,695,762,354,670,793,200,1730,80,839,885,654,138;28;M
25590;445;45;M
25615;1255,1723,791,1204,852,670,793,1326,1730,1335,839,1616,1593,885,654;30;F
25623;445,787,657,354,1593,1204,791,374,695,200,793,670,762,1723,654;28;M
25636;1593,1383;12;M
25648;1593,1383;7;M
25660;695,1204,354,445,1383,406,246,374,200,670,1730,70,559,149,138;37;F
25671;588,354,654,200,1730,839,1593,885;49;M
25699;1593,354,462,654,490,670,1326,762,374,246,839,791,885,787,728;35;M
25710;441,728;45;M
25748;374,424,138,670,654,1593,243,793,200,1730,490;48;F
25777;670,559,105,402,695,200,247,654,1335,70;50;F
25808;374,1204,787,657,670,793,1255,762,1593,1383,138,200,839,354,885;54;M
25825;70,246,1616,559,852,462,654,441;50;F
25865;82,1335,670,1326,70,402,79,1723,1616,791,1593,852,885,1383,787;71;F
25869;82,1616,445,490;15;F
25871;1730,1255,762,839,354,490,138,885;35;F
25943;1723,1616,559,1593,852,885,787,490,441,1326,728;57;F
25945;374;41;F
25948;1730,82,80,246,1616,138;45;F
26025;406,559,1593,885,462,445,854,1393,654,1730,695,82,246,1616,490;54;F
26075;1383,1593;38;F
26084;695,839,1723,1616,885,1393,1326,445;26;F
26085;885,1723,839,588,105,670,1326,762,1335,791,787,728;76;F
26094;791,1204,885,793,1326,374,839,1383,787,490,657,695,82,1616,1593;30;F
26111;105,79,1730,200,670,793,762,1616,824,354,149,854,654,138,490;41;F
26166;70;51;F
26239;1326,787,885,1593,1383;9;F
26313;670,793,1730,695,82,1255,374,407,824,1616,490,354,462,854,787;50;F
26316;1593,1383;46;F
26319;787,885,1326,1593,1383;43;F
26353;1326,1593,885,1383,787;48;M
26395;1383,695,200,1255,762,1593,787,670,793,1730,374,462,138,839,885;52;M
26400;1593,1383;46;M
26431;80,354,82,502;46;M
26492;1593,1383,791,787,1326;14;M
26506;670,1582,728,885,839,200,1326;34;M
26532;1326,200,70,402,105,246,406,824,791,559,1593,854,787,654,728;75;M
26569;839,1723,787,200,762,885;53;M
26616;1616,1204,1593,1383;43;F
26630;79,839,657,654,1582,885,354,374,588,1616,559,1593,149,1383,138;26;F
26694;82,1616,354,1593,1383,654;57;M
26710;559,885,654,1326,82,374,1616,354,1383,1593;14;F
26730;670,1326,70,82,79,354,793,374,80,246,1616,1593,1383,654,138;36;F
26755;654,246,200,670,82;47;F
26806;1616,793,247,695,1593,354,670,1326,762,374,791,787,728;45;F
26813;246,407,82,1730,670,793,402,839,654,1616,1393,1582;19;M
26831;1730,762,462,1582,490,441,138,247,1326,1180,200,793,670,82,885;55;F
26839;354,149,138;49;M
26853;1593,791,839,246,374,762,1255,670,793,200,695,82,354,1383,138;33;M
26870;787,490,1730,82,762,374,407,246,406,824,1616,1593,354,885,1393;49;M
26876;82,824,1616,149,1383,138;51;M
26883;670,1326,247,200,695,762,374,1335,791,1593,728;45;M
26896;1326,793,670,1730,1255,762,374,79,1204,1593,149,462,1383,1180;54;M
26937;670,82;47;F
27115;502;36;F
27175;1593,1383;40;M
27219;588,1204,1383,657,728,1326,200,839,1616,1593,885,793,670,138,354;27;F
27238;1180,138,787,1383,149,791,1723,839,762,200,728,793,670,885,462;30;M
27259;80,1723,559,1593,793,695,82,502,79,839,1616,354,885,490,138;16;F
27260;670,1730,695,1335,1255,762,246,441,885,559,839,793;34;F
27316;200,1616,462,654;29;F
27411;243,1723;65;F
27459;1616,424,82,70,79,588,354,490,138;35;F
27475;1582,728;46;F
27530;200,695,80,79,839,885;36;F
27563;246,243,588,406,824,1616;28;F
27587;80,793,1326,695,82,588,1616,1593,885,445,1383,787,654,490,1180;40;M
27616;150;54;M
27648;374;15;M
27783;1204,791,406,79,200,670,70,695,839,1582,138;48;F
27794;1383,787,728,670,793,200,70,1616,791,559,1593,654,138;29;M
27878;374;54;F
27918;670,200,588,1616,654;24;M
27948;854,654,588,1593,354,445,787,82,839,1730,695,70,1255,1616,559;34;M
27957;1255,885;51;F
27962;670,407,793,559,1204,445,1383,787,490,200,1730,80,354,149,138;33;F
27969;839,762,354,138;29;M
27974;1593,1383;44;F
27989;150;49;F
28026;150,82,406,654,490;43;F
28044;1593,1204,1383;38;F
28105;654,354,670,1730,374,839,885,787,791,1204,445,695,793,200,1593;26;F
28138;588,839,1593,885,1383,1180,657,441,1730,1616,1393,1582;30;M
28172;70,105;53;F
28173;502,407;28;M
28192;839,105,80,1255,1730,200,407,502,852,354,149,462,1582,654,138;49;F
28198;1204,787,1616,200,354,374,462,490,559,654,670,762,793;26;M
28255;1730,1326,670,441,654,854,1616,105,695,200,70,1335,243,852,657;67;F
28257;791,1383,787,885,354,1593,1204,105,407,80,1730,200,1326,793,670;24;F
28264;793,138,885,406,82,70,445;42;F
28344;150,728;48;F
28365;374,793,1326,670,200,1255,762,839,791,1204,885,728,138,445,354;44;M
28385;1326,247,200,374,824,1616,490,670,1730,1335,243,588,791,441,852;64;F
28386;200,793,695,445;59;M
28402;246,588,559,670,200,1730,374,824,791,1593,787;28;M
28412;82,502,407,79,1616,354,138;40;F
28433;247,1730,695,839,885;26;M
28446;852,1383,787,654,149,138;29;F
28476;79,762,839,354,728,70,406,559,149,138;39;M
28489;1383,1593;45;M
28508;82;43;M
28530;150;39;F
28546;793,374,1593,1204,354,445,787,138,657,728;46;M
28626;728,445,885,654,490,657,82,1326,670,793,200,695,1335,839,854;82;F
28705;1616;61;M
28733;150;57;F
28791;839,1593,149,670,793,200,1730,354,445,854,1255,588,654,657;81;F
28800;1326,82,1616,1383;42;F
28867;1616,1383,787;10;F
28925;490,1383,885,839,79,80,695,200,793,762,670,1616;33;F
28961;502,407;48;F
28966;1730,200,762,1723,728,670,793,70,82,1616,462,787,654,490,441;59;F
29017;502,407;47;M
29037;502,407;13;M
29048;150;46;F
29052;246,424,1335,70,791,247,150,105,243,441,138;44;M
29068;502,407;10;M
29071;885,138,657,654,1383,354,559,246,1255,1730,1593,839,247,1616,374;22;F
29092;502,407;8;M
29116;441,654,854,149,354,1593,1204,1616,839,79,1335,374,502,82,695;47;F
29169;793,1730,654,445,885,762,695,670,200;44;M
29244;150;48;F
29255;149,1593,1616,79,105,1335,80,82,70,1326,407,1383,138;38;F
29258;1730,654,854,559,1616,588,79,82,70,695,200,793,670;56;F
29347;670,793,1326,1730,695,82,1255,374,246,839,791,1204,1593,354,787;27;F
29379;200,80,1593,149,1383,1180,138;46;M
29380;200,670,1326,1730,70,762,374,588,406,791,559,1593,787,654,728;57;F
29432;654,885,852,559,1616,79,80,502,762,82,695,247,839;26;F
29448;762,657,402,105,588,1204,885,670,200,1730,695,243,1616,149,1180;40;F
29460;588,1593,852,1383,670,793,82,402,246,1616,885,445,854,787,138;32;F
29571;70;71;M
29734;762,402,243,1616,462,654,200,824,1593,885,787,138;26;F
29742;105,1723,824,791,354,852,1582,138,657,150,79,246,1204,1593,1383;48;F
29778;1593,1383,728;40;F
29786;670,728,793,200,1730,762,1335,839,824,1593,354,462,445,854,787;30;M
29814;852,354,791,79,695,200,247,793,670,1326,105,1723,1204,1593,1383;9;F
29860;82,1593,1383;24;M
29874;445;13;M
29875;445;13;F
29906;1616,246,79,105,80,441,150;44;F
29926;150;56;F
29943;80,79,354,149,138;32;F
29966;82,670,793,200,1730,695,70,502,407,839,406,354,149,654,728;51;F
29992;402,559,149,490,657,654,354,1593,1616,839,243,502,82,695,1730;24;F
30040;247,1616,1593,885,490;15;M
30086;445;40;F
30107;670,793,1326,1255,762,354,654,138,1730,70,839,885;48;F
30109;445;62;F
30141;462,354,1204,791,588,670,793,1326,1730,762,839,1593,200,695,1616;28;F
30159;657,793,695,1255,374,354,787,138,728,670,1730,82,588,1616,654;64;M
30161;670,200,1730;49;M
30189;70,80,1593,354,1383,138;11;M
30208;82,70,787,490,462,1204,1335,793,1326,1730,695,374,824,1593,354;31;F
30240;138,79,559,1593,354,149,1383;11;F
30273;1326;41;M
30274;1593,138,490,588,79,80,793,1383,657,441,695,762,462,200,670;25;F
30288;559,1593,502,407,839,1616,354,885,490;47;F
30385;1326,670,695,1255,80,1383,70,79,839,1204,1593,885,445;42;F
30405;80,424,839,354,490,138;26;M
30412;1582,1393,441,1335,105,243,406,82,407,1616,246,588,854,654,657;45;F
30414;247,502,402;29;M
30489;793,695,80,1593,354,885,1383,1730,1255;40;M
30492;1255,402,80,246,839,824,1616,1593,354,852,885,445,1383,654,138;36;F
30526;79,80;54;F
30577;728,149,791,1326,670,793,200,150,839,1204,1593,354,885,462,138;43;M
30662;791,1204,243,654,885,1180,657,793;22;M
30712;695,80,243,839,1616,654;23;F
30809;441,1582,138,247,200,105,246;37;F
30829;1326;70;M
30883;1730,695,70,82,79,839,406,1616,559,885,490;46;M
30982;247,200,695,839,1616,559,885,445;33;F
31004;70,406,559,138;30;M
31011;1593,1383;20;F
31032;445,657,138,490,670,82,762,502,80,79,1616,559,1593,852,462;38;F
31039;374,1616,1593,354,787,654,1180,490,138,1326,1730,70,82,402,1723;49;M
31130;247,1730,1255,762,791,462,787,1582,490;33;M
31226;82;46;M
31239;670,793,82,839,1616,490;42;F
31268;374,406,70,138,1730,82,80,407,79,246,1723,1616,1593,490;23;M
31274;1616,1593,885,82;50;F
31297;149,1204,1383,462,445,657,1326,793,1730,1255,1723,1616,852,854,654;42;F
31367;402,79,839,885,149,445,1383;51;F
31544;839,1204,149,654,728,79,1723,354,1383,1180,138,1593,670,793,200;38;F
31570;80,1616,1204,354,149,1180,490,79,406,138,1383;31;F
31593;1383,657,490,1582,424,502,150,402,80,105,79,243,1616,445,82;46;F
31598;82;47;F
31617;1204,1326,854,138,1180,490,670,793,200,1730,82,839,1616,885,462;28;M
31718;138,406;44;M
31794;406,138;44;F
31799;82;52;F
31804;445,462,852,354,407,762,1255,247,1730,82,79,1616,1593,654,490;45;F
31837;1326,247,200,1730,695,762,246,445,654,728,791,787;36;F
31845;670,793,200,1255,1616,1593,354,1582,1180,138;27;F
31847;793,1730,407,1723,1204,82,670,79,839,1593,354,885,149,1383,138;42;M
31861;695,1616,885,445;42;M
31881;82;47;F
31887;82,374,1616,885,490;47;F
31944;70,406,1616,670,1730,885,654;33;F
31958;588,490,445,854,1616,1204,1593,354,149,1383,138;39;F
31966;82;44;F
31971;1616,885;24;F
32049;80,787,793,138,502,200,407;38;F
32056;1326,200,82,502,424,243,462,793,1730,762,588,839,1393,654,490;32;F
32060;490,654,1582,1393,1204,502,80,885;37;M
32089;839,762,1730,670;53;F
32151;82;43;F
32182;695,1616;24;M
32194;80,79,149;35;M
32210;1616;22;F
32258;200,402,445,654,1180,490,1730,70,79,246,1616,82;42;F
32287;82;49;F
32295;82;55;F
32365;839,407,80,374,762,1255,695,670,1730,200,791,885,445,787,793;41;F
32427;402,80,1616,1593,445,1582,654;22;F
32439;695,1593,1616,82,1723,885,654;48;F
32440;82;44;F
32468;1383,1593;44;F
32553;82;46;F
32562;1593,406,588,839,1335,70,1730,200,79,1616,149,1383,654,1180,138;49;F
32597;839,885;36;M
32725;670,793,200,1730,695,374,824,791,1593,354,885,854;23;F
32879;1593,407,1730;38;F
32894;1593,354,445,670,793,200,1730,695,70,82,374,246,406,1616,559;45;F
32905;406,1593,149,787,138,670,200,70,82,80,79,839,1616,354,654;42;F
32906;1326,200,1730,82,502,839,1616,1383,490,80,407,79,354,149,138;49;M
32908;1326,559,70,82,839,354,654,490,1730,80,105,79,852,441;37;F
32938;502,80,246,839,1616,559,1204,1593,354,149,1383,1393,1582,138,79;39;F
32949;793,1730,1255,402,374,407,839,1616,1593,354,885,149,1383,138,728;49;F
32961;559,441;27;F
32978;793,70,402,105,424,1616,559,654,490,82,1593,885,462,1383,138;45;F
32984;1326,200,1255,762,374,79,839,1723,1204,354,885,149,787,1180,138;40;M
32997;246,787,654,1180,82,200,1730,70,243,839,406,1616,559,490,138;44;F
33005;1593,1383;43;M
33128;654,490,839,695;28;M
33147;402,1616,1204,105,138,441,885,852,1730,1593,1383;43;F
33151;1593,787,1383,149,852,354,1204,1616,406,839,588,79,246,1730,138;37;M
33239;695,402,490,200;62;M
33258;82;47;F
33286;82,70,1730,406,559,885,1383,490;33;F
33288;1204,1730,70,149,354,138;44;F
33316;138,1730,885,82;52;M
33340;670,138,149,1593,791,200,1730;27;M
33357;559,839,70,793,695;36;F
33413;82,1335,793,200,588,1723,1616,462,138,1730,762,402,885,728,670;63;M
33432;657,354,1593,824,588,105,1255,200,670,793,1730,695,839,1616,445;34;F
33440;247,762,105,490,1730,402,1335,243,588,824,852,854,654,657;65;F
33441;670,1730,762,1723,791,885,787,654,728,1326,374;39;F
33445;670,885,559,374,70,1326;41;M
33470;79,791,354,1393,80,402,82,1730,105,654,657,1383,1616,1593,138;37;M
33523;354,839,1730,82,1616,490,654;48;F
33558;150,105,243,588,149,1335,1730,80,79,824,1616,1593,852,138,1383;40;F
33564;200,762,82,839,1616,354,490,138,654,1730,70,374,406,559,885;32;F
33566;793,70,354,1730,695,82,762,1723,1616,852,885,445,787,654,490;33;F
33571;105,406,1730,70,1255,374,787,654,138,670,793,695,839,354,885;50;M
33611;407,824;44;F
33668;1204,588,80,82,695,1730,793,670,200,502,1335,1593,462,1582,490;25;F
33691;138,839,1593,354,441,1582,80;32;M
33717;657,138,1582,445,1593,1616,243,105,374,793,200,1730,70,80,79;38;F
33742;200,407,79,406,1723,1616,791,1204,787,654,490,695,354,138,82;51;M
33752;1616,695,1593,354,1383,787,138,728,670,793,200,1730,1255,374,791;40;F
33755;695,1730,200,793,670,1255,839,1616,1393;27;M
33761;1255,200,793,670;33;M
33762;200,1730,80,79,243,852,1383,654,138,354,1616,149;45;F
33823;670,200,1730,70,1255,1616,354,149,462,445,1180,138;41;F
33877;670,70,762,80,406,1593,354,138;39;M
33913;80,79,406,654,670,1326,1730,70,1255,374,839,1616,354,885,138;38;M
33949;670,70,1255,80,79,839,1593;37;F
34025;793,441,1616,695,1730,1326;23;F
34117;728,1326,793,695,402,407,79,1593,149,462,445,854,1616,588,1255;28;F
34142;885,445,1383,787,728,657,670,793,1730,1255,424,1616,1593,441,138;47;F
34150;1730,82,762,402,246,1616,1593,354,1383,441,138;43;F
34185;839,1335,105,1255,82,670,793,695,1730,70,402,374,1616,1593,654;21;F
34187;1730,82,762,839,1616,559,885,854,654,80,105,1723,1593,1383;39;F
34190;793,200,82,105,1593,490,670,1730,79,1204,354,149,1383,1180,138;72;F
34191;79,424,852,1383,1616,657,441,150,502,80,105,445,1582,70,82;40;F
34231;1393,1582;37;M
34239;200,791,654,1326,670,695,1255,374,839,1204,1593,885,462,1383,787;27;M
34254;354,1730,407,424,839,791,462,445,138,670,793,82,80,79,654;39;F
34313;654,839,1393,1582,1616,1723,1730,1180,441,243,1335;47;F
34339;374,247,1326,670,462,1255,70,695,1730,200,762,839,885,441,728;43;F
34340;695,1730,200,670,247,762,1335,839,1723,791,852,728;73;F
34363;79,246,149,490,441,1335,654,1616,824,402,839,885,82,502,407;44;F
34450;1326,200,839,1723,885,1730,82;50;F
34477;149,1204,839,138,1730;28;F
34487;445;45;F
34498;854,559,406,374,762,70,1730,695,852,490,82,1255,839,885,445;53;F
34530;1593,354,854,138,654,445,1616,588,246,105,402,70,695,1730,200;48;F
34621;1393,1582,1180,354,1204,406,70,1730,200,670,559,1593,1383,138,82;34;M
34671;852,824,1723,246,105,70,200,670,1730,82,80,79,839,462,654;36;M
34681;1326;84;F
34725;490,654,149,885,1593,82,1393,1582;40;F
34731;200,1730,70,1255,406,1616,354,559,1593,728,670,695,374,885,654;27;M
34735;885,1180,654,1582,441,657,138,82,247,1383,1393,105,243,839,445;13;M
34825;402;28;F
35089;1383,502,82,200,670,1730,246,588,839,824,1593,885,854,654,490;27;F
35096;695,407,79,1204,1593,1383,490,82,1616,354,885,149,138;38;M
35180;445;49;M
35193;793,670,1326,200,695,70,82,1255,79,839,406,885,445;46;M
35228;1730,82,762,374;50;F
35280;670,793,762,502,374,79,1204,1593,354,445,1383,787,654,138,657;46;F
35300;762,80,105,243,852,885,670,82,1616,791,787,374;41;F
35358;1326;36;M
35359;247,824,424,246,82,200;55;F
35387;1730,839,791,885,445,787,654;30;F
35408;791,1204,354,1383,787,670,793,200,695,70,1255,1616,1593,445;42;F
35415;82,695,1326,793,670,1616,138,354,200,1730,407,80,502,79,839;40;F
35418;793,670,200,445,654,1730,695,839,1616;32;F
35440;79,1616,80,70,105,1383,406,1582,1730,695,1255,1204,1593,354,1180;30;F
35444;354,1593,1204,559,791,670,793,200,82,762,374,839,885,787,728;33;M
35446;200,82,1616,1593,1383;40;F
35498;852,490,200,1730,762,1335,79,588,824,1616,354,854,654,138,728;72;F
35547;70,1593,149,200,1326,670,695,82,839,1616,559,354,654,490,138;42;M
35560;793,1730,1616,1593,1383,1582,1180,138;30;M
35579;462,787,670,793,200,695,70,1255,374,406,1616,791,1204,354,445;12;F
35586;490,791,246,762,1255,82,695,1730,670,793,839,1616,1593,885,654;25;F
35595;839,1723,791,1204,885,670,762,374,406,559,149,462,787,490,728;34;M
35630;445;46;M
35673;1582,657,728,200,105,839,354,654,490;50;F
35720;670,82,79,559,1616,654,490,728;18;M
35802;462,149,1593,670,762,424;24;M
35847;793,200,1730,82,762,502,402,80,839,1593,885,657,695,1255,445;33;F
35856;1335,246,588,824,854,490,138,82,80,1616,1383,654;29;F
35868;1593,1383;41;F
35891;82,1326,793,1616,1204,885,462,787,670,200,1730,1255,374,80,79;37;F
35924;793,70,839,728,670,1730,82,762,1723,1616,791,885,787,490,374;45;F
35997;1582,657,695,200,670,1326,1204,354,1383,1393,787,1180,1593,149,138;37;M
36010;1616,374,793,200,885,670,82;54;F
36024;82,149,354,1383,138,441;56;F
36025;1723,839,246,80,138,670,793,1730,695,374,791,1204,1593,885,654;36;F
36050;374,885,728;7;M
36078;588,791,787,793,1730,695,80,1335,839,1616,354,1593,885,445,654;22;F
36095;80,1723,1393,728,670,1326,82,374,791,1593,885,787;43;F
36134;787,670,793,70,762,1616,885,1593,1383;42;F
36147;670,793,1335,462,138;70;F
36159;852;18;M
36178;657,441,1326,200,695,246,243,824;34;F
36179;793,105,490,246,200,1730,70,762,406,559;49;F
36181;852;56;F
36208;852;60;M
36209;762,80,105,79,839,1616,1204,885,854,138,728,695,70,1255,406;41;M
36215;793,490,654,354,1616,762,200,1730,82,79,839,502,407;54;F
36218;80,1255,762,1335,1616,793,200,1730,82,502,670,407,839,354,490;10;M
36255;670,200,70,80,424,885,654,1383,1593;9;M
36259;852;82;F
36359;374,588,406,1582,654,445,793,695,82,407,839,1616,1593,885,149;24;F
36370;654,787,1616,1730,1326;49;M
36373;82,490,1180,654,885,1593,406,1723,502,1730,670,374,80,1383,138;37;F
36427;445,791,374,793,670,695,1616,406,82,490,654;18;M
36465;1616,149,654,441,762,839;47;F
36521;374;37;F
36546;793,1730,695,1616,1593,885,787;36;F
36559;374,670,1326,1730,149;42;M
36581;670,1730,82,762,246,839,1616,885,854,1180,654,490,138,728,374;33;M
36599;445,695;47;M
36616;1326,839,885,654,762,1730,793,670;39;M
36693;445;38;F
36704;247,670,1393,1582,490,80,79,243,839,1616,559,1593,354,885,654;49;F
36745;793,1326,695,70,82,402,1335,588,406,854,490,200,1730,1616,445;39;F
36749;885,406,762,150,1730,200,80,839,354,149,1383,654,1180,490,138;49;F
36751;354,852,885,854,654,138,670,762,1255,839,1204,1593,1180,728,1383;48;F
36833;1383,1723,1616,105,502,1326,762,1730,824,791,1593,1393,728,787,885;48;M
36845;70,1593,149,854,654,138;31;F
36857;670,402,490,839,200;21;M
36881;445;44;F
36889;1393,1593,105,1255,793,695,70,839,406,885;55;M
36943;654,138,441,200,105,839,1616,885;32;F
36978;1593,1383;63;F
36979;695,1204,149;29;M
37043;1593,1383,728;39;F
37072;1593,1383;7;M
37088;728;40;F
37089;1593,1383;6;M
37094;670,1255,374;30;M
37100;354,852,149,80,1204,1593,1393,654,138,490,1582,1616,79,82,1383;36;F
37111;670,695,1255,762,502,374,839,1204;27;F
37137;374;31;F
37168;695,441,1383,149,885,1204,824,243,1730,793,1326,670,762,839,1616;37;M
37187;1616,1730,70,79,354,1593,149,490,82,80,406,1204,1383,654,138;40;F
37222;490,82;22;F
37226;793,1730,70,82,80,79,839,1616,559,1593,885,149,1383,441,138;43;F
37307;150;71;F
37330;149,354,1593,1204,588,793,670,1326,695,82,407,791,462,490,728;48;M
37371;670,149,354,1723,1180,490,1326,200,1393,1730,695,762,839,885,138;39;F
37430;654,490,728,670,793,1730,1255,762,374,424,246,1616,138;40;F
37482;793,1255,695,354,839;30;F
37588;1326,793,670,1730,695,1255,762,374,1616,1204,1593,354,149,1383,138;34;F
37639;852,839,243,105,247,695,424,354;35;F
37652;1335,402,1730,885,695,824,839,1616,1593,852,462,1383,854,138,149;50;F
37705;82,502,407,1593,1383;48;M
37725;695,1326,445,657,138,490,787,462,149,354,1204,791,200,793,670;29;M
37764;1616,1593,885,657,793,695,1255,839,462,654;31;M
37770;1730,793,695,70,406,1616,559,654;45;M
37771;793,654,441,138,502,80,407,1616,354,885,445,657,839,82,490;26;M
37777;407,502,1593,1383;49;F
37787;502,407,1593,1383;11;F
37798;839;24;F
37800;502,407,1593,1383;8;M
37835;80,670,200,762,374,1335,79,246,1723,1616,791,787,138,728,149;59;F
37846;1393,1582;16;F
37905;728,138,445,852,1593,200,695,839,885;28;F
37911;670,200,1730,1204,1593,1180,138;62;F
37956;150,70,82,1723,406,462,654,138;60;F
37984;839,588,80,670,793,200,1730,695,70,374,1616,1593,1383,654,1204;36;M
38198;1326;41;F
38235;1593,1383;4;M
38264;1593,1383;1;M
38330;407,1180,1204,791,1326,670,793,1730,695,1255,374,1593,354;46;F
38382;824,1616,559,1593,1383;47;F
38424;82,79,243,588,839,824,854,1730,80,1616,654,490,138,1593,354;33;F
38464;105,502,762,247,82,246,1616,1593,852;26;F
38485;490;44;M
38601;1593,243,728,854,588,670,793,695,70,1255,402,374,406,354,824;66;F
38695;854,885,852,1593,824,839,670,695;20;F
38758;200,374;32;F
38825;1393,1582;52;F
38927;670,1593,354,885;31;M
38940;150;18;M
39008;1335,787,728,1326;68;F
39095;149,793,1730,407,1723,791,1593,445,787,670,374,839,654,200,885;31;F
39127;885,149,787,138,762,670,793,839,1593,852,1383,1582,654;29;F
39279;1593,1383;52;F
39326;502,407;28;F
39338;105,854,247,200,1730,70,82,246,1616,559,852,445,490,441,657;36;F
39344;670,793,695,1255,374,1204,1593,354,787,1730;43;F
39374;82,80,588,1723,138,728,1326,70,1616,1204,1593,885,1383,1180,490;42;F
39435;1593,1204,1383;8;M
39474;1383,1204,1593;75;F
39551;793,695,1255,839,885;44;M
39555;1383,354,1593,1204,1616,762,1255,1326,670,793,1730,374,200,839,885;52;M
39578;670,793,374,728;45;F
39614;1616,588,654,138,670,354,885;47;M
39618;1393,1180,138,695,79,105,424,80,246,1616,559,852,854,654,445;32;F
39631;1204,1180,1393,1582,1593,105;40;M
39640;670,839,1593,885;36;F
39683;670,1326,247,200,762,402,243,1723,1616,791,559,885,787,654,728;34;F
39690;824,1204,1593,1393,490,441,657,200,695,82,839,1616,852,885,445;52;F
39693;728,1326;51;M
39763;1383,854,1393,654,490,695,1730,793,247,1255,407,79,1616,354,138;33;F
39891;374,1204,354,1383,654,1255,695,728,138,1616,762,200,793,670;50;F
39904;445;14;M
39919;1383;44;F
39927;150;15;F
39948;138,793,200,1730,762,243,839,791,354,885,787,654,670,695,1616;31;F
40010;1383;11;M
40021;1383;8;F
40022;445;36;F
40029;150;53;M
40032;1383;2;F
40057;559,70,200,105,824,793,670,402,246,588,1616,854,654;43;F
40091;1730,138;37;M
40160;793;63;F
40168;885,839;27;M
40193;445;44;F
40212;445;14;M
40287;406,490,1730,80,1335,79,824,1616,559,354,852,787,1582,654,138;32;F
40291;70,406,247,354,852,149,654,885,839,1593,1383;34;F
40311;445,406,354,654,657,138,854,149,1730,374,246,1616,559,1593,1383;46;F
40329;885,149,445,839,407;21;M
40334;695;25;M
40339;1723,1616,406,559,885,462,1593,1383;24;M
40361;670,793,70,246,406,559,1204,1593,1383,787,654,657;9;F
40393;588,502,670,793,1326,200,695,374,80,246,839,1723,1616,138;38;M
40485;354,885,654,728,490,200,1730,82,1255,762,374;31;F
40510;1204,80,374,82,1730,793,670,839,559,354,885,1383,787;40;F
40532;424,246,105,402,502,70,1730,247,80,1723,559,445,1582,1393,490;28;M
40593;445;13;M
40598;445;14;M
40606;1383;38;F
40663;1255,762,374,79,839,791,1204,1593,354,728,70,402,105,406,559;36;M
40684;1383;6;F
40688;1180,654,728,787,149,1204,791,762,670,407,79,839,1723,1593,354;37;M
40707;354,1204,588,728,1383,1335,1730,1616,791,654,1593,885,200,695,374;35;F
40714;1730,80,407,79,839,1616,1204,1593,354,462,149,445,1383,490,138;33;F
40715;1383;8;M
40750;762,728,138,885,200,670,70,374,1593,1383,787;40;M
40754;1593,1383;8;F
40764;787,654,490,793,1326,105,824,559,1593,1730,82,839,1616,885,1383;47;M
40778;762,70,247,1326,200,80,502,407,79,1616,885,445,1383,1393,1582;10;F
40806;1383,1593;38;F
40813;200,247,670,793,1730,1255,762,374,407,839,1723,791,885,138,728;33;F
40815;657,728,490,559,406,824,80,762,670,70,793,402,1616,885;32;F
40839;82;45;F
40851;654,1383,588,402,762,670,200,1730,70,1723,406,791,1593,787;85;M
40862;1593,1383;48;F
40894;1616;44;M
40900;70,793,247,1326,200,1255,502,80,407,79,354,885,445,1582,441;12;M
40910;490,441,105,1335,82,150,70,80,502,407,79,1616,445,1393,1582;40;M
40952;247,200,1730,82,762,1616,791,354,1593,1383;24;F
40953;885,82,374,1616;48;F
41008;200,70,1616;33;F
41043;79,839,1616,1204,1593,462,670,70,502,80,407,406,354,1383,138;38;F
41077;70;32;F
41113;695,1255,374,79,1204,1593,354,854,657,670,793,200,82,588,1616;73;F
41136;657,588,854,654,824,402;70;M
41162;490,852,1616,246,1335,824;20;F
41164;247,1730,82,105,1616,1582,654,657;29;F
41186;670,793,695,402,588,824,854,654,657;79;F
41197;670,762,105,588,1616,354,445,654,1730,695,1335,854,824,1255,200;60;M
41202;824,588,654,854,657,402;92;F
41231;402,824,854,654;68;F
41272;824,588,657,854,654,402;80;F
41291;670,793,695,402,588,824,1593,885,854,787,654,657;67;F
41307;588,824,654,854,657,402;85;M
41318;670,200,695,791;44;M
41346;791,200,793,1204,1593,670,695,402,1335,588,824,654,657;80;F
41358;1383;45;M
41365;824,588,854,654,657,402;86;M
41369;670,1326,695,1255,374,839,791,1204,1593,354,885,1180;25;M
41475;150,402,105,246,82;50;F
41524;1255,200,793,695,82,1335,105,588,839,1616,559,1593,445,1582,441;54;F
41576;654,1180,657,787,105,407,80,762,1255,70,695,200,1326,670,728;26;M
41597;354,1383,138,80,105,559,1204,1593,728,793,695,839,1616,885,445;33;F
41687;105,70;59;F
41692;670,200,762,787,1383,1593;79;F
41701;839,79,374,82,200,793,670,1593,354,885,149,1393,1383,1180,138;35;M
41746;1383,354,1204,1616,839,243,79,1326,793,670,200,1730,70,374,406;66;F
41757;150;78;F
41795;402,374,793,1730,695,70,80,105,1616,1593,354,885,149,654,138;43;F
41806;150,728;40;M
41851;150;78;M
41899;885,854,445,654,852,824,839,588,1335,402,200,1730,695,670,70;66;F
41950;728,793,1730,695,462;29;M
42062;1730,839,885,149,138;48;M
42078;200,695,1593,787,657;24;M
42117;839,1616,243,105,1255,82,150,70;17;F
42126;559,1180,791,1593,787,490,657,670,82,1255,839,1616,852,445,654;47;F
42154;695,762,402,80,1335,105,79,246,354,1593,149,462,445,490,588;66;F
42158;150;13;F
42233;670,247,695,374,1616,1593,852,445,854,654;23;F
42317;1730,695,374,246,1204,354,885,149,1383,1180,138,728;43;F
42318;670,1593,695,445;55;M
42416;1730,695,70,1255,791,885,657,462,445,1383,1593;65;F
42441;1383,654,138,695,1593,1616,762,670,839;27;M
42465;1593,445,354,1204,791,200,762,80,1723,1616,885,462,728,787,670;41;M
42492;374,791,1255,787,654,657,695,670,200,1730,1204,1593,354,1180,138;43;M
42523;885,839,80,70,82,490,1204,1593,1383,1393,1180,138;44;M
42529;695;31;M
42566;70,79,354,462,1383,728,793,1730,762,374,105,839,1616,1593,670;35;M
42583;1326,670,793,1730,695,82,839,1593,885,149,1180,490,1383,138;27;M
42617;885,1393,787,654,1180,138;23;M
42620;695,1335,80,70,793,670,200,1730,82,1616,1593,354,654,490,138;83;F
42622;854,1393,793,70,762,839,885,1180,1383,1593,1204;4;F
42659;670,793,1730,80,79,839,1616,559,1204,1593,1383,1393,1582,1180,138;9;F
42676;670,70,1593,441,138,793,374,839,1723,787,1616,1730,200,885,654;55;F
42712;1593,1383;45;F
42713;1326;57;M
42750;1730,1593,1204,793,670,657,1582,354,462;22;M
42787;670,1326,200,70,407,559,138,885,793,839,354;47;M
42864;200,791,1326,670,1204,885,793,1730,695,1255,374,839,1723,1593,354;48;M
42906;200,1616,490,654,728,670;45;F
42915;762,1204,354,654,490,138,728,1730,695,374,407,1616,1593,149,445;17;F
42990;1616,1335,1730,82,374,246,839,559,1593,885,1383,138;46;M
42999;246,1204,1593,462,445,793,70,407,79,1616,354,149,854,654,138;55;M
43047;1730,1616,1204,1593,354,885,445,1383,1393,1582,654,1180;35;F
43083;1582,1593,1383;46;F
43117;1255,762,402,374,1335,246,839,1593,1730,695,82,1616,445,490,654;37;F
43120;79,670,793,200,1730,695,82,1255,374,246,1204,1593,354,885,654;65;M
43227;695,1616,1204,1593,354,885,462,445;22;M
43252;374,105,79,246,424,839,406,1593,852,149,1383,1393,1582,1180,138;29;F
43254;490,559,1326,1616,1255,247,424,839,354,885,445,1393,654,728,138;24;M
43298;82;45;F
43313;695,728;46;F
43315;1180,728,657,200,1730,839,1616,1204,885,462,149,138,670,1255,654;53;M
43338;1730,839,407,559,354,138;69;F
43445;150;47;F
43457;70,1730,502,80,407,79,839,406,1616,559,354,149,1582,138;38;F
43485;79,1616,1593,852,793,670,1326,1730,1255,1723,885,462,787,654,728;39;M
43486;670,70,82,762,787,654,374;43;F
43618;247,200,1730,695,82,762,402,407,1616,445,490;34;F
43639;200,80,105,839,559,1204,1593,354,885,1383,1393,138;48;F
43673;793,1730,200,243,1616,852,445,654,441;23;F
43674;839,1723,791,354,852,462,854,1582,1326,1730,1335,1616;40;F
43678;200,695,243,588,1593,854,138,407,1730,82,839,1616,149,654,490;45;F
43694;1204,885,1730,695,1255,374,588,1593;39;F
43708;80,79,462,1180,138;39;M
43713;670,1326,793,695,402,374,105,588,1723,1616,354,1383,138;59;F
43715;150;17;F
43748;1383,462,885,354,1204,246,402,762,70,1730,247,82,654,1616,138;28;F
43755;374,445,657,695,1204,787,1180,138,670,793,1326,200,1730,1593,354;43;M
43811;1326;65;F
43822;1730,79,354,791;53;F
43866;1730,670,441,787,1255,695,82,793,885,654,839,354,1593,1204,1393;43;F
43871;441,502,246,1616,1204,149,70,105,406,1593,354,462,1383,1180,138;61;F
44000;1204,246,80,70,670,200,762,839,1593,354,885,462,1383,490,138;30;M
44033;149,354,374,670,70,1255,839,1593,885,445,793,1730,695,1616,654;35;M
44103;247,200,1730,82,1335,246,824,559,852,654,490,839,695,1616,445;43;F
44139;839,885;30;F
44198;1730;61;F
44222;885,354,1593,791,402,1255,200,793,670,1730,695,70,105,839,445;51;F
44232;79,407,80,502,695,200,445;33;F
44246;670,247,243,1616,559,885,654,657;28;F
44267;200,1616,149,654,246,1393;41;M
44312;728;56;M
44315;1383,462,149,885,852,354,791,80,1335,695,105,839,1723,1616,1593;30;F
44334;793,670,200,695,70,374,406,791,559,1593,354,445,1383,787,138;44;F
44344;1730,406,70;66;F
44351;138,654,885,354,791,588,762,1255,695,1730,200,670,1326,247,793;27;F
44380;1730,80,1204,149,1180,670,793,200,82,1616,885,1383,1393,490,138;50;F
44393;1730,402,824,852,854,654,490;27;F
44454;374,885,695,70,82,1255,762,1335,588,839,824,1616,854,654,657;33;F
44471;1326;51;M
44508;793,1326,200,695,70,1255,762,374,445,885,791,424,402,1730,1616;28;F
44526;670,1326,1730,762,839,1616,791,1204,1593,885,1383,787,1180;41;F
44558;406,502,1255,1730,247,793,200,695,70,374,1616,1593,354,654,787;22;F
44582;1326,1730,82,246,793,695,374,839,1616,1593,885,247,654,1255,1204;33;F
44638;105,588,839,1593,885,787,654,490,670,793,695;24;M
44668;695,445;45;M
44673;70,1255,502,79,406,354,1383,1393,1582,1616,1204,1593,654,1180,138;41;F
44677;695,1616,1593,885;35;F
44707;670,793,762,839,1593;27;F
44760;445;14;M
44764;1616,1255,200,695;50;F
44791;200,1730,695,150,70,82,1255,762,502,402,374,80,1335,407,445;13;M
44820;1616,490;23;F
44823;70,839,1616,559,1593,885,654;41;F
44841;200,1730,407,424,824,445,787,247,695,839,1616,885;31;F
44907;654,728,1616,105,200,670;45;M
44930;402,588,824,854,654;54;M
44950;80,200,695,1616;43;M
44968;1723,1255,793,670,407,445,200,1593,695,247,839;29;M
45001;80,79,462,1180,138;71;F
45028;1730,70,105,839,559,445,654,695;35;F
45039;1616,839,424,79,402,502,70,150,247,1326,670,200,1730,354,149;32;F
45040;138,243,502,407,695,150,246,424,1593,1180,490,247,105;23;M
45105;728,247,762,824,559,885,490,441;36;F
45116;854,1393,1582,441,247,502,246,839,824,559,852,885,654,1616;46;F
45126;200,1255,791,1204,354,670,793,1730,695,374,839,1593,885,654,657;26;M
45183;462,670,1723,588,1204,1593,354,793,70,1255,246,406,559,149,1383;54;M
45219;1593,588,246,407,374,402,200,670,793,1730,695,82,839,1616,885;28;F
45230;374;48;F
45369;839,1204,200,670,793,502,80,1616,791,354,885,787,695,1593,445;28;F
45398;839,791,247,1255,1616,654;25;F
45401;1730,885,787,728,1326;66;M
45466;787,1723,149,654,1593,1255,354,885;35;M
45488;670,1730,70,246,1723,406,1616,559,138;39;M
45588;1335,200,670,1730,695,70,243,406,1616,559,885,149,854,445,1180;36;F
45603;247,402,588,824,854,654;56;F
45644;1593,1383;45;M
45657;247,402,588,824,854,654;90;F
45677;82,490,1326,1730,80,839,1616,1593,354,885,149;69;M
45690;1593,1326,80,1723,885,787,654,490,1383,149;38;F
45704;839,407,502,70,200,793,1326,695,138,728,1616,1593,354,885,654;20;M
45732;82,70,200,1616,559,1593,1383,490,1730,246;9;F
45738;791,824,588,80,695,1730,670,247,82,1616,1204,1593,885,1582,654;24;M
45754;1593,1616,502,82,670,793,200,1730,695,1255,374,839,354,1383,791;27;F
45776;138,728,200,1730,70,82,762,105,588,839,1616,559,885,654;70;F
45845;82,1616,1593,354,490,1730,138;26;F
45851;791,149,138,1730,70,1255,1616,559,885,654;31;F
45856;793,490,374,1335,670,1730,762,839,1616,791,885,787,1582,654,728;31;M
45959;728,787,200,793,670,839,885,1180;33;M
46006;1255,762,374,79,791,1593,354,462,787,654,728,670,839,885,138;30;F
46040;588,424,402,82,70,200,490,670,1335,1616,793,1730,462,787,654;38;F
46087;762,70,695,200,1326,728,354;23;F
46096;406,839,1582,852,885,854,1393,490,670,82,1255,1616,559,654,441;37;F
46171;1616,559,354,885,149,854,1180,138,695,200,793,670,1730,70,839;29;F
46184;354,824,79,1335,82,1730,200,138,1616;35;F
46236;728,138,654,1393,149,1616,1335,885,670,762,374,839,1593;51;F
46267;839,243,79,502,762,670,793,200,1730,80,1723,1616,559,1593,885;47;F
46306;695,839,791,1593,885,445;41;M
46350;247,80,79,1616,354,149,654,441,138;32;F
46351;1616,670,793,1730,695,82,1255,762,588,791,1593,354,149,787,490;30;F
46487;1593,1383;38;M
46523;670,793,200,1730,406,1593,354,149,1383,854,1180,138;86;F
46534;791,728,70,762,354,670,200,1730,402,374,1335,105,243,588,490;65;F
46553;1204,1593,1383,1393,1180;46;F
46586;559,354,1593,1383;15;F
46606;462,445,854,787,1180,200,1730,70,1255,502,80,407,79,839,354;78;F
46618;200,82,502,1335,406,728,1593,588,695,762,374,1616,885,854,654;34;F
46631;502,70,406,354,1255,695,793,1326,82,402,839,1616,1593,445,654;44;F
46698;728,1204,1593,149,441,657,247,1326,670,1393,854,1582,1180,654,150;46;F
46719;1730,695,246,588,1723,1616,559,354,462,1383,654,138;56;F
46782;1593,1204,150,402,80,1335,79,1582,654,490,70,82,246,1616,1383;45;F
46807;354,149,462,1582,1180,787,654,138,670,70,374,559,1204,1593,1383;47;F
46840;885,654;33;M
46841;1593,1383;45;F
46873;588,670,200,762,374,1335,105,246,1723,1616,791,149,787,138,728;72;F
46904;1255,70,793,670,247,200,1730,762,354,885,445,1383,787,1180,138;30;M
46981;247,695,402,105;19;M
47009;1204,762,82,1730,670,793,1326;22;M
47014;839,1730,654,490,82,1616,150;43;F
47023;670,1326,787,728;75;M
47084;1593,1383;36;F
47113;1582,1593,1383;42;M
47141;1593,670,1730,695,82,354,490,150;17;F
47160;82,79,1616,885,1180,490,138;22;M
47198;1616;49;F
47211;1593,1383;29;F
47237;1383,1593;7;M
47246;1616;14;M
47247;695,502,374,407,105,1723,1204,1593,354,885,445,787,1616,670,793;27;F
47263;793,695,82,80,1616,1593,1383,657,354,1204,791,374,1255,670,150;37;F
47275;402,1335,824,588,1326,138,1180,854,791,1255,670,1616,1204,793,1730;41;F
47284;80,246,793,1255,762,402,79,839,406,824,885,490,1335,1616,559;34;F
47307;670,793,200,1730,695,1255,1204,1593,354,1383,1180,441,138,374;37;M
47318;150;44;M
47335;1593,1383;78;F
47344;150;38;F
47424;839,791,885,354,462,1730,559,1204,654,82,490,149,407,502;31;M
47463;105,885,793,839,559;43;M
47466;150;15;F
47476;1616,670,839,885;41;M
47480;150;43;M
47518;793,670,839,441,654,885,1616,424,80,695,247;21;M
47521;200,793,670,70,762,407,406,559,728;25;M
47543;70,82,246,559,1204,1593,462,1180,138,728;48;M
47585;787,1616,588,374,670,200,1730,695,70,1255,105,243,406,559,445;60;F
47606;1204,670,1730,695,82,1255,502,79,1723,1593,354,149,1383,654,728;42;F
47612;670,787,374,1326,445,885,354,1593,1204,791,839,1255,695,200,793;49;M
47700;1723,243,793,200,402,1335,839,824,1616,559,885,854,654,490,441;48;F
47773;1593,1383;74;M
47804;728,654,1383,670,1730,762,1616,1593,885;47;F
47809;105,839,406,654,1730,1616,1204;50;F
47816;445,441;14;F
47835;502,246,1616,787,654,1593;50;F
47839;445,441;49;F
47879;247,1723,1593,374,885;22;F
47907;247,1730,762,1593,441;52;F
47922;200,670,1730,70,82,762,1335,105,839,406,1616,1593,885,441,654;51;F
47953;150;47;M
48010;1204,852,1616,559,1593,243,105,80,1255,70,695,1730,793,670,138;30;F
48043;80;31;M
48046;1593,200,670,793,1255,354,445,1393,1582,654,1730,695,70,839,885;39;M
48077;1326,247,200,1730,150,762,407,105,79,243,406,852,462,657,70;47;F
48084;793,1593,138;42;F
48124;670,793,1326,247,502,200,80,407;59;M
48135;247,200,839;37;M
48190;246,1730,82,70,402,406,559,490;49;F
48257;200,1730,424,246;36;F
48355;787,1383,445,839,407,374,762,82,695,670,200,1255,243,1593,654;21;M
48420;1730,839,70,1335,1616,885,445;49;M
48455;762,670,793,1326,1730,695,70,1255,839,1204,1593,354,787,654,657;25;F
48458;150;48;F
48483;1255,105,445,657;63;F
48501;1593,1383;44;F
48503;407,839,1723,791,1593,462,1383,670,1730,695,1616,1204,354,885,445;25;F
48506;657,1730,695,1255,200,793,670,762,1335,839,559,490,82,1616,445;45;F
48536;793,402,1335,246,588,824,1616,1593,354,852,462,854,1393,787,654;67;F
48601;1730,82,839,1616;74;F
48656;1730,354,787,670,1326,839,1593,885,1180,138;70;M
48675;654,490,243,1616;26;F
48689;657,149,791,79,1255,200,670,354,885,787,138,1383,150;48;F
48710;490,787,354,1593,791,374,762,82,670,793,200,1730,839,885,138;34;M
48719;1593,1383;45;F
48726;791,885,787,728,1326;40;F
48755;1593,1383;8;F
48770;150;15;F
48821;695,70,1204,1593,885,839,406;57;M
48856;246,1255,70,374,793,670,200,695,1730,82,80,839,791,354,490;28;F
48863;502,407;29;F
48947;670,588,407,839,1593,787,654,490,657,793,1730,1616,445,854;23;F
49014;138,441,354,1204,559,839,793,670,82,1593,149,490,654,695,885;24;F
49042;200,1730,70,787,1383,1593,424,105,80,1180,138;41;F
49052;445,441;61;M
49096;407,374,1255,82,695,1730,200,793,670;20;F
49099;670,1180,354,791,80,1255,79,839,793,462,1383,1593,149,374,138;27;M
49136;246,791,885,445,1393,787,490,728,200,1730,695,70,1255,762,559;44;M
49138;502,402,80,105,79,791,1593,149,654,695,82,1616,885,445,728;42;F
49237;1383,654,138,246,406,559,1593;38;F
49251;1723,791,787,728,1326,670;39;M
49258;246,406,559,1593,1383,654,138;61;M
49291;1730,1616,654,441,138,374,839,1593,854,657,490,502,793,670,885;18;F
49345;441,791,246,105,1335,559,70;42;M
49356;490,1582,657,854,1593,1723,839,1335,502,670,885,793,1730,1616,654;18;F
49359;445,670,1730,82,105,839,1723,1593,354,885,462,654,490;40;M
49388;1730,1204,138,1180;41;M
49419;654,885,791,374,70,1730,105,406,138;30;F
49430;70,105;26;M
49457;787,105,374,502,1255,82,150,200,793,80,407,406,654,138,70;46;F
49468;70,105;37;M
49582;787,445,854,354,1593,1204,1616,824,588,1730,200,247,793,670,695;25;F
49591;559,406,793,105,80,402,200,670,1730,70,1204,354,1383,1180,138;75;F
49603;105,70;38;M
49639;762,1616;40;M
49766;670,793,1616;33;M
49767;374,105,839,1723,1616,791,885,1383,1180,138,1326,1204,787;51;F
49875;1593,1383;67;F
49908;1593,1383;67;M
50049;839,1593,1383;41;F
50084;200,1730,1255,762,70;70;F
50086;670,200,105,1255,852,1730,82,839,1616,854;62;F
50102;445;37;F
50217;695,70,374,105;28;M
50224;80,402,79,588,1616,852,462,654,728,70,762,105,243,406,559;69;F
50245;374;41;F
50264;138,490,654,787,462,354,1593,1616,839,105,762,70,1730,247,793;20;M
50298;791,1616,824,839,424,246,1335,374,793,670,200,82,762,559,1593;50;F
50316;695,374,1335,407,462,79,670,793,1204,1593,354,445,1383,787,654;48;F
50362;793,200,80,354,138;32;F
50390;793,1730,150;16;F
50574;200,1730,243,588,1616,854;68;F
50615;1180,1204;62;M
50617;793,670,200,1730,695,70,1255,80,79,105,839,1616,462,490,445;41;F
50625;791,445,787,490,854,670,793,200,1730,695,1255,374,839,1204,885;26;M
50640;1730,588,839,354,854,787,793,407,1593,654,441,695,1723,885,445;30;M
50668;1204,787,654,1326,670,793,200,1730,695,70,105,406,559,354,138;48;M
50698;1616,441;17;F
50742;793,1326,695,502,374,80,407,246,839,354;46;F
50743;1730,82,246,354,462,654;68;M
50747;1593,1383;86;F
50826;150;45;F
50847;354,787,1180,654,138,670,793,1326,200,1730,695,70,406,559,1204;43;M
50908;502,200,1730,695,1255,374,839,791,1326,793,670,787,654,1593,657;38;F
50946;1326;51;F
50971;793,670,1616,791,1593,354,885,149,787,138,1383,1582,1393,1204,1180;37;M
51023;1383;45;M
51046;728,441,105,793,502,243,149,670,1730,1255,839,1616,354,885,138;61;F
51073;445;41;F
51076;150;33;M
51102;1383,654,441,728,588,502,82,695,70,839,1723,406,559,354,885;65;M
51131;1730,839;31;M
51138;150;45;F
51143;82,441,1616,1204,1383,1393,787,490;32;F
51168;885,1593,1383;65;M
51172;670,793,200,1730,695,70,82,402,1335,1616,559,445,654,441,657;51;F
51173;445,200,1335,79,854;75;F
51189;1326,1180,138,787,670,762,374,149,728;55;M
51238;1593,1383;67;F
51256;670,200,82,1593,490,1730,70,1335,246,424,243,854,654,138,657;69;F
51294;670,200,105,787,654,793,1730,70,82,762,1616,728;41;F
51310;1616,502,407;42;M
51363;885,1593,791,1723,374,502,762,1326,728;43;F
51380;1335,588,559,1593,852,654,490,762,824,728;45;M
51403;247;47;M
51459;70,82,243,406,1616,1204,1593,1383,1180,138;63;F
51494;670,200,70,1255,502,1730,82,243,1616,559;62;F
51564;839,79,374,762,70,1326,793,670,1730,695,138,657,80,1593,1383;40;F
51601;80,374,502,82,695,200,1326,670,79,1593,354,762,1616,654,657;42;M
51651;150;15;M
51668;1593,1383;44;M
51823;1723,670,793,1326,695,80,79,839,885,1180,138,1204,1593,1383,728;7;M
51914;670,793,200,1730,695,82,762,105,79,1616,1593,354,852,654,657;43;F
51977;1383;12;F
52000;70,105;52;F
52002;1383;8;F
52008;670,1326,247,82,246,445,441,200,1616,654;23;F
52013;1255,1616,374,670,793,695,885;29;M
52035;502,824,1593,852,885,1383,1730,82,70,657,1255,1335,105,588,728;63;F
52072;1326,1180,654,462,1616,406,839,374;28;M
52115;670,200,695,1255,762,588,839,885;66;M
52137;462,1730,70,82,80,79,246,406,1616,559,354,149,885,490,138;51;M
52167;854,787,138,246,1335,502,1730,200,695,82,79,1616,445,654,490;32;F
52190;793,200,243,670,1326,1730,762,105,1723,791,885,462,787,654,728;53;F
52203;559,1204,654,670,793,79,839,1616,885,1180,138,728,1730,70,762;47;F
52218;670,793,1730,695,70,1255,502,374,79,105,839,1616,791,354,1383;30;M
52226;1730,247,200,695,82,79,839,1616,559,1593,149,1383,654,490,138;26;F
52275;1255,793,670,200,1730,695,762,80,407,1616,791,1204,1593,354,445;37;F
52346;80,1593,1383,1582;41;F
52450;502,695,1326,793,247,762,80,79,1383,654,657,839,1593,885,490;8;M
52565;1593,1383;61;F
52572;588,1616,885,445,854,1393,654,441,728,402,762,82,70,1730,1326;63;F
52599;670,793,1326,1730,1255,502,80,406,791,1204,1593,445;78;F
52640;406,1730,200,695,70,839,1593,354,885;42;M
52653;670,762,885,787;33;M
52696;82,1616,1393;47;M
52705;793,670,1730,695,1255,407,839,1616,791,1204,1593,354,885,445,657;28;F
52763;791,854,695,79,1723,1593,354,885,200,793,670,82,80,105,839;71;F
52814;1204,1593,1383;36;M
52837;670,793,200,695,82,80,105,79,728,839,1723,1593,354,885;14;F
52846;243,1393,670,1730,1255,502,839,824,1616,354,885,149,654,441,138;33;F
52870;246,406,654,695,70,502,80,1335,105,588,839,1616,559,885;43;F
52878;670,793,200,695,82,80,105,79,839,1723,1593,354,885;71;M
52909;670,1326,762,1723,728,1383,559,885;20;M
52930;670,793,200;56;M
52941;588,374,82,70,695,200,793,246,670,1723,1593,885,654,490,138;33;F
52951;787,728,670,793,200,695,82,80,105,79,839,1723,1593,354,885;42;F
53020;670,695,1730,1255,70,105,1616,559,1593,462,854,654,441,728;72;F
53036;247,695,82;15;F
53047;793,1255,374,559,791,138,1204,1616,839,762,1326,728;25;M
53050;1730,1723,374,1255,200,1326,1204,1593,354,1383,787,670,70,441,406;56;F
53073;1616,670,793,200,695,82,80,105,79,839,1723,1593,354,885,787;8;M
53076;762,670,793,200,695,82,80,105,79,839,1723,1593,354,885;12;F
53142;670,793,200,695,82,80,105,79,839,1723,1593,354,885,728;42;M
53159;670,695,354,839,885,654,787;29;M
53162;80,1616,654;29;F
53188;839,354,762,138;35;M
53310;695,1730,1326,670,70,138,441,1393,793,200,105,246,588,1593,1383;34;F
53371;1593,138,247,200,1730,762,407,79,588,354,885,445,787,654,1180;70;M
53393;138,462,354,1593,1204,791,407,374,1255,695,1730,200,1326,793,670;24;M
53454;793,247,200,762,407,79,839,1593,354,885,149,445,787,654,1180;71;F
53611;1593,1383;47;M
53676;82,402,80,105,1393,138,247,1730,246,1204,1593,354,149,654,490;29;F
53689;839,1616,354,885;18;F
53691;1326;71;M
53735;1326;67;F
53839;200,695,70,1255,762,79,839,1723,854,787;45;F
53871;246,791,445,787,728,1204,462,670,793,138,1723,1593,354,1383,1180;26;M
53878;670,793,200,695,374,1204,1593,787;15;F
53888;1616,1593,1383;44;F
53916;70,424,1593,1383;13;F
53924;1593,1383;9;F
53980;1593,1383;43;M
54002;728,654,445,149,407,1335,1255,762,82,70,695;36;F
54067;70,105,1335,588,406,559;71;M
54103;588,407,1335,1383,445,354,1204,559,374,1255,695,1730,200,793,670;16;F
54137;762,502,374,105,559,354,885,657,670,793,70,839,406,1204,1593;47;F
54139;670,885,1180,1616,839,243,105,70,200,793,1204,441,138,1383;21;F
54200;670,1255,80,559,1204,354,885,1582,654,839,79,1730,82,407,502;39;M
54210;1730,787,1582,105,80,839,406,559,885,1593,1383;7;M
54240;1593,1383;51;F
54270;885,462,138;66;M
54312;79,374,82,70,80,839,138,441,1582,1393,1383,885,1616,406,1723;16;M
54323;1326,791;65;M
54370;79,374,1255,695,670,793,200,1730,762,839,1593,354,885,149,138;53;F
54372;1593,1383;9;M
54385;1180,1730,200,70,762,839,559,885,787,1593,1383;9;M
54406;354,1730,445;44;M
54413;406,824,149,1730,82,1335,246,588,1616,559,354,654,490,138,441;54;M
54471;1616,105,762,1730,70,793,670,82,588,839,559,885,149,490,728;45;F
54474;441,354,138,1326,793,200,1255,1335,1723,462,787,657,728,670,762;65;M
54502;150,1616,1582,657,490,791,824,82,588,654,441,1335,402,246,243;53;F
54541;406,374,1593,654,793,1730,695,70,762,839,1616,885;42;F
54588;839,885,138,1180;30;M
54752;793,1730,82,762,1616,885,854,80,407,588,149,445,138,728;32;F
54824;854,445,462,885,791,200,793,670,1730,695,1255,246,1593,354,1393;26;F
54837;654,657,490,854,824,246,374,82,70,695,1730,200,793;39;F
54886;1335,588,138,657,490,1393,149,885,354,1616,79,407,80,502,82;42;M
54949;82,1255,407,246,1616,791,1204,149,462,445,490,138;23;M
54972;1335,82,793,695,70,588,824,559,354,1593,149,1383,854,654,138;52;F
55045;138,728;32;F
55083;374;72;M
55096;1730,70,82,839,406,885,654,490;32;F
55109;200,1326,791,1204,1593,728,793,762,70,695,1730,839,1616,354,441;35;F
55131;824,1616,791,1204,1593,354,885,149,462,445,854,1393,787,138,657;27;M
55142;762,80,79,1723,1204,354,445,1180;22;F
55166;80,105,243,1593,787,441,1326,374,1723,1616;45;F
55179;105,424,1593,885,138,793,1730,70,762,407,246,839,559,354,654;49;F
55268;670,200,80,1180,490,138;38;F
55332;82,1335,852,150,695,502,80,407,79,1616,354,490,138,657,728;38;F
55363;1326,1730,70,1616,1582,1393,1180,657,138;38;F
55608;150;41;M
55610;657,762,82,1730,200,793,670,149,1582,490,138,1616,354,885,654;30;F
55627;793,490,82,695,1730,200,728,787,1383,885,1593,791,762,670,374;45;F
55641;791,1204,1593,1326,374,1393,793,695,728,885,354,839,762,1255,1730;58;M
55678;839,824,1616,490,138;27;F
55707;1180,1204,1593,1383;33;F
55742;150;15;F
55788;1335,588,200,793,1730,70,374,406,559,441,670,762,791,787,728;55;M
55827;1326;48;M
55839;793,695,70,1723,559,885,462,654,490,138;36;F
55840;105,79,246,424,406,1616,559,445,1383,1582,654;41;F
55865;1180,1383,149,407,200,1730,246,354,138;31;M
55866;246,793,1326,247,82,150;16;M
55938;670,793,791,559,1204,354,1593,149,445,200,247,1383,787,441,138;52;F
55940;670,762,374,791,854,787,728,70,402,1335,105,588,406,824,559;82;F
56003;1326,247,150,246;20;M
56004;791,670,793,1326,79,1383,654,441,138,695,80,839,1616,354,1593;34;F
56008;462,787;17;F
56040;1730;36;M
56057;1383,149,885,839,1335,70,1730,793,79,1616,1204,1593,354,490,138;32;F
56087;852,354,1204,1335,728,138,654,149,885,1593,1616,839,1730,247,670;32;M
56101;1326,247,150,885;48;M
56184;793,82,654,490,138;31;F
56198;1326;71;F
56253;149,1730,200,70,406,502,1383,1180,138;49;M
56255;502,105,1593,407,79,246,445,839,559,885,149,1383,1393,1582,138;39;F
56263;445,670,1730,695,105,1593,354,885,787,793,200,1616,490,441,657;23;M
56278;793,105,247,82,79,243,839,654,80,1616,1593,885,149,1383,138;49;F
56287;839,885,654,1616,490;51;M
56321;406,1730,1255,490,138,728,82,80,79,839,1616,885,1593,1383;9;F
56323;1593,462,654,1616,354,149,138;24;F
56361;1616,824,839,588,1335,374,762,1255,82,70,695,1730,247,793,670;24;M
56402;1723,787,1204,354,793,407,695,1326,200,1730,1593,1616,791,885,670;21;M
56415;406,243,424,502,762,695,200,247,70,82,374,588,1723,1616,1326;37;M
56461;70,105;72;F
56469;502,407,791,670,793,247,200,1730,695,105,839,885,787,1582;34;M
56576;1593,1616,374,1730,200,138,654,354,559,246,105,762,70,1326,793;21;F
56585;70,839,406,559,1593;50;F
56602;1616,1393,654,490,441,793,247,695,82,80,839,559,885,445,1582;19;M
56666;1593,1383;40;F
56680;407,839,1723,1616;19;F
56688;1593,1383;4;F
56702;1593,79,670,793,200,1730,1255,762,374,1616,791,1204,445,1383,787;50;F
56718;1593,1383;6;M
56726;728,670,793,695,1255,762,374,407,79,839,1616,1593,354,885,445;39;M
56728;1593,1383;8;F
56757;852;54;F
56772;793,670,200,1730,1255,105,1723,406,70,762,1616,559,654,490,657;50;F
56797;105,670,200,1326,70,791,787,654;59;F
56802;670,200,402,406,824,791,839,762,728,138,787,885;27;M
56847;1335,406,374,70,670,1326,559;34;F
56864;441,138,657,1616,1730,200,793,762,839,885,1593,654;29;F
56866;728,657,1616,1730,793,200,762,839,1593,885,654;27;F
56872;1582,787,1383,445,354,1593,1204,791,374,1255,695,1730,200,793,670;45;F
56891;149,462,490,138,728;18;F
56908;200,793,670,246,79,407,502,82,1730,588,1616,354,787,654,490;41;F
57005;243,839,654,200,70,82,80,246,1616,354,885,149,1393,1582,138;50;F
57023;374,105,424,462,445,1393,657,728;29;M
57043;839,445,1255,695;53;M
57072;1326,200,695,762,407,670,791;20;M
57079;138,502,407,1616;40;F
57170;791,374,762,490,728,559,885,654,1616,406,839,70,1730,670;26;F
57172;200,70,82,762,839,406,1616,559,354,885;61;F
57251;654,1593,793,1730,200,885,354,1616,839,80,695,670;22;M
57255;762,502,1180,1326,200,1730,82,79,406,695,70,1616,559,654,657;33;F
57305;407,502;55;F
57323;654,670,793,200,1730,695,374,80,839,791,1204,1593,354,885;20;M
57500;793,824,654,728,670,1255,762,374,1593;48;M
57511;854,787,588,1335,502,82,70,1730,200,654,728,670,762,839,885;21;M
57560;1593,1383;11;M
57579;1593,1383;9;M
57605;424,852,462,490,200,793,670,374,246,839,1616,1593,885,654,728;41;F
57691;200,374,246,424,243,1204,1593,354,885,149,1383,1393,1582,1180,138;38;F
57746;1593,1383,670,793,247,695,1255,762,839,1723,354,885,445,787,490;29;M
57772;824,1616,1593,445;29;F
57777;695,1730,200,1326,793,670,762,402,1616,791,1593,885,445,787,654;38;M
58015;824,138,1730,695,1255,588,839,1593,885,445;46;M
58018;105,374,70,695,793,670,200,1730,762,80,406,1616,559,149,138;38;F
58031;407,1616,885,138;68;F
58035;374,79,354,149,1383,80,670,1326,1730,762,1616,791,1593,787,728;43;F
58228;670,793,200;28;M
58262;200,1255,374,80,407,791,354,885,138,670,1730,1723,839;32;M
58379;200,695,1616,1593,445,490;35;F
58380;670,793,695,246,839,885;39;M
58390;839,1723,1593,354,654,441;23;F
58429;80,839,1723,406,824,559,1204,885,149,854,728,138,654,1593,1383;41;F
58475;854,787,490,885,1593,1616,824,79,1255,82,1730,670,793,200,839;32;F
58477;885,354,839,246,1730,200,793,138,1326;33;M
58479;793,762,839,1723,406,791,885,787,728,670,70,374,1616,1593,1383;38;F
58495;852,559,839,246,762,1255,793;29;F
58504;793,200,82,1255,80,79,490,670,695,374,1335,588,1616,1593,354;37;F
58505;1730,670,246,695,354,149,1326,374,787,793,762,462,1180,138,728;24;M
58510;105,657,1326,502,1593,354,885,490,441,407,588,839,149,1180,138;53;F
58564;657,787,1593,1204,407,374,670,793,200,1730,1255,839,354,885,445;47;F
58571;1204,839,407,762,695,670,793,200,1730,1255,374,1593,354,885,138;31;M
58588;1730,695,839,354;18;M
58643;670,793,1730,839,1616,1593,354,885,149,854,654,1180,138,728;30;M
58669;1383,1255,1326,791,1204,670,793,200,695,374,839,1616,354,149,138;31;F
58680;105,1255,1730,200,670,1326,247,70,246,406,1616,559,854,654,490;28;F
58685;80,70,200,670,793,82,1616,354,149,1383,1582,654,490,138,406;34;F
58727;502,407,1616,885,138;71;F
58740;670,200,695,374,1593,354,787,138;31;M
58757;80,407,246,424,1723,885,462,445,787,654,490;20;M
58758;247,670,793,1326,1730,200,695,1255,80,839,1593,354,885,787,657;34;F
58768;1326,787,138,728,670,793,200,695,1255,374,791,354,462,1383,657;31;M
58776;1730,1255,402,824,1616,854,654;35;F
58822;1730,762,462,445,654,490,657;35;F
58843;762,1730,695,82,502,80,354,1383,138,839,559,1204,1593,654,1180;33;F
58899;885,354,1593,1204,1616,80,374,70,670,200,1730,695,762,839,791;36;F
58905;654,588,424,1730,70,82,80,406,1616,1582,657,1593,1383,490,138;25;F
58919;200,1730,70,374,105,246,1723,406,791,854;42;F
58978;1326,670,402,728,885,1593,588,1335,1255,793,1730,374;59;F
59085;200,1730,70,82,80,839,1616,559,854,1393,654,490;38;F
59108;1326,762;37;F
59135;354,138,670;36;M
59142;657,138,1180,1393,445,1593,1204,791,793,670,695,1255,762,839,885;31;M
59184;885,445,787,654,1180,490,138,1326,793,407,839,1204,1593,354,149;32;M
59208;200,407,1204,1383,787,354,1593,791,374,1255,695,793,670;36;M
59282;654,490,82,1616;33;F
59334;138,149,1593,1383;51;F
59429;149,138,728,1326,762,79,839,885,80,1730,247,695,1255,445,490;29;F
59562;654,1616,839,243,695;31;F
59580;793,1730,695,1255,374,80,839,1616,1204,354,1593,885,445,1383,490;33;F
59608;588,728,1180,787,354,1593,1723,839,374,762,1255,200,1730,885,490;36;M
59709;1616,1593,1393,787,138;40;M
59724;1593,654,885;34;F
59794;1326,80,374,247,670,793,695,1255,1593,354,885,1383,1582,654,138;23;F
59842;150;44;F
59854;402,1335,246,839,559,354,852,885,149,490,138,70,854,654,1326;35;F
59895;402,588,824,854,654,657,728;36;F
59905;695,670,793,1335,588,1593,854;32;M
59948;1730,695,1255,1593,793,839,354,654,1180,138;32;M
59959;200,70,728,138,1180,462,1616,670,1730,82,762,374,1593;71;F
60054;445,787,490,1383,80,70,200,670,82,502,407,79,354,1393,138;39;F
60103;854,1393,445,885,354,1593,1616,406,839,1255,70,200,502,80,407;45;F
60199;1593,1616,1255,762,374,80,407,79,406,793,695,839,654,885,728;22;M
60305;657,854,149,354,407,80,695,200,670,1326,559;27;F
60324;502,824,854,490,1730,82,1335,1616,407;32;F
60341;445,728,82,407,1723,1616,885,462,441;28;F
60387;82,502,80,79,1616,490;34;F
60419;149,1593,1616,1730,793;28;F
60456;654,1582,354,793,1730,1593,885,1383;31;F
60528;70,105,406;58;F
60586;406,839,502,762,70,150,82,1730,243,1616,654,490;16;F
60596;200,82,246,1616,445;39;F
60693;1593,1204,1180,588,149,462,1383,490,657,200,1730,82,70,406,138;45;F
60757;1204,1593,787,657,728;39;M
60813;839,885,149,1255,374,791,354,445,1616,670,1593,1204,695,793,1730;45;M
60936;670,793,1616,1593,354;33;F
60999;824,588,670,793,1730,695,1255,1593,138,657,200;39;F
61010;354,1730,490,138;61;M
61028;200,1730,695,1255,374,791,1204,1593,354,462,445,787;58;F
61045;1593,1383;46;M
61050;695,70,588,406,1616,559,654,657;23;M
61103;1593,1383;12;F
61125;1255,839,406,885,657,200,1730,82,762,105,246,243,490,559,654;37;M
61131;1593,1383;7;M
61132;1335,1383,445;76;F
61148;374,670,1255,502,1582,354,654,70,1730,1326,695,1616,559,839,885;26;M
61170;654,149,1593,1616,138;35;F
61248;1593,1383;44;M
61290;670,762,824,885,1383,1393,787,654,138;27;M
61308;1616,82,793,1204,728;35;F
61320;791,374,762,1255,82,695,1730,200,1326,1723,1616,885,1393,1582,654;11;F
61453;1335,670,1326,1730,70,374,406,559,787,728;34;M
61471;79,791,1593,1204,354,1383,728,793,670,695,1255,80,839,1616,885;32;F
61563;441,657,793,1730,695,105,445;61;F
61567;354,149,462,138,728,787,1383,885,839,80,762,1255,695,793,670;33;M
61586;502,762,82,490,885;28;M
61617;670,793,1326,200,1730,695,1255,762,374,1616,791,885,787,654,728;45;F
61629;70,762,407,839,824,559,445,1180,728,1616;22;F
61800;670,247,762,407,1593,445,787,1723;24;M
61815;502,80,407,1616,138;11;M
61847;1593,854,70,402,105,559;72;F
61857;1730,374,839,1593,1383,138;38;M
61864;793,1730,695,82,1255,762,374,839,1616,791,1593,885,654,728,490;30;F
61901;374,79,246,424,1723,1616,885,462,670,793,762,80,839,1593,1383;51;F
61930;490;23;F
61962;1730,762,787,728,1326;68;F
62012;1326;27;M
62018;200,1730,824,1616,1593,354,149,1393,787,138,670,1383;24;F
62042;670,793,200,1730,695,1255,762,79,246,839,1204,1593,354,462,445;28;F
62052;445,854,762,588,1723,462,670,200,243,839,1616,1593,354,885,490;25;F
62131;670,80,243,1593,354,1393,787;19;F
62152;1383,728,138,839,246,374,82,762,695,670,793,1730,1255,1593,490;31;F
62213;82,762,374,243,1593,885,1383,654,490,728;69;F
62226;839,1723,670,200,1730,762,374,1616,354,1593,885,149,490,138,728;62;F
62263;70,793,670,695,82,1255,374,80,406,1204,1593,885,462,854,787;23;F
62372;1593,462,654,559,138,354,791,1335,406,445,1616,695,70,105,246;49;F
62433;200,354,559,82;58;F
62458;490,138,839,885,1383;30;M
62516;80,138,839,70,407,1730,200,82,1616,354,424,79,502,1255,150;51;M
62533;374,105,445,657,490,247,695,82,1335,839,1616,559,1593,354,885;22;F
62568;79,559,138,728,82,200,1730,695,70,1255,80,1616,787,1582,654;39;F
62685;402,657,654;35;M
62717;728,787,1730,1326;86;F
62730;791,559,1204,354,462,787,490,793,200,1730,70,82,762,406,1616;38;F
62803;1393,787,138,728,354,885,1593,762,82,247,80,246,839,559,1383;21;M
62806;1593,462,1326,490,695,1255,354,654,1180,728,441,670,793,1730,374;45;F
62816;787,1582,490,1730,670,793,1326,82,374,1723,885,149,1383,654,1180;43;M
62936;670,793,200,762,374,407,243,839,787,79,354,885,1383,854,138;29;F
63010;149,654,441,670,1730,695,70,374,1335,243,1616,1593;48;F
63025;200,1730,1335,1593,445,490,138;70;F
63033;787,1730,200,670,793,695,1255,79,839,406,1616,559,885,445,654;57;F
63037;406,1730,82,402,80,559,1593,354,885,149,854,1582,1180,490,138;44;F
63073;670,793,695,839,1723,1616,1593,885;27;F
63102;1326,374,407,445,787,1180,657,695,791,1204,1593,354,1730,200,670;32;F
63128;1730,82,1616;48;M
63178;82,1326,247,200,70,80,105,839,1616,852,885,462,445,654,441;25;F
63199;670,762,1616,791,885;50;M
63259;695,1326,402,80,407,105,654,138,657,793,670,247,200,1616,445;26;F
63311;1335,200,670,1326,1730,70,762,374,406,791,559,787,728;57;F
63341;1326,200,1730,502,1335,588,1616,1593,354,462,445,787,490,138,407;33;F
63384;670,1326,70,762,1335,406,791,559,787,728;62;M
63393;502,407,79,1616,354;33;F
63413;80,79;26;F
63456;1616,354,149,445,1383,1593;51;F
63589;200,70,82,80,1616;37;F
63606;1723,824,1616,791,1593,1383;49;F
63641;247,200,695,762,79,839,1593,852,885;25;F
63668;695,82,407,1593,354,728,654,1730,200,670,793,839,1616,1204,490;24;M
63684;791,246,79,105,82,70,200,793,1326,670,762,1730,728,374,1616;34;F
63686;1593,1383;47;F
63843;80,406,824,149,854,490,70,82,1255,502,407,246,354,1383,138;42;F
63860;824,1616,1593,852,885,149,654,490,441,1730,82,105,406,445,854;65;F
63865;839,885,657;52;M
63878;885,791,374,1255,200,793;49;M
64016;791,588,1730,1326,762,406,1616,1593,787,728;42;F
64028;354,885,247,695,839,1616,1593;24;F
64117;1326;90;M
64171;1326,1616,1593,1383,787;43;M
64263;462,791,793,1326,762,246,787,728,670,200,1730,1255,1723,559,885;76;M
64335;1326,1593,1383,787;11;M
64338;1326,1593,1383,787;8;M
64428;793,762,839,1616,462,441;49;F
64504;502,80,839,1723,885;46;F
64518;149,374,791,1204,1255,695,1730,670,793,1326,200,354,462,1180,138;32;M
64576;200,1730,839,885;25;F
64584;793,1326,247,200,1255,374,839,791,1204,462,1593,354,885,787,138;39;M
64590;1326,695,82,762,839,1204,1593,149,1383,654,490,728;14;F
64612;885,1393,138;26;M
64631;70,728,1723,559,354,138,657,670,793,200,1730,695,839,885,445;58;F
64637;588,670,200,791,149,490,1204,1616,374,695,82,1326,793,1593,854;32;M
64645;1326,1730,82,762,1616,1593,1383,654,490,728;10;M
64654;1326;18;M
64694;374,70,200,793,670,654,445,82,1255,502,1616,407,1730,695,247;39;F
64779;670,79,1723,354,1383,654,82,1616;16;M
64891;1593,1383,728;48;M
64924;1593,246,502,200,1255,762,407,406,559;55;M
64929;1326,354,885,149,445,670,200,1730,82,762,1616,1593,1383,787,728;47;F
64948;79,70,200,762,670,695,374,791,559,839,1616,1593,885,654;41;F
64990;793,1180,670,200,695,407,791,1204,1593,354,1730,762,852,445,787;32;F
65007;247,1730,762,502,407,246,839,1723,885,1180,138,441,82,80,105;16;F
65015;1593,149,1383,657,728,670,695,762,246,839,1204,354,654,490,138;24;M
65048;1616,1723,1593,885,138,670,793,762,1383,787,654,728,1255,791,374;33;M
65057;1326,246,654,441;22;F
65061;150,82,374,1204,354,149,490,728,793,695,762,839,1593,885,138;30;F
65065;1730,246;34;M
65080;728,657,839,79,793,670,1326,762,791,1204,354,885,462,1180,138;38;M
65221;670,200,762,824,1616;75;F
65272;793,1730,407,839,1204,1593,354,885,445,787,654,657,695,1616,559;33;F
65273;1730,80,105,79,246,424,1616,1582;15;F
65283;787,791,79,374,1730,793,670,200,82,762,839,1616,1593,885,490;48;F
65297;354,1593,1204,839,79,374,1730,200,1326,793,670,695,1616,885,445;32;M
65383;407,1383,1393,1180,138,502,1723,885,1582,1730,80,79,839,1616,354;37;F
65555;1730,70,670,200,762,243,462,138,657,1326,839,1723,885,654,728;41;F
65620;402,80,79,1616,1593,885,1383,654,138;43;M
65687;1593,502,1255,839,1204,354,885,138,657,695,793,1326,670;23;M
65721;670,695,762;37;M
65779;150;45;F
65829;695,80,588,406,490,728,1255,793,1730,762,374,1616,791,654;37;F
65853;1593,1383;40;F
65878;138,1180,1204,1730,200,793,670,354,654;47;M
65977;1616,670,1326,200,1730,70,82,762,402,105,791,787,654,490,728;77;F
66031;406,243,70;65;F
66058;1326;73;M
66060;82,79,246,1616;31;F
66107;793,70,839,406,1593,1383;44;F
66271;462,654,1204,354,1383,1393,200,407,246,149,138;50;F
66303;839,885;10;M
66304;839;12;M
66308;1730,695,70,445;41;F
66336;839,354,1180,793,374,791,1204,885,445,657,695,1730,1255,1616,1593;22;M
66349;1326,670,793,695,1204,354,1593,791,374,1255,839,885;42;M
66414;1730,695,70,445;8;M
66426;654,657,728,670,793,247,1255,762,462;31;M
66466;670,885,138;37;M
66540;839,105,80,1255,200,670,402,246,1723,791,559,1593,885,445,787;33;F
66601;70,105;53;F
66617;670,374,406,70,80,1723,1616,791,1204,1593,354,885,1180,441,138;19;M
66624;1383,695,79,1616,559;39;F
66648;588,787,1326,1723,1616,728;64;F
66665;82,762,839,1616,885,854,490;31;M
66690;200,374,1180,793,1326,695,1255,1204,1593,354,787,670,791,885;40;F
66711;670,793,1730;33;F
66758;885,445,200,839;26;M
66766;247,402,1616,1204,354,1393,138;22;M
66860;559;21;M
66881;793,374,354,149,1383,787,654,670,695,1255,839,791,1593,885,445;30;M
66890;1383,854,200,839,885,1582,791,374,695,670,1593,559,1204,354,654;38;F
66934;695;44;M
66954;728,1593,885,839,762,70,82,1730,247,200,670,793,1616,462,654;27;M
66962;138,793,1326,200,695,82,1335,839,402,1616,654,559,105,406,70;26;F
66983;70,1255,1335,243,588,406,1593,1383,854,654,657;68;F
67099;1593,1383;65;F
67110;728,80,374,762,200,1730,82,1616;23;F
67185;402,80,105,824,354,854,1582,654,852,1616,839,695,1326,670,247;42;F
67193;82,200,1730,670,762,462;69;F
67195;670,1326,695,374,1204,1593,354,149,1180,445,138;35;M
67258;885,374,588,559,1383,138,407,1255,70,670,1730,79,1616,354,149;68;F
67281;1383,670,1326,200,1730,82,1616;32;F
67375;374,1255,200,670,1593,149,1383,787,728,839,762,695,793,885,138;37;M
67392;1616;41;F
67432;1204,1383,445,354,1593,80,1255,82,695,793,670,762,839,1723,885;38;M
67534;1326;38;M
67537;441,559,406,243,105,70;55;M
67540;654,793,200,1730,70,670,839,1593,354,885,462,787,138,728,1326;41;F
67644;728;53;M
67701;374,354,1204,588,1616,839,200,670,787,791,885;36;F
67741;462,793;28;M
67923;354,1593,1723,839,502,762,695,1326,885,1582,1730,1616,1383,138,149;27;M
67947;1255,762,80,79,839,1593,354,885,149,445,1383,787,138,502,407;42;M
67982;787,793,670,247,200;26;F
67986;791,1616,787,1593,462;54;M
68027;1593,1383;36;F
68040;670,1730,695,502,1723,1593,885,654,490,1616,445;22;F
68151;670,793,1255,502,79,1723,654,354,787,885,762,839,200;62;M
68160;502;40;F
68186;728;16;M
68221;200,695,82,762,105,1723,839,559,1616;29;F
68227;791,1204,407,1255,885,728,138,243,1730,695,149,1593,246,1383,490;46;M
68359;247,200,762,374,1616,791,885,787,654,728;29;F
68370;793,670,695,82,502,374,407,105,839,1616,1593,354,149,445,490;35;M
68439;793,200,1730,839;41;M
68464;670,793,695,762,374,243,824,354,854;31;F
68476;695,1255,762,374,407,839,1616,791,1204,885,445,787,654,657,354;29;F
68514;670,200,1730,695,762,105,885,445,1383,854,1393,138;40;F
68539;80,105,79,1255,695,1616;46;F
68678;1204,1730,885,1393,1180,138;45;M
68695;374,80,1326,1180,1383,354,1616,407,502;24;M
68702;406;75;M
68704;1326;70;M
68738;406;69;F
68743;149,1730,200,839;66;M
68787;657,654,787,354,1593,1204,791,1616,670,793,695;24;M
68790;247,402,588,824,854,654,657;53;F
68811;80;44;F
68834;670,200,695,502,839,406,791,559,787,354,885;35;F
68927;200,762,1616,885,445,787,354;23;M
68949;138,885,791,839,1326;33;M
69023;654,138,354,1593,791,824,407,695,670,793,247,200,1730,839,1616;32;F
69100;559,406,246,243,138;54;F
69146;839,445,654,657,1730,200,670,793,695,70,1255,762,406,1616,1593;60;F
69162;502,407;43;F
69174;105,406,70;58;F
69251;1730,374,1255,695,793;46;F
69283;1730,105,79,839,885;33;M
69294;1255,79,839,1616,559,1593,354,462,654,138;32;M
69301;354;34;M
69305;70;61;M
69342;402,793,1730,670,200,762,374,105,1723,1616,791,885,462,787,728;71;F
69346;502,407;13;F
69366;407,502;51;M
69380;1383,654,728,839,200,670,793,695,1255,762,374,354,885,462,787;34;M
69383;1204,885,657,793,670,247,695,762,80,839,1723,1593,354,490,138;25;M
69384;149,762,695,885,1393,1582;49;F
69388;1204;31;M
69398;695,200,1326,670,70,1255,502,1335,839,1616,559,885,854,787,654;33;F
69405;354;60;F
69590;1180,787,445,354,1616,1730,695,839,885;60;M
69591;374,695,839,885,462,1393,1730,793;51;F
69683;200,1730,502,402,407,79,246,839,1616;44;F
69688;247,82,374,1616,1593,1383;17;F
69816;559,490,670,406,654,441,70,402,105,243,1730,200,247,839,1616;47;F
69835;82,374,839,149,670,793,695,1255,762,462,1180,490,138;26;M
69836;670,793,695,885,1730,1593,728;27;M
69841;1326;63;F
69868;1730,374,824,406,791,462,787,728,70,402,149,854,1335,559,1326;31;M
69870;150;51;F
69881;1730,695,246,852,854,787,247,402,559,1593,354,445,138;43;F
69902;402;53;F
69926;82,70,150,695,1730,200,247,1326,1204,885,462,670,852,1593,1383;12;M
69932;502,82,1730,1593,1383;47;M
69933;695,1730,1616,445,654,793,670,374,1593,200,1255,247;47;M
69948;80,670,793,462,654,839,149,1383,374,1393,1180,1582,1204,1593,138;35;F
70007;670,793,1730,695,1255,374,791,1204,1593,354,885,787,654,1180,657;29;F
70052;793,150,82,243,1616,1593,445,654,490,138;23;F
70063;793,670,374,1593,200,1255,695,247,1730,1616,445,654;45;M
70136;670,200,79,839,791,885;81;M
70181;70,793,402,1255,1730,105,406,1616,559,1593,149,1383,854,654,138;25;F
70196;1335,1616,441;69;F
70235;1730,200,354,149;40;F
70271;1255,762,502,1335,105,79,839,824,1593,354,462,654,490,793,1616;32;F
70277;1204,762,1616,791,793,670,462,654,200,1730,246,243,1593,1383,138;47;F
70278;657,80,490,462,1255,885,670,1730,79,791,1204,354,1383,787,654;21;F
70283;79;38;M
70329;1383,854,1180,1730,695,1255,407,839,824,1616,1204,1593,354,445,654;54;F
70333;354;60;M
70335;200,762,80,1616,728,654,787,1383,885,1593,559,791,105,670,374;47;F
70339;728;36;F
70346;80,490,1326,1335,79,246,243,588,1616,1593,354;67;F
70411;839,885,1255,490,1326,695,762;26;M
70431;1204,791,406,588,374,1255,670,793,200,1730,695,70,407,1616,445;19;F
70435;82,1255,402,105,588,1723,1616,1593,885,854,787,654,490,657,728;35;F
70446;138;49;F
70452;70,406,149,839,885;26;F
70471;354;56;F
70474;1593,1383;67;F
70482;247,695,762,839,1616,654,490,138,885,462;31;M
70496;728;44;M
70501;670,1730,762,374;51;M
70547;247;26;F
70570;1593,1383;68;M
70577;839;35;M
70673;885,728,670,200,1730,70,762,374,80,79,839,1723,787,1593,1383;10;F
70693;852,854,490,200;55;F
70700;402;54;F
70733;839,200,1593,885,793,1730,462,670,70,82,762,1723,406,791,787;51;F
70803;670,247,200,82,1255,80,79,839,1616,1582,654;35;F
70874;490,82,243,1616,1593,1383;59;F
70881;441,728,657,138,502,839,1616,1204,1593,885,793,824,670,79,588;24;F
70906;1593,1383,138;14;F
70949;670,200,1730,762,374,79,1723,791,885,462,787,657,1593,1383;7;F
70957;1593,1383;10;F
70961;1616,149,1383,793,839,462,1180,670,1326,695,762,374,1204,138,728;52;M
70964;374,791,1593,445,787,793,1326,1730,1255,149,1383,1204,407,138,354;43;M
71001;1593,1383;14;M
71005;1393,1180,200,82,762,1204,490,728,1730,1255,1616,793,695,839,885;45;M
71013;1383;15;M
71018;654,885,1335,70,839,1593,354,138,728,670,793,1730,1616;22;F
71061;793,374;36;F
71078;695,885,490,441,654,82,670,793;39;F
71079;402,793,824,1616,854;66;F
71120;559,1204,1593,149,654,138,657,787,445,839,70,695,200,247,670;50;F
71145;1383,354,1180,1723,374,762,200,793,670,1326,791,1593,462,787,728;55;F
71156;1326,670,793,200,1730,824,1616,1204,1593,354,149,1383,490,441,138;31;F
71162;793,1326,1730,695,1255,374,407,1204,1593,354,149,445,1383,787,138;42;F
71190;243,80,1730,670,793,200,247,70,762,402,374,1723,791,1593,1383;5;F
71230;762,1326,374,791,354,138,670,793,200,1730,695,1255,787;30;M
71247;150,695,247,1326,462,354,1730,200,793,374,1593,1723,791,885,1383;39;M
71271;791,793,1326,695,149,787,670,762,374,839,1616,1204,462,1180,728;52;F
71298;670,79,246,1204,149,462,445,1383,854,728,1326,695,1616,138,354;26;M
71315;1180,354,1723,1730,793,670,200,1326,762,374,791,1593,462,787,728;89;F
71357;402,445;39;M
71390;490,82,70,839,559,885,138;36;M
71448;1383,1180,138,793,1326,200,695,70,1255,374,80,79,839,1204,885;36;M
71517;1255,824,1616;40;F
71606;200,70,402,105,406,559;68;F
71658;762,374,791,1180,728,1204,138,200,354,670,793,70,1593,885,839;45;F
71665;670,82,200,1730,762;50;M
71689;1383;54;F
71962;1593,105,793,70,374,424,80,79,406,885,654,1255,839,502,407;42;F
72000;82,793,791,200,1730,695,1255,839,1616,1204,445,654,728;45;F
72057;406;80;F
72066;1255,695,200,670,793,1730,70,1616,559,1593,885,1393,654,728,1582;45;F
72114;502,407;51;F
72125;670,1255,79,791,1204,657,1326,695,839,1616,1593,885,445,787;23;F
72199;502,407;44;F
72222;670,791,1593,885,787,654,490,728,1326;49;M
72226;502,407;9;M
72239;502,407;13;F
72248;80,79,588,791,138,1616,406,670,1730,70,559,1204,1593,1383,1180;36;M
72276;502,407;44;M
72283;670,793,200;42;M
72400;728,149,354,791,374,1255,695,1730,200,670,762,80,1180,1593,1383;39;M
72602;149,791,762,1255,200,80,407,79,839,824,1616,1593,354;32;F
72608;105,70,406;54;F
72631;654,105,852;26;F
72662;200,247,793,670,1326,695,150,70,79,1723,1616,1204,854,654;29;M
72679;502,407;72;M
72690;502,407;88;F
72734;793,502,402,839,406,885,654,80,70,105,243,1616,559,490,82;16;F
72751;1593,1383;55;M
72779;1730,839,1616,149,441,670;25;F
72789;762,1616;56;F
72899;1326,70,407,445,200,839,1593,354,149,138;39;F
72902;670,793,247,1255,1723,885,445,787,654,657;28;M
72916;1593,1383;51;M
72925;762,1616,354,1582,728,1255,791,1204,1593,138,1326,793,1730,839,885;23;F
72935;793,200,1255,462,1204,1593,1393,670,1616,1383,490,1730,374,354,138;28;M
72959;657,728,654,149,354,559,791,1616,588,79,1335,670,1593,885,839;30;M
72999;79,793,670,247,200,1730,80,407,105,839,354,462,787,138,657;24;F
73006;654,1393,854,445,149,1204,839,1730,82,1616,885,1383,490,138;34;F
73025;374,670,793,200,1730,1255,762,839,1204,354,885,1393,1180,149,138;41;M
73078;1335,246,588,247,200,82,762,824,1616,559,852,654,490,441,138;54;F
73175;1326,839,824,1616,1593,149,1383,138;39;M
73256;354,138,1593,1383;56;M
73287;1393,654,490,670,82,1616,791,885,854;31;F
73301;1593,793,70,82,138,885,1616,1326;30;F
73314;654,1730,1593,149,354,374,1326,1255,657,445,1204,670,793,200,695;47;M
73407;1582,1180,138,695,200,1326,654,670,793,1730,70,402,1616,559,462;35;M
73425;670,82,1326;30;M
73485;839,1593,852,1393,1582,441,247,82,1255,407,588,824,1616,354,654;38;F
73497;1393,854,793,1730,82,1335,839,824,1616,885,1383,1582,654,490,138;36;M
73535;70,406,824,1616,559;60;F
73539;1204,728,138,1180,1393,462,885,762,670,793,839;38;M
73551;839,824,406,1616,559,354,1593,852,885,1383,854,1393,787,654,490;25;F
73577;695,559;19;M
73596;695,354,793;28;M
73637;402,80,79,839,406,1204,490,138,885,70,1616,559,1593,1383;43;M
73638;80,105,79,1616,1204,1593,354,149,445,1383,1582,1180,490,138,657;2;M
73665;502,407;18;M
73667;354,1593,791,839,407,374,1255,70,695,1730,793,406,559,885,445;33;M
73687;402,80,79,839,1616,354,852,885,149,1383,1393,1582,654,441,138;;M
73758;670,762,839,1204,1593,885,149,200,1730,695,791,354,462,138,728;32;M
73763;79,406,1723,1204,885,354,1593,1383;8;F
73822;1616,1593,854,793,762,670,588,1326,406,462,441,80,200,70,138;73;F
73823;70,80,79,839,1616,559,1204,1593,1383;6;F
73871;70,80,79,839,406,1616,559,1204,1593,354,885,1383,1582;3;M
73872;695;44;F
73876;1616,559,354;27;F
73925;1730,82,79,1593,354,149,1383,138;54;F
73959;670,793,200,1730,695,1255,374,839,791,1204,1593,354,885,462,1383;68;F
74007;374,824,1393,70,839,406,852,885,1383,1180,138;66;M
74020;839,1180,247,200,82,246,1204,354,654,588,1616,854,490,138,657;34;F
74023;793,247,200,695,82,1255,246,424,824;41;M
74061;1326,70,82,80,588,1723,1616,1204,1593,885,1383,1180,490,138,728;9;F
74091;1593,1383;32;F
74158;445,149,200,247,1730,82,1255,762,839,1616,559,1593,354,885,1383;17;M
74217;1204,1593,1383;58;M
74267;839,787,670,1255,762,80,588,1593,354,885,138,657,79,1616,445;45;F
74347;79,559,1204,791,1593,885,445,1383,1180,1326,80,407,354,149,138;29;M
74375;1730,374,79,1616,1204,490,885,839,502,354,149,138,80,1593,1383;44;M
74477;70,502,80,79,839,406,149,1723,1616,885,787,1582,138,1593,1383;15;M
74489;445,791,1616,839,1335,80,762,1255,70,695,1730,200,1326,1383,654;30;F
74510;793,762,1616,852,728,1730,247,670,374,79,839,1723,824,559,1593;32;F
74587;1593,1204,791,406,374,1255,70,670,200,839,1616,559,354,852,885;15;F
74601;149,1383,1730,695,82,1255,839,1616,559,1204,1593,885,445,1582,490;24;F
74611;588,354,200,70,82,839,1616,885,490;43;F
74644;490;27;F
74652;138,1180,200,374,445,1582,791,1326,670,354,657,1255,695,247,70;25;M
74690;793,787,695,70,243,559,1593,445,247,1730,402,105,1616;26;F
74692;406,791,1204,670,200,1255,402,407,79,839,1616,354,885,1383,138;34;M
74698;138,885,70,82,839,559,654,490;34;F
74708;839,762,1255,695,1326,670,793,200,559,1204,1593,354,885,1383,138;33;M
74712;793,670,1326,1730,70,1255,246,424,588,824,1616,354,462,654,490;26;F
74717;402,588,824,854,654,657;60;F
74722;1730,695,82,1255,762,374,839,1616,791,1593,354,885,787,654,247;31;F
74781;1730,200,406,885,490,247,70,839,1616;32;F
74808;657,374,695,200,1730,791,1593,793,670,1255,1616,354,445,787,654;25;F
74814;80,445,490,728,670,200,1730,695,82,1255;56;M
74829;670,793,200,695,82,762,374,80,407,79,1616,791,1204,1593,354;28;F
74840;588,824,402,654,657;62;M
74841;559,1204,490,670,80,79,1723,1593,354,885,149,1383,787,1180,138;54;F
74851;839,1730,354,1383,138,1180,149;51;M
74854;670,1255,407,243,839,791,1593,354,885,1383,787;27;F
74864;1616,82,80,79,246,149,1383,1393,854,1582,654,1180,490,138,728;41;M
74883;670,247,82,402,80,1335,105,200,1730,243,424,1616,354,654,138;25;F
74885;354,80,670,793,247,200,1730,695,70,82,1255,502,407,1616,445;6;F
74895;1204,1180,1593,1383;40;M
74904;588,1335,82,70,695,1730,200,247,243,839,1616,354,885,445,654;28;F
74908;695,839,670,200,762,374,1723,1616,791,1593,885,445,787,654,490;22;F
74909;200,1730,70,82,105,246,243,588,406,1616,149,1383,1393,654,138;58;F
74925;200,1730,839,1616,1593,354,885,149,445,854,1393,1180,490,138;40;M
74934;402,588,824,854,654,657;78;M
74935;1204,787,657,670,1326,200,407,1616,1593,354,149,1383,1582,441,138;68;F
74956;70,82,243,839,1616,885,462,490,657,1730,695;22;F
74957;374,402,502,1255,82,70,695,1730,200,793,407,1616,445,654,490;3;M
74960;657,1255,695,445,885,1204,791,374,354,839,793,1730,1593,654,1616;21;F
74979;402,588,824,854,654,657;85;F
74984;200,1730,1616,559,1593,354,149,854,105,654,728,670,762,787,791;49;F
75011;502,70,695,670,1730,105,79,588,1616,1593,885,441;32;F
75015;407,246,839,1723,559,1383,854,1393,654,490,1582,852,354,824,243;25;F
75041;1326,70,82,80,588,1723,1616,1204,1593,885,1383,1180,490,138,728;8;M
75054;462,787,728,138,1383,762,1255,695,200,1730,1326,793,670,1593,1180;21;M
75062;559,354,149,1383,138;37;F
75067;793,670,200,1730,839,1616,885,138;35;M
75083;247,70,407,406,559,445,1383,787,138;28;M
75099;670,1730,695,82,1255,402,1335,839,1616,1593,354,787,490,657;26;F
75101;1593,1383;10;F
75135;1593,1383;7;F
75162;149,1383,80,138,79,406;35;F
75163;1593,1383;2;F
75169;70;45;F
75198;82,1326,793,670,200,695,70,762,79,839,1616,559,885,654,490;40;M
75209;70;70;F
75246;839,885,1204,787,441,657,670,1326,695,374,1582,1180,793,1593,354;21;F
75266;247,246,243,839,824,791,354,445,854,787,1582,654,490,441,138;19;F
75272;1204,1723,670,793,1730,695,885,354,445;41;F
75307;149,445,1593,1383,441,657,1204,82,695,793,670,200,1730,354,654;58;F
75331;839,407,354,79,82;30;M
75343;79,559,462,657,138,670,793,82,402,243,839,1616,354,149,490;23;F
75374;670,793,200,374,1616,791,1593,728;35;F
75379;1730,793,670,1326,762,80,839,1723,791,354,885,462,1383,138,728;31;M
75381;82,70,490,149,1383,138;46;F
75384;1204,1593,1383;40;F
75428;243,200,1730,762,1616,559;61;F
75443;138;36;F
75460;793,200,1730,70,82,407,79,406,149,1393,490,138;57;F
75463;839,885,654;27;M
75475;1393,462,246,200,1730,407,79,406,1616,1204,1593,354,149,1383,138;41;M
75510;670,1730,695,82,374,839,559,791,1204,1593,885,445,1383,787,654;21;M
75515;247,728;38;M
75531;200,402,79,588,854,654,441,793,1730,82,374,80,105,1616;64;F
75578;1616,1255,728,149,1180,1593,559,1723,839,762,70,793,670,1730,885;45;M
75580;1730,1616;26;F
75624;670,1730,839,1616,1593,885,1383,787,695,374,1204,354;26;F
75635;885,149,445,407,1335,374,402,695,1730,82,588,1593,854,654,490;27;F
75698;82,200,670,793,70,654,1593,559,1616,1723,1730,1326;36;F
75719;70,406,1593,1383;8;M
75736;839,1204,1593,885,670,793,695,1616,354,654,138;62;F
75743;462,445,1180,441,728,138,787,149,1593,1255,695,670,1730,200,1326;32;M
75767;462,791,1204,354,1582,885,149,1383,1180,670,1730,695,502,839,445;32;M
75771;105,670,793,138,1255,354,82,695,839;22;M
75802;1723,1593,1393,728,1383,354,1204,1616,1255,70,1730,793,670;43;F
75809;247,374,791,1204,1593,588,1730,695,70,402,105,839,406,1616,885;50;F
75893;588,105,80,374,1255,695,1326,793,670,200,1730,70,1616,138,657;31;F
75912;1730,79;31;F
75915;70,762,406,149,885,654,441,728,1616,559,462,1255,839,445,695;45;M
75934;670,1730,695,1255,374,839,1616,1204,1593,885,654;29;M
75986;1730,588,1723,70,82,80,1204,354,885,490,1180,138,1326,1593,1383;40;M
75990;670,246,839,1582,793,1730,402,588,1616,559,354,1393,654,490,138;33;F
76057;200,1326,247,1335,105,79,1255,246,588,824,1616,854,728;71;F
76079;1326;51;F
76144;1326,374,1204,149,1180,670,793,70,1255,1723,1593,354,885,490,441;27;F
76191;670,793,695,70,82,1255,407,839,406,559,1593,354,885,445,654;51;F
76264;793,149,138,1326,70,406,1616;29;F
76266;200,1335,588,1723,490,441,791,559,1593,654,728,138,406,82,70;47;M
76302;793,1730,70,1255,246,839,406,1616,559,1593,354,885,445,787,138;38;M
76312;695,70,1616,559,441;38;M
76314;200,82,762,243,1616,559,354,787,490;43;M
76363;70,1730,374,406,559,852,445,654,138,1383,149,1593,1616,246,82;53;F
76415;670,1730,695,1255,762,588,1204,445,787,728,654,462,793,354,885;29;F
76420;670,1723,762,852,787,885,728;22;M
76454;1616,1383,791,1204,839,374,793,670,200,1255,1593,354,885,445,657;46;F
76467;354,149,1326,402,105,839,1616,1593,852,885,1383,138,502,80,243;66;F
76468;885,1383,200,695,70,105,424,839,406,559;14;M
76473;149,490,657,79,1335,80,502,82,247,695,105,588,852,854,654;19;F
76489;70,150;16;M
76604;70,854,490;36;F
76630;762,445,695;41;M
76644;728,670,762,1180;27;M
76651;138,441,462,354,1616,1723,670,82,839,885,200,80,79;8;F
76705;885,150;59;M
76710;852,149,1383,1582,787,490,441,138,247,1730,70,82,502,80,407;33;F
76737;200,1616,793,670,246,839,791,885,149,1383,787,490;33;F
76786;407,243,138,354,105,1255,793,441,657,200,1730,654,1616,406,70;29;F
76806;149,1383,654,793,670,762,374,791,559,1204,354,787,138,728,1730;30;F
76810;247,502,407;37;M
76826;1616,559,670,793,200,695,1255,79;26;F
76828;793,762,105,79,243,1723,1616,791,657,839,885;39;F
76841;402,588,559,138,654,1383,354,406,374,1730,793,670,695,1255,728;59;M
76864;1730,695,70,1255,762,79,588,839,824,1616,559,1593,445,1582,654;59;M
76872;654,1616;58;F
76877;490,728,1593,1204,791,374,762,1255,70,82,695,1730,200,793,670;23;F
76878;1255,200,670,793,1730,82,80,407,105,839,1204,445,1383,1582,654;18;F
76893;247,1730,70,82,1255,502,79,407,406,1616,1593,787,1582,490,441;10;M
76907;1326;81;F
76916;1255,1326,1593,1204,1393,1582,1730,82,1616,354,149,1383,787,654,490;39;F
76934;670,200;69;F
76986;793,839,200,445,1593,885;71;F
77009;793,247,200,1730,80,424,243,354,149,1582,728;15;F
77037;354,1204,824,1723,407,1335,1730,695,762,588,1616,1593,149,1180,138;18;M
77071;670,793,1730,1593,1383,138,657,200,1255,1335,354,149;46;M
77123;793,670,200,1730,1255,1335,246,839,588;28;F
77156;490,670,793,1730,695,70,1255,374,839,406,559,1204,885,462,138;25;M
77181;80,374,1255,82,70,793,670,200,1730,695,839,1616,559,885,445;51;F
77188;1383,654,441,138,657,728,246,80,1255,1616,1204,1593,852,885,839;45;F
77219;1593,839,407,1255,82,70,793,670,200,1730,695,374,1616,885,787;40;F
77260;793,670,247,200,1730,79,839,462,138;33;M
77262;791,445,787,490;22;F
77306;246,588,839,406,824,1616,728,1730,1204,885,854,1393,490,657,70;37;F
77324;1616,885,695;48;M
77327;243,839,1723,885,445,854,1582,654,441,1616,407,82,247,150;26;F
77364;200,70,406,654,1730,1616,445;40;F
77410;1616,402,793,1326,695,839,762,791,885,787,138,728;33;M
77455;502,1616,149,654,200,70,105,79,406,559,354,138;57;F
77458;1593,354,885,462,1180,138,670,200,588,839,1616,559,445,854,654;33;F
77462;670,762,374,80,243,839,1204,1593,354,852,885,854,1383,490,654;22;F
77528;588,246,79,374,1730,1326,793,1723,354,462,138,728,80,762,670;64;F
77561;1593,1383;36;M
77574;80,1730,793,149,138;27;M
77612;728,793,1730,1255,762,80,1593,354,885,149,462,138;34;M
77617;559,1335,70;49;M
77630;243,588,559,852,854,490,793,247,82,105,402,246,839,1616,654;22;F
77637;1593,1383;10;F
77638;354,149,490,138;30;M
77645;1326,70,1723,406,657,138,1383,885,354,1204,407,793,695,80,1616;36;F
77700;695,82,762,80,407,105,149,79,1616,354,138;37;F
77705;824,1204,854,728,654,82,839,1616,1593,885,1383,1393,138;33;F
77706;1593,1383;3;M
77720;407,502;42;F
77736;787,854,670,200,1326;73;F
77767;150;64;F
77785;138,1593,728;43;M
77816;839,1616,354,441;28;F
77847;1593,1383;13;F
77856;70,82,1335,79,246,1616,559,149,1180,1593,1383;10;F
77876;138,80,79;42;M
77878;762,1326,1723,791,654,728;75;F
77904;1593,1383;10;F
77907;695;49;F
77988;695;22;M
77996;243,406,824,588,246,1335,402,1730,1616,559,852,854,654,490,441;46;F
77997;200,80,502,246,354,885,654,490,70,839,406,149,138;32;F
78004;502,407;17;F
78037;1326,695,82,374,80,407,105,839,1723,1593,885,462,854,1582,490;28;F
78042;695;18;F
78043;490,1616,670,200,1730,70,82,762,374,406,149,462,728;37;F
78053;150;78;M
78072;80,728;40;F
78079;1582,654,490,728,793,1730,70,839,406,1723,1616,559,885,441,82;47;F
78137;1730,1255,852,374;34;M
78196;588,1204,1593,354,149,462,490,657,728,200,1730,695,762,854,654;31;F
78274;1393,1582;50;M
78275;728;38;M
78322;247,200,1255,762,79,839,1723,1616,559,654,657;37;M
78425;1335,1204,1593,854,793,1326,695,824,149,1383,200,354,441,138,657;48;F
78467;654,1730,80,424,839,1616,441,502,407,79,406,1593,149,1383,138;41;F
78468;885,1582,200,1730,80,105,1616,149,441,70,839,406,490,138;52;M
78508;1326,793,670,791,1204,1593,354,149,462,445,1393,787,1582,1180,657;32;F
78523;200,839,885,1730,1180;56;F
78549;728,138,670,793,1326,1730,762,374,80,79,246,588,1723,354,462;69;F
78565;200,354,787;64;M
78675;1582,728,105,885,1180,824,1593,695,70,82,1335,1616,149,490,657;38;F
78690;70,402,82,1255,243,588,1616,559,852,445,854,441,657,105,824;34;F
78718;588,246,105,200,670,247,695,502,839,1616,559,852,885,149,654;27;F
78728;406,374,1204,793,1255,1593,149,462,670,1326,200,695,654,138;34;M
78730;670,695,559,441,657,885,1616,839,80,70,247,793,787;29;M
78758;839,406,657,654,1593,402,1335,105,793,1730,246,1616,852,885,445;42;F
78769;150;52;F
78902;1593,1383;43;M
78946;762,852,654,441,1616,839,402,1255,1326,1335,1730,695,588,854,657;70;F
78986;559,839,105,1326,670,1723,824,854,1616,885,787,138;27;M
78991;354,885,1180,138,695,839,149;28;M
79019;670,728,138,490,1582,787,1383,462,149,885,354,1204,1723,839,247;26;M
79020;462;30;M
79054;490,654,354,105,80,1255,247,407,138;30;F
79095;1616,654,1593,559,1335,1730,70,728;81;M
79099;885,79,407,80,374,82,1730,200,502,1204,1593,354,149,1383,138;44;F
79183;793,559,138,654,490,1383,149,354,1616,839,407,80,200;34;M
79193;824,791,1204,445,1383,657,670,793,1730,1616,1593,354,885,654,839;40;F
79220;138,490,462,354,791,1616;26;M
79247;885;32;M
79274;200,1593,354,149,138;30;F
79277;1255,138,1326,70,149,490,793,200,1730,105,243,1616,1593,354,854;29;F
79288;670,243,1593,657,1730,885,762,402,839,787,246,793,1255,200,695;48;F
79303;670,247,354,445;31;M
79359;1730,462,354,1723,588,246,79,80,374,762,1326,670,793,138,728;77;F
79367;793,247,70,82,1335,1616,654,490,441,695,105,246,243,354;27;F
79388;670,354,149,1180,80,82,70,1730,200,462,787,138,490,1593,406;31;M
79445;670,70,762,374,1723,559,885,787,1180,728,839,354,138,1326,791;38;F
79462;1582,441,138,657,670,247,82,79,1616,1593,885,445,1393,654,490;24;M
79512;1730,82,1255,80,79,1616,354,787,490,695,246,1393,138;33;F
79546;762,793,1593,885,854,654,441,1255,1730,695,70,82,1616,559,490;38;F
79567;793,1730,82,1255,791,1204,1593,462,885,149,445,787,654,490,441;24;F
79573;670,1730,695,1255,424,1616,791,657,247,200,105,839,559,885,490;41;F
79583;657;60;F
79587;200,670,1730,402,374,588,1723,406,1616,354,852,1383,654,138,441;72;F
79592;1593;37;M
79619;885,1593,1204,559,824,406,793,670,441,654,1582,1393,354,1616,839;30;M
79635;793,695,1723,354,445,854,1730,70,82,80,79,246,1616,559,406;41;F
79638;1335,1723,1593,354,728,1180,885,839,82,247,1730,695,588,1616,654;24;F
79672;793,670,1326,247,200,695,1616,354,1593,445,1383,787,654,1180,138;23;M
79701;247,1255,246,824,1616,854;20;F
79708;657,728,654,787,354,1616,82,670,793,200,1730,762,839,885;50;M
79715;490;44;M
79798;82,762,79,1616;27;F
79855;657,728,762,670,1255,559,406,588,246,374,502,70,695,1730,793;50;F
79857;402,105,824,1616,588,1335,502,247,354,852,854,1393,654,441;29;F
79872;670,1730,82,1593,354,1393,728;24;F
79937;1326,695,82,588,839,1616,1204,354,885,445,490;21;F
79941;670,1730,695,1255,374,1204,1593,354,885;28;M
79961;852,1582,441,80,246,243,490,657,1335,105,588,1616,445,1383,654;23;F
80011;1616;22;F
80028;105,406,559,1593,354,445,854,490,441,695,402,588,1616,654,657;58;M
80044;1593,1383;64;F
80052;728;30;F
80061;354;23;M
80089;793,1326,374,80,105,839,354,200,670,138,1593,1383;34;F
80120;1616,1723,424,1335,1255,247,670,80,839,79,105,407,502,354,138;32;M
80133;82;16;M
80220;402,105,559,1593,852,657,1730,1335,588,839,824,1616,885,854,654;36;F
80240;1723,657,80,762,407,839,1616,354,441,138,1730,82,424,490,654;48;F
80250;1180,374,1616,1593,1383;38;F
80300;445,839,402,200,247,670,695,105,1616,852;43;F
80336;82,695,793,445,654;50;F
80344;695;74;M
80363;762,374,791,852,885,787,728;35;M
80374;1730,246,839,149,138,200,793,670,695,1255,374,791,1204,354,1593;26;F
80376;200,695,1593;22;F
80409;1593,1383;89;M
80415;1326,695,839,852,445;36;F
80424;1616,462,839,138;48;M
80427;793,670;32;M
80573;149,138,1383;45;M
80604;441,654,885,839,588,762,695,670,1730,374,1616,791,1593,728;41;M
80624;670,654,138,1616,247,695,82;19;M
80636;670,200,246,1723,406,824,559,354,885,462,445,787,1582,657,728;45;M
80650;1593,1383;41;F
80659;793,200,1730,695,374,1204,354,138,657,885,1593;25;F
80664;1730,1582;42;F
80673;490,80,793,1326,1730,695,70,402,105,79,406,1616,559,654,657;35;M
80681;138,407,79;63;F
80714;1393,1582;45;M
80740;354,654,1730,1326,670,695,1616,1204,1593,1393,657,490,445,839,793;27;F
80748;1593,1383;11;F
80776;445;13;F
80789;247,354,885,149,670,824;26;M
80791;354,1582,490,654,885,1616,839,243,105,1335,402,82,70,1730,200;45;F
80811;793,670,247,200,1730,502,374,80,407,79,243,1616,1204,354,885;38;F
80842;247,374,441;38;M
80843;1593,1383;38;F
80896;1593,1383;8;F
80931;670,1204,354,654,657,793,1730,695,1255,374,791,79,80,1593,138;40;F
80977;1730,149,441;26;M
80997;695,1730,247,1255,424,588,1616,852,445,854,657;39;F
80999;1730,502,80,407,79;37;F
81023;791,374,502,70,695,793,670,200,1730,82,80,246,138,1616,406;29;F
81057;793,670,200,1730,70,402,559,354,149,462,787,138;32;F
81091;200,824,1616,1593,354,149,1383,787;34;M
81095;588,406,824,1616,559,1393,1582,654,1180,490,138,82,1204,1593,1383;42;F
81137;70,1255,374,839,1204,462,1393,885,1180,728,670,406,559,354,138;40;M
81185;79,1204,354,445,1383;61;F
81218;138,80,70,1593,1383;44;M
81242;1326,354,1383,490,793,1730,695,70,80,79,406,1593,885,149,138;47;M
81281;654,490,728;16;F
81316;728,787,445,1593,839,243,246,374,502,1255,695,105,1616,149,138;22;F
81361;670,200,79,839,1616,138;39;M
81364;1393,787,1582,1180,657,728,1326,1730,1723,1616,1204,1593;27;M
81418;354,490,80,839,1730,82,588,1616,1204,1593,1383,1393,1582,1180,138;12;M
81456;839,588,243,762,670,695,502,1593,354,445;28;F
81460;793,200,1730,150,70,502,80,407,79,246,243,839,559,354,138;48;M
81481;670,793,200,1730,695,70,82,1255,374,243,588,406,1616,559,654;50;F
81493;1383,70,839,406,559,1593,354,149,138;51;M
81495;657;20;M
81535;105,1616,354,247,654,852,657;27;F
81587;354;25;F
81598;1393,1582;43;M
81693;402;45;F
81697;354,885,854,654,82,80,1616,1204,1593,1383,1393,1582,1180,490,138;7;M
81704;670,793,1326,247,150,695,1616,1204,1593,354;21;F
81718;657,670,1730,374,105,1204,354,1383,441,445,1593,793,695,1255,1616;29;F
81755;490,445,406,1582,200,695,70,1335,105,243,1616,559,1393;67;F
81848;1730,1616,247,695,82,1255,80,79,406,1593,445,787,654,490,138;41;M
81858;1393,1582;41;F
81859;1593,1383;43;F
81875;762,200,670,490,654,1730,70,1255,1335,588,406,1616,354,885,854;70;F
81893;1593,1383;46;M
81912;1393,1582;16;M
81913;150;43;M
81916;787,490,138,654,1383,885,1593,1204,1616,762,1255,1730,247,1326,670;27;M
81989;654,657,490,1383,1593,1204,374,1255,695,200,670,354,149,854,138;28;F
81991;654,854,445,354,559,588,407,502,762,82,695,1730,200,247;22;F
82028;1616;28;M
82062;654,1730,246,105,1616;21;F
82161;654,1730,82,80,588,1616,1204,1593,354,1383,1393,1582,1180,490,138;47;M
82171;787,695,138,654,1593,791,1616,839,1730,200,793,670,762,374;35;F
82206;445,793,200,695,1255,839;36;F
82238;670,1326,1730,791,1593,793,695,1255,1616;26;F
82253;105,70;31;F
82267;1730,445,490;54;F
82275;402,1730,70,1335,105,246,588,1723,406,824,559,654,441,852,854;43;F
82367;441,885,839,402,695,1730;28;F
82394;82,852,854,1616,654,490;49;F
82428;1593,1204,791,793,762,885,695,670,1326,1180,354,839,200,247,138;20;F
82436;82,1616,490;29;M
82459;445,588,839,1616,1593,1383,695,82,200,247,246,424,824,885,490;40;M
82461;1593,1180,138,657,1255,200,670,559,354,839,374,70,1730,885,654;51;F
82478;138,441,1616,1723,588,1730,793,670,82,762,424,791,728,1326;63;F
82483;1204,762,1723,670,354,502,839,149,1383,1593,105,406,695,82,793;27;M
82537;247,728,1255,79,354,490,445,787,1730,70,82,80,105,407,502;9;M
82556;1204,406,1326,654,200,1730,70,1255,762,1335,1616,1593,728,670,793;34;F
82595;80,374,105,588,839,824,791,354,1582,200,1204,1593,885,654,1180;38;F
82645;1204,1593,354,852,149,462,445,787,441,138,670,247,839,885,728;27;M
82652;1582,787,243,246,105,247,200,1730,70,82,1255,762,80,407,502;5;F
82659;1593,1383;11;F
82674;695,670,200,79,1616,791,1204,1593,354,885,445,787,854,654,657;22;F
82677;1730,150,80,105,243,424,839,1616,559,441,138;48;F
82687;1593,1383;41;M
82759;374,1335,791,787,728,762,1326;92;F
82766;793,588,670,200,1255,402,374,406,657,654,354,791,105,70,1730;35;M
82800;1723,80,82,670,200,1730,695,1255,374,79,406,1593,354,70,1616;49;F
82811;200,1730,839,1616,728;16;F
82818;1616,354,885,1383,793,670,247,695,82,374,559,1593,490,138,728;38;M
82835;247,1730,695,762,839,1616,1204,354,445,854,787,138;24;F
82851;885,793,839;25;F
82868;1730,695,762,1616,1593;42;F
82893;105,82,1326,80,79,246,1616,354,885,1383,1393,1582,1180,138,149;39;M
82905;82,70,793,670,247,200,1730,105,839,1616,559,1593,885,787,654;22;F
82960;105,885,149,490,70,406,354,1730,79,200,82,1616,1204,1593,1383;43;F
82981;445;49;F
83089;200,1335,1730,588,441;71;M
83095;407,70,502,406,852,1582;47;F
83127;1616,354,80,79;36;F
83135;695,374,407,1616,354,445,854,787,654,138;56;F
83136;839,791,559,1593,787,654,138,793,200,695,79,1204,354,149,445;40;F
83144;1730,1593,1383;42;F
83154;82,695,793,462,149,885,490,1180,1616,839,79,1730,1326,354,138;35;M
83166;1616,1723,588,80,70,200,247,1730,79,354,149,1383,654,490,138;35;M
83185;1593,1383;13;M
83197;588,1616,559,852,854,441,247,82,502,445,787,1582,1180,490,138;80;F
83228;1730,1593,1383;8;M
83239;695,402,80,79,839,1723,1616,1383,1593,82,247,200,246,424,824;43;F
83259;728;43;M
83315;670,793,200,1730,82,1616,1593;45;M
83328;200,1730,70,82,80,79,839,406,1593,1204,354,149,1383,1180,490;13;M
83366;787,654,1180,490,441,695,82,407,79,839,1616,1393,1383,80,138;32;M
83419;70,105,406;70;F
83433;728,793,670,1730,82,762,402,374,1616,1593,885,854,787,654,138;41;F
83642;1616,1593;30;M
83673;1326,247,462,490,670,138,885,839,793,200,1730;28;M
83674;149,445,728,138,654,787,1383,354,1593,791,824,79,407,695,1326;25;F
83680;402,670,793,200,1255,762,374,1335,105,243,1204,791,787,138,728;73;F
83716;70;17;F
83727;670,793,374;61;M
83746;247,588,1616,695,839;19;F
83747;657,885,1593,1255,762,839;37;M
83759;793,791,1204,787,654,670,695,1255,243,852,885,462,1393,441,657;28;M
83812;657,149,354,791,502,200,824,885,793,670,1326,695,1204,654,138;30;M
83829;793,243,824,1593,1616,1335,1730;21;F
83854;407,1204,1593,79,654,502,138,70,406,1616,354,149;53;F
83897;1616,885,839,149,138,354;24;F
83912;70;43;M
83914;670,1326,200,1730,762,1616,559,1593,885,462,1393,728;1;F
83918;200,793,670,1730,762,839,1616,559,1593,885,1393,654,657,728;42;F
83935;149,1204,1255,200,793,728,670,762,1326,695,839,462,445,1180,138;36;M
83956;695;40;M
83958;695,762,402,374,854,654;39;M
83963;670,1593,490,82,885,1730,762,374,588,824,1616,854,787,654,728;30;F
83972;1593,1383;7;F
83994;695,1616,490,1383,1593,82,200,424;48;F
84010;670,793,1326,200,1730,695,374,839,1723,1616,791,1204,1593,354,654;22;F
84013;1593,1383;1;M
84026;793,402,105,885,854,654,1730,200,70,762,559,1593,1255,695,445;31;F
84032;1204,1593,588,374,1255,695,200,793,670,354,445,787,654,1180,490;41;M
84033;1616,1593,885;41;F
84044;407,402,1255,200,1730,728,793,670,762,374,80,559,1593,885,138;34;M
84050;402,1335,243;74;M
84070;1616,354,1383,791,1204,1593,839,654,695,374,1326,1730,200,793,670;23;M
84108;243,1335;75;F
84115;70;78;F
84127;406,854,695,70,402,374,1335,105,243,824,791,1204,1593,354,787;68;F
84271;1326,200,354,1730,490;25;M
84273;1616,1593,854,138,657,728,354,839,105,1335,1255,70,1730,79,654;33;M
84282;762,82,70,695,1730,588,824,1616,1593,654;30;F
84299;1393,885,374,762,695,839,1204,793,654;28;M
84311;1593,695,762,839,885;32;F
84312;1326,728,670,1730,762,839,1723,1616,791,885;19;M
84341;670,791,559,1593,885,787,654,1326;52;F
84380;1204,1326,1255,1593,885,787,654,670,793,200,1730,374,246,839,791;32;F
84381;791,787,490,793,670,200,1730,70,82,79,406,1204,354,1593,1383;26;M
84396;1335,105,424,243,839,1616,1593,852,885,1383,854,1582,1180,138,657;25;F
84494;200,1730,82,246,406,824,1616,854,654,138,695;26;F
84540;200,1730,839,1616,885,1393;44;M
84574;79,1723,1393,654,1616,791,787,793,374,839,885;43;F
84579;1593,1383;49;F
84603;1723,1582,138,1326,200,695,502,80,243;24;F
84608;1326,200,82,502,80,1335,105,243,839,1616,854,787,654,441;27;F
84618;200,793,670,80,1723,1593,728,1180,354,138;40;F
84647;1255,793,695,374,407,839,1204,1593,354,885,462,445,787;24;M
84654;374,762,200,793,787,854,354,1593,1723,695,1730,670,839,1616,885;26;F
84657;793,200,80;36;M
84692;200,445,885,1204,1593,354,1616,588,70,1326,670,1383,787,441,695;44;M
84697;1593,1383;10;F
84729;1593,1383;15;F
84742;1723,1593,1393,793,654,502,490,354,149,1730;40;M
84764;354,149,1383,138;36;F
84789;762;71;F
84816;80,354,1180,138;5;M
84836;247,1730,695,762,1255,80,424,1616,1593,445,787;29;M
84851;82;44;M
84856;657,374;28;F
84888;1255,1730,200,793,787,1335;32;M
84902;1616;28;F
84929;82,1255,762,246,149,490;34;M
84936;559,791,588,762,670,793,824,654,138,728;47;M
84973;247,354,793,200,695,762,80,79,1616,1593,1383,787,654,1180,657;63;M
84998;407,839,1616,354,654,138;30;F
85023;670,793,200,1730,695,82,1255,80,79,839,1616,445,490;43;F
85026;402,1255,762,105,824,885,654,1582,854,1335,246,1723,1616,1593,354;29;F
85098;670,246,1616,791,1593,852,885,1383,138;35;F
85126;787,445,354,1593,1204,791,374,1255,695,200,793,670,839,1616,885;29;M
85140;654,441,1616,138,1730;24;M
85145;787,728;51;M
85170;1383,885,149,354,1204,1616,588,243,200,502,80,79,839,654,138;30;F
85251;588,354,1593,1204,1616,80,82,695,1730,670,1326,793,1383,854,654;33;F
85262;374,1730,200,149,1616;28;M
85292;247,82,854,654;58;M
85430;670,1582,149,105,1335,762,793,695,1204,374,80,406,1616,559,1393;36;F
85538;657,728,490,1180,1383,791,79,200,762,80,839,354,885,787,654;41;F
85654;670,82,588,1616,793,200,762,374,1335,824,1593,854,839,885,654;30;F
85679;462;43;M
85719;1180;69;M
85721;490,1582,1326,247,1730,695,82,1255,1393,441,138,657;31;F
85776;670,793,200,695,1255,791,1204,1593,885,787,374,839,1616,354;24;F
85793;502,79,354,852,885,1383,1582,1204;37;F
85830;728,138,1730,1255,1335,1723,670,1326,839,791,1204,1593,1383,1393,1582;38;M
85890;105,402,138,787,1723,839,200,670,80,79,885,70,1616,406,1730;49;F
85925;105,407,80,374,402,762,1255,200,1326,793,695,82,1204,1593,445;15;F
85926;728,1335,374,82,1393,1204,1180,1593,149,138,787,793,839,354,80;28;F
85958;793,1730,695,374,839,824,1616,791,1204,1593,354;25;F
86038;670,793,70,762,1593,885,787,654;29;F
86056;1616;35;M
86071;728,1255,407,105,354,854,787,441;64;F
86072;1393,1582;19;F
86089;1616;26;F
86092;80,839,1204,354,885,1383,728,670,793,200,695,462,445,787,657;41;F
86168;657,654,1204,762,670,885,1593,791,1616,839,374,793,1730,695,1255;39;M
86274;695,79,728,1383,354,1593,1204,1616,839,80,762,70,200,670,1326;40;M
86317;490,1326,200,762,839,654,70,105,246,243,406,354,149,441,138;32;F
86319;885,354,1593,791,1204,670,793,200,1730,695,762,1255,1616,462,138;74;F
86333;80,1393,105,1616,445,787,490,657,728,200,1730,695,762,839,885;40;F
86346;445,149,791,200,490,1582,787,1593,1616,793,670,374,243,762,82;66;F
86496;670,247,200,695,82,402,839,1616,885,149,654,490;24;F
86556;82,354,670,1730,80,407,243,1616,559,462,1393,1582,654,490,441;25;F
86559;1255,1730,406,82,839,885,149,1393,654,490,138;36;F
86595;793,200,1255,402,407,588,824,885,149,445,1730,695,70,839,1616;33;F
86605;793,200,1730,695,1393,654,657,885,839;45;M
86625;670,793,695,1616,791,1593,354;20;F
86626;490,654,1616,1255,839;39;F
86628;793,354,490,670,1255,1730,695,70,82,79,1593,885,1383,654,138;29;F
86630;79,1593,138,354,70,1255,1616,149,490,670,793,200,1730,695,654;27;M
86689;1335,1616,445,200,695,70,105,243,406,559,854,1393,1582,490;45;F
86691;1326,1723,670,1616,138,839,200,793,695,70,885;41;F
86702;354,490;16;M
86724;670,793,200,149,1383,787,1730,1723,1616,70,82,374,406,885;49;F
86727;854,787,670,247,200,1730,70,82,406,1616,559,445,654,490,441;32;F
86751;1616,885,1730,82,80;42;F
86753;200,670,1582,839,82,793,70,374,1730,1255,105,79,1616,885;38;F
86791;247,80,839,1616,654;24;F
86800;70,839,791,1593,354,728,885,762,1730,793,670,462,787,654,138;32;M
86819;670,793,1723,200,1730,70,80,105,79,839,406,1616,885,787,138;13;F
86837;82,762,79,839,1616,1593,852,885,654;52;M
86843;70,82,762,839,406,354,149,445;58;F
86860;149,1383,1326,246,105,406,200,70,839,559,1593,354,885,1180,138;48;F
86879;1383,787,728,657,654,885,1593,791,1616,839,762,1255,1326,793,670;31;M
86927;149,1593,374,1326,670,70,82,80,406,1616,559,354,1383,441,138;72;F
86954;374,559,138,793,670,200,1730,70,82,839,406,1616,885,490,441;23;F
87010;670,1582,762,787,793,462,502,247,79,80,839,105,246,445,654;26;F
87019;654,441,149,885,354,1616,559,243,402,1255,70,695,793,1326,657;15;F
87063;462,490,728,885,793,654,854,1616,824,839,588,246,1335,402,70;52;F
87128;1616;39;M
87141;1383,445,149,1204,791,588,670,793,200,1730,762,1593,854,462,787;31;F
87297;374,407,1616,791,1204,354,445,787,657,728,670,793,1593,1383,138;32;F
87298;246,1582;59;M
87343;374,1593,445,1180,670,793,200,1730,70,80,407,406,1204,354,138;43;F
87350;402,1335,407,839,824,852,728,670,200,246,588,791,885,445,854;27;F
87353;670,1593,462,787,138;34;M
87398;354,1204,824,793,670,1730,762,1616,791,1593,885,728,787;35;F
87432;791,1723,762,70,1383,787,138,728,1730,793,670,374,839,1593,885;43;M
87439;793,762,1335,1204,149,670,247,1730,695,407,246,839,1616,445,490;49;F
87508;670,839,1593,354,490;27;F
87626;80,1723,1730,502,402,424,1616,354,559,149,462,1393,70,105,654;38;F
87637;149,462,1723,1730,70,502,402,80,424,406,1616,559,354,1393,654;44;M
87697;670,200,1730,695,82,374,407,79,1616,354,885,149,1582,654,138;25;F
87704;80,200,1730,1326,70,82,1335,105,1616,354,149,490,138,1383,406;51;F
87714;793,247,70,79,1593,138,695,82,246,588,1616,852,445,490,657;34;F
87720;670,793,200,1730,695,70,839,885,445,490;57;M
87748;407,793,670,588,791,1204,490,1730,839,1616,559,1593,354,885,654;27;M
87808;80,839,490,200,1730,1180,138;49;M
87833;462,1180,82,354,1616,1730;21;M
87854;1730,559,490;35;M
87899;150;16;M
87906;670,200,1730,70,82,762,406,1616,559,1383,854,787,654,490,441;71;F
87924;1593,885,654,441,657;23;F
87945;1593,1383;41;F
87974;490,657,654,1582,462,354,559,79,80,82,70,1730,1616;32;F
87975;824,559,885,787,490,728,1326,1730,82,1335,1616;33;M
88010;670,1255,406,559,354,462,200,1730,839,885,149,1180,138;33;F
88060;793,852,1383,1582,654,657,490,138,445,1616,824,246,79,82,695;57;F
88079;1593,1383;39;M
88097;787,791,839,502,200,1730,138,654,885,354,1616,79,80,793,670;27;M
88128;1593,1383;8;F
88143;1326;24;F
88148;793,728,670,200,1730,695,1255,839,1616,1593,354,885,462,445;37;M
88150;1204,791,839,1326,885,728,787,1593,138,695,1255,670,793,1730,374;36;F
88153;1326,885,728,657,787,1593,138,670,793,695,1730,1255,374,1616,445;37;M
88221;1593,1383;5;M
88222;1730;60;F
88236;670,70,839,885;37;F
88248;1593,1383;71;F
88269;728,793,1730,762,1723,1616;49;M
88272;793,1326,695,502,424,246,839,1723,1616;19;M
88283;695,762,462,200,1255,374,791,787;37;M
88291;1593,1383;76;M
88307;402,374,79,246,588,1616,1593,354,885,1393,1582,793,1730,1383,138;53;F
88359;559,149,138,854,402,1730,200,70,82,762,246,588,1616,654,490;59;F
88393;1593,1383;69;M
88450;839,1723,1616,791,1204,1593,885,149,462,445,787,654,1180,490,138;27;F
88451;1255,374,80,1616,791,1204,354,787,490,138,657,670,1730,695,445;40;F
88465;490,670,200,150,402,246,588,1616,559,138,728,1335,441,654,839;48;M
88478;762,502,374,246,588,839,791,559,1593,354,885,462,1393,787,1582;32;M
88493;200,82,1730,70;67;F
88510;1582,793,670,695,374,407,791,1204,1593,354,1383,445,1180,138,657;37;M
88544;1255,200,793,670,1383,654,374,80,1593,354,885,728,82,762,70;38;F
88574;200,839,138,1730,695,70,243,406,824,1616,559,445,854,1393,654;35;F
88590;793,885,200,670,1730,1255,839;67;M
88596;1393,1582;49;M
88608;200,70,246,243,1723,406,791,559,1593,885,462,787,654,728,490;40;F
88619;1730,728,441,787,1393,885,852,670,1326,70,246,1723,406,559,654;53;M
88645;588,839,824,1616,559,1593,149,1383;47;F
88658;1204,1255,695,1326,200,1730,374,791,787,1180,670,1593,354,149,138;68;F
88681;82,246,1616;29;F
88755;793,200,695,82,445,787,441,138;24;M
88787;445,402,588,670,200,150,1335,246,1616,559,654,490,441,138,728;15;M
88799;885;46;M
88895;1326;40;M
88960;82,407,200,150,402,1335,246,588,1616,559,654,490,441,138,728;13;F
89076;406,1582,654,728,670,82,762,1616,559,354,852,149,1383,490,138;50;F
89091;1616;27;F
89099;728,670,793,1730,762,839,885,490;36;M
89124;406,1593,149,445,490,138,247,1730,200,82,80,407,1616,559,354;39;F
89128;82,762,406,1616,654,490;36;M
89137;1593,791,824,105,1730,1393,559,1616,406,243,1335,82,70,247,1326;23;F
89150;374,1723,791,1593,1383,1180,200,839,354,885,787,1730,1255,149,138;49;F
89256;1255;39;F
89264;559,1383,728,1723,246,80,374,762,82,490,138,787,354,200,1730;42;M
89283;407,105,79,839,1723,824,1616,791,354,852,445,1383,1582,654,247;30;F
89317;1616,852,462,854,728,441,787,885,1723,246,762,82,70,1730,670;61;F
89326;246,70,200,762,406,1616,1593,354,728,243,1730;71;F
89353;1255,728,670,793,839,1723,1593,885,462;29;F
89395;670,247,695,1255,374,407,105,79,839,1723,1616,791,1204,354,1593;18;F
89487;243,149,728,490,1180,441,138,79,354,1593,1616,1335,80,502,1383;42;F
89499;588,1730,793,462,1383,654,1180,670,1326,762,839,1723,885,490,728;38;M
89546;138,1180,1393,885,354,1723,588,243,246,762,82,79,839,1616,1383;36;M
89562;1255,762,80,559,79,407,1730,695,70,82,243,406,1616,445,490;57;F
89570;462,787,138,657,762,445,1593,839,1255,793,670,1326,200,1730,695;57;F
89576;839,1616,559,728;35;F
89581;670,247,695,1335,839,1616,445;46;F
89597;150,695,670,793,502,441,657,728,1335,105,824,1393,402,854,654;46;F
89639;793,1730,762,374,728,138,490,787,354,1204,791,1255,200,670;42;M
89650;793,1255,80,839,1616,728;63;F
89661;670,793,200,1730,80,354,885,787;30;M
89685;1730,1593,1393,1582,374,839,885,1180;33;M
89707;1326,793,1730,695,246,588,839,824,791,1593,354,885,149,787,654;21;F
89723;200,762,246,1593,885,670,793,1326,1730,1255,374,1204,354,854,657;24;F
89753;670,1326,200,695,1255,374,1593,354;30;F
89758;1335,82,70,200,402,406,654,670,791,1730,762,374,490,787,728;74;F
89823;1730;33;F
89826;787,654,791,824,246,79,80,402,200,793,670,1730,695,762,374;63;F
89841;1383,854,200,793,1730,82,762,80,246,588,1593,885,654,138;36;F
89856;695,200,1326,1255,793,670,374,839,791,1593,885;28;M
89890;728,588,80,374,82,70,200,1326,670,406,1616,791,559,885,787;24;F
89894;138,791,839,670,793;44;M
89924;138,243,791,70,670,80,1616,1180,1255,885,1335,374,762,1593,1383;39;M
89929;1582,852,82;25;M
89982;854,1393,441,793,1326,247,695,402,1335,79,105,839,1204,354,1593;23;M
89987;793,695,1255,374,80,407,246,839,1204,1593,354,885,1383,1180,138;24;F
90017;149,588,490,138,200,1730,70,82,105,79,424,839,406,1616,559;36;F
90110;670,793,70,839,406,791,1593,852,787,1730,82,1616,885,490,1326;26;F
90155;791,243,1326,670,793,762,839,1616,354,885,445,787,200,1730,695;30;F
90174;79,82,70,247,200,695,80,839,1616,559,354,885,149,445,138;33;F
90241;200,70,82,762,80,79,1616,559,885,1383,654,246,1204,490,138;35;M
90250;374,200,70,793,791,787,670,1730,1326,885;43;F
90319;374,200,70,793,791,787,670,1730,1326,885;8;F
90332;670,82,1593,354,885,787;41;F
90342;502,402,839,445,441,82,70,695,1730,80,1616,1593,885,787,654;27;M
90358;374,200,70,793,791,787,670,1730,1326,885;41;M
90392;793,670,1326,247,200,695,1255,374,839,791,354,462,445,787,138;25;M
90398;354,1593,1204,559,406,80,374,762,200,1730,247,670,793,695,82;25;M
90423;793,1326,200,695,1255,839,791,1593,885;29;F
90450;670,200,70;31;M
90528;839,1393,490,793,1730,762,824,885,149,354,70,82,1335,1616,441;57;F
90563;407,445,70,670,490,138,728,793,1730,762,588,1616,559,149,654;61;F
90583;728,138,787,1593,1204,588,762,793,670,791;54;F
90631;762,354,1730,406,70,374,462,490,138,657,200,402,105,1616,791;23;M
90667;1255,1326,462,138;19;M
90683;1616,839,105,80,1255,82,695,1730,247,1326,793,670,200,70,654;22;M
90686;559,502,150,1730,793,1335,824,1616,854,1582,654;38;F
90691;1204,791,374,502,82,695,1730,670,793,839,1616,559,1593,885,354;20;F
90858;1730,82,246,1593,354,1383,854,1582,654,490,138;35;F
90897;354,1593,407,80,1326,657,885,1204,791,839,374,1255,695,793,670;26;M
90899;354,793,1616,1593,1383,200,1730,82,1255,80,839,885,445,654,490;58;F
90903;670,200,695,839,1616,354,149,1383,490,138;42;M
90912;407,502;25;F
90913;670,1616,824,1204,1593,1383,654,1180;85;M
90944;1616,406,246,105,1335,200,793,670,1730,824,559,588,82,70,885;37;M
90959;1616,354,149,1383,854,1180,1730,80,79,1204,1593,1393,1582,490,138;24;M
91002;424,79,80,502,762,670,793,1730,200,695,70,406,559,445,654;33;F
91003;1326,1616,885,728;27;F
91108;762,79,1616,1593,354,490,670,247,200,82,1255,1335,839,885,654;46;F
91123;854,1383,138,670,1393,1593,1204,1723,1730,502,407,839,1616,885,728;44;F
91174;670,1326,70,246,1723,1593,885;62;M
91190;839,728;41;M
91192;695,762,374,406,1616,791,559,1204,1593,354,885,149,854,654,728;31;F
91212;1616,1204,1593,885,1383,490,441;46;F
91228;657,854,1335,402,82,695,1730,70,80,406,559,852,1180,1582;43;F
91241;1326,728;30;M
91248;1593,1383;50;M
91268;502,407,149,138;44;F
91274;1180,490,441,138,657,670,1326,247,200,1730,695,150,1255,502,407;37;F
91310;79,80;47;M
91327;1255,502,79,424,243,588,839,559,885,654,138,200,793,695,1616;41;M
91329;670,1730,787,762,1335,246,588,1723,824;67;F
91337;1326,247,1730,695,150,70,82,1255,762,502,407,406,559,1204,1593;11;M
91349;82,502,80,407,79,1616,354,149,490;42;F
91365;670,1730,695,559,1593,149,462,138;35;M
91374;793,670,200,1730,1255,762,1616,791,885,728,787;51;F
91428;791,243,80,79,839,1723,1616,1593,374,670,762,787,1180,138,728;25;M
91481;490,1593,559,588,105,1255,82,1730,70,839,406,1616,654;55;F
91499;670,1326,70,406,728,138,490,1393,149,354,1723,79,793,82,462;45;M
91506;1593,885,149,445,1383,824,839,588,246,374,82,70,1730,854,654;26;M
91776;441,793,695,654,247,354,80,243,149,1255,138,1180,1204;33;M
91806;490,728,1326,670,247,839,1616,791,149,462,654,138,695,1593,354;26;M
91857;374;71;F
91858;787,1593,670,793,1730,695,374,1180;35;F
91869;82,1393,200,1730,1255,839,1616,885;63;F
91884;670,1326,1593,354,852,787,441,374,1730,200,793,695,82,80,1616;18;F
91903;695,1593,79,1616,354,885,1383,1393,654,441;39;M
91904;82,374,1616;24;F
91913;82,407,559,885,445;28;F
91937;885,654,80,839,1730,200,138,854,246,1335,243,1616,588,402,70;28;F
91939;138;43;F
92020;654,200,70;35;M
92113;885;35;M
92121;82,1616,354,138,490;19;M
92152;588,1335,374,82,1730,728,885,559,791,1616,824,406,762,70,1326;45;F
92257;670,793,885,462,657,762;55;M
92258;728,441,490,791,839,1326,1730,82,762,374,1335,1723,1616;45;F
92271;200,445;53;F
92359;1730,82,1616,490,670,793,654;26;M
92379;670,1255,374,839,1723,1616,791,1204,1593,354,445,654,490,657,80;51;M
92385;839,374,762,200,247,670,1326,1730,1616,1593,885,654,1582,695,445;23;F
92448;1730,762,654,787,1383,149,354,1204,374,82,695,1326,1593,462,490;26;F
92455;670,1326,695,80,79,1723,1204,1383,1180,138,354;25;M
92466;793,670,200,695,1616,1593;22;M
92477;839;21;M
92519;793,402,374,1335,559,1593,149,654,1326,1730,695,82,1616,445,490;32;F
92553;1730,1255,441,406,70,105;62;F
92586;80,407,588,354,149,854,654;28;M
92595;243,354,1730,654,1593,462,70,406,852,670,793,1326,200,695,1255;48;F
92601;1326,728,787;72;M
92644;787,149,462,374,82,670,793,1730,695,762,1616,791,1593,885,490;21;M
92664;138,670,793,1326,200,82,1255,762,402,374,1335,1616,654,839,588;44;F
92699;70,695,1326,793,670,406,354,149,1383,1393,1582,138,1616,1204,1180;50;M
92711;670,200,1730,762,105,791,1593,885,787,728,1326;69;F
92784;793,839,885,462;84;M
92858;1335,490,654,787,462,354,1593,1204,1616,374,1255,82,695,670,793;31;F
92905;1582,762,354,149,70,1730,670,200,374,654;30;F
92945;441,657,695,1730,70,1255,402,1335,105,1616,559,654,424,839,824;35;F
92963;441,657,695,1730,70,1255,402,1335,105,839,824,1616,559,854,654;35;M
93079;1204,839,1730,762,791,1593,1383,670,793,200;32;F
93088;70,80,246,1616,1593,1383;10;F
93099;1383,1255,695,793,1723,1593,354,885,80,839,1204,1393,654,1180,138;24;M
93131;670,793,695,1730,82,402,1593,885,654;30;F
93161;1593,559,1383;8;M
93168;839,793,1326,695,243,445,1730,1255,105,1616,1593;25;F
93217;670,793,200,1730,695,1255,406,1616;35;F
93290;1616,839,657,1255,695,1730,200,670,793,1326,791,1204,1593,354,885;28;M
93295;1730,200,354,885,657;68;F
93323;1255,695,1730,885,1393;48;M
93388;670,1723;44;F
93407;1326,824,1616,854;24;F
93485;445,670,793,200,1730,243,839,1616,1593,354,885,787,490,138,728;32;F
93486;1593,502,402,588,824,885,854,105,654,670;31;M
93498;374,1730,200,1326,793,670,839,791,559,1204,1593,354,885,654,138;24;F
93523;1616,854,490,885,588,1335,1730,200,670;32;M
93528;670,247,1255,1616;23;F
93587;82,1723,824,1616,854,1393,654;36;F
93617;885,374,695,1616,791,354,1593,1204,793,839,824,654,670,200,787;40;F
93641;70,1730,200,762,791,559,354;51;M
93682;1616;26;M
93761;654,1383,462,354,559,70,406,138,149;35;M
93770;247,793,462,1180,138,728,670,695,1255,791,1204,1593,354,885,149;32;M
93797;445,247,82,1616;35;F
93882;354;53;F
93909;200,695,762,80,79,354,149,445,854,654,1730,82,839,1616,490;23;F
93933;1326,70,657,654,1393,1616,839,354,885,149,138;44;M
93957;1616,793,82,402,1335,588,1730,654,1204,1593,354,852,462,854,138;20;F
93991;149,1582,490,70,82,80,79,406,1616,1204,1593,1383,654,138;47;M
94008;243,1593,445,490,793,670,200,82,1723,1616,354,1383,1582,654,138;19;F
94028;670,502,80,1593,654,854,824,793,695,402,243,588,839,354,445;27;F
94052;787,200,374,1255,1335,588,791,1593,1616,695,793,670,1730;40;F
94139;885;29;F
94175;670,793,247,200,1730,407,885,1593,824,588,1335,695,1616,445,654;28;F
94210;787,657,1730,1335,852,793,1326,695,70,588,839,1616;43;F
94283;1180,670,200,1730,762,824,559,1204,885,462,854,654,490,138,728;33;F
94286;441,1204,1326,695,1255,670,1616,791,354,138,793,200,1730,70,839;34;F
94294;200,791,1593,670,1730;44;F
94327;791,445,787,654,657,1730,695,1616;34;M
94329;246,80,79,885,1393,354,1616,839,105,407,1730,70,502;52;F
94365;791,1616,839,588,80,82,1730,247,1326,200,79,354,445,654,490;25;M
94387;247,839,885;33;F
94388;762,402,1204,1582,1180,728;48;F
94399;406,1730,1616,1204,852,1393,1582,670,793,1593,1383,654,441;38;F
94505;80,839,1616,1593,354,885,654;28;F
94538;1393,490,1616,82,200,762,885,654;43;F
94578;695,1255,402,407,79,588,839,354,1383,654,490,441,1616,1593,138;17;F
94604;1593,1383;41;F
94614;1326,70,695,200,247,670,762,79,839,1593,354,885,1180,138;36;M
94647;79,149,462,1393,138,728,354,70,670,793,200,762,839;73;M
94698;247,200,80,105,1616,354,787,728;23;F
94712;407,1593,445,79,1255,793,670,200,695,374,1383,354;22;M
94733;670,695,1204,354,1326;35;M
94803;105,588,824;25;M
94857;1593,1383;13;F
94927;1593,1383;9;F
94954;1730,670,354,695,1255,885,374,793,791,1180,839,1593,1204;40;M
94969;695,70,402,1335,105,588,406,559,852,445,854,787,441,657;66;F
94995;839,824,885,654;42;F
95002;793,1204,1593,1326;45;F
95003;1255,374,654,728,1180,445,354,791,793,200,138,1204,670,839,885;21;M
95064;654,787,354,1593,1204,839,588,105,670,793,695,1255,1616,441,243;20;F
95128;1730,695,354;20;F
95177;490,462,354,1593,424,1326,670,793,82,79,1723,445;13;M
95207;793,1730,70,82,1255,407,839,1593,885,654,502;41;M
95222;1730,82,1616;19;F
95271;657,1593,1204,374,695,200,793,670,588,791,1730,762,1616,559;30;M
95282;246,149,1393,138;54;F
95298;787,654,1180,728,200,1730,82,502,80,407,79,839,354,885,490;44;M
95319;502,407;78;M
95337;670,793,1326,695,374,80,105,246,406,559,1593,354,885,1383,138;42;M
95387;728,243,670,200,1730;12;M
95401;354,1593,1204,1723,695,1326,1730,885,1383,654,490,138,80,839,1616;28;M
95405;82,1255,762,402,80,839,1723,406,1616,559,852,885,445,1393,654;30;F
95413;70,1255,502,559;49;F
95459;200,1730,1255,588,1723,1593,138,885,246,762,670,70,374,728,1616;47;F
95475;793,200,1730,1723,1204,1593,885,80,79,354,82,654,839,695,1255;39;F
95549;1616;29;F
95601;374,1616,1204,787;19;F
95705;791,1204,1593,354,402,762,1255,150,200,793,670,445,787,654,1730;32;F
95723;1255,839,695;30;F
95754;200,70,82,762,402,407,424,1616,1593,354,149,445,654,490,657;42;M
95775;654,445,885,354,1204,839,695,670;20;M
95782;885,149,490,138,1730,150,82,402,406,1616,70,105,839,559,654;49;F
95786;502,246,462,1180,1730,80,79,1616,1593,354,885,1393,1582,490,138;25;M
95828;80,70,246,839,406,1616;57;F
95843;793,670,791,839,695,787;32;M
95867;149,445,793,839,791,1204,1593,354,1383,787,1582,728,1723;20;M
95879;445,1180,885,1616,839,79,80,1255,82,70,1730,200,793,670,695;33;F
95882;670,247,82,1616,1593,462,445,138;28;F
95904;1255,588,1616,1204,354,374,762,82,695,1730,670,791,559,490,149;26;F
95916;762,82,695,670,1723,728,885,1593;21;M
95920;657,787,354,1616,839,80,1255,1730,200,1326,793,670,695,407,885;33;M
96003;502,407;78;F
96036;1723,374,1255,1730,1616,1593;21;F
96074;247,695,762,502,80,105,79,246,406,1616,559,885,445,854,654;18;F
96085;354;86;F
96108;1255,105,406,791,1393,787,1723,1593,695,1730,793,839,885,728,445;27;M
96141;80,70,82,502,406,1616,559,354,149,1582,138;42;F
96150;462,1393,490,138,559,406,762,670,82,1255,695,793,243,1616,654;37;F
96162;1593,246,407,247,670,445,885,354,1204,791,374,1255,200,793,695;35;M
96173;824,424,1255;49;M
96181;406,824,1204,138,657,441,854,462,852,354,246,105,200,1730,1255;66;F
96211;670,70,1723,839;49;M
96228;70,559,354;38;F
96237;138,885,374;40;M
96245;407,502;40;F
96254;138,654,1616,374,670,793,200,1730,70,762,105,559,1593,441,728;72;F
96287;728,670,793,200,695,762,374,79,839,791,1204,1593,354,1383,654;29;M
96290;670,80,407,1723;25;M
96308;1393,1582,1730,70,82,762,1255,402,105,243,1616,885,654,490,728;51;M
96316;502,407;12;M
96330;407,1616,885,445,654,490,441,1383,1593,138,149,1393,1582,1180,1204;36;F
96397;407,502;9;F
96402;885,728,787,839,1730,670,374;22;M
96439;885,654,490,138,670,793,1730,695,70,105,839,1616,559,1204,1593;24;M
96444;490,138,1730,70,374;55;M
96451;243,1616,559,462,654,490,138,1393,424,246,1335,200,1730,762,70;62;F
96452;1730,445,839,695,70,559;48;F
96470;407,502;7;M
96474;824,839,243,670,793,200,695,1616,1593,885,654;26;F
96543;1255,1616,1593,445;36;F
96556;1255,80,243,839,852,787,1582,654,441,247,70,246,406,1616,559;18;F
96563;502,762,670,82,1180,793,654,1593,407,839,354,149,138,79,80;32;F
96564;82,490,354,1730,70,1255,559,1593;72;M
96566;670,793,1730,695,839,885;53;F
96623;79,354,670,80,406,149,490,1255,762,839,885,728,793,1730,654;34;M
96657;407,502;4;M
96671;79,490,70,762,402,1393,1582,138,824,243,588,80,839,1616,1593;48;F
96678;559,670,70,1335,1326,728;79;M
96679;82,1383,1593,1393,354,1255,654,138,105,80,839,793,79,407,502;38;M
96710;402;45;F
96736;200,1730,695,70,82,1255,762,1335,105,424,1616,885,654,441,728;69;F
96746;407,502;1;F
96771;728;41;F
96794;1255,1326,793,670,200,1730,695,374,407,791,1593,354,445,787,657;37;F
96795;354,407,1255,670,793,1730,200,374,1616,791,1204,1593,885,462,787;31;M
96797;1593,462,787,490,670,657,559,588,1730,200,793,695,70,445,654;34;M
96819;1204,1326,200,1730,1255,406,354,149,70,695,670,502,407,559,138;32;M
96846;502,407;39;M
96879;793,695,762,374,105,354,885,445,787,1582;22;F
96909;762,728,246,1730,82,1204,1593,354,149,1383,1393,406,559,490,138;52;F
96911;670,793,200,82,762,246,1723,824,1616,1204,885,462,787,728,654;50;F
96962;402,657;36;F
96979;1255,762,374,791,1204,354,462,670,1730,695,839,1616,1593,885,654;46;M
97040;406,149,885,1593,70,502,79,424,80,1616,354,1383,1393,1582,138;28;F
97052;1730,695,82,1255,762,407,246,839,1616,1593,354,885,445,1180,138;39;F
97056;149,1593,1204,1616,1730,200,670,793,1326,1255,791,354,1383,787,138;30;M
97064;490,374,1335,588,149,462,1383,854,793,839,1616,138,654,1730,1593;38;F
97065;670,657,654,149,885,1204,1616,839,105,402,82,1730,1593,1383,138;38;F
97088;670,1255,1730,1326,407,79,1723,354,885,1383,1616,1204,1593,1180,839;47;F
97165;793,1616,791,1204,1593,354,462,445,728,670,200,695,1255,762,885;33;F
97176;70,105,839,885;60;M
97235;79,406,490,70,82,1730,247,559,654;33;M
97245;1616,791,762,1730,374,1593,1255,670,793,839,1204,885,1383,1180,728;15;M
97305;762,70,200,793,670,824,406,559;49;M
97306;885,839;17;M
97421;200,1730,1326,150,462,149,105,1616,490,82,138,559,406,246,70;22;M
97443;200,1383,149,885,1204,1326,670,354,138,374,1255,793,695,1730,1593;34;F
97444;1730,82,1255,654,1616;43;F
97503;670,793,200,80,1616,1593,354,1180,138;3;M
97537;762,1393,1730,82,246,406,559,1204,1593,354,149,1383,490,138,728;78;F
97552;670,200,1730,70,762,105,243,490;39;F
97607;200,70,559,1593,1383,138;46;F
97631;80,839,657,670,793,200,1255,407,1616,1593,885,445,441,695,1730;26;F
97757;793,200,762,374,791,1204,354,654,670,1326,1730,695,1255,1593,445;30;M
97812;1204,839,588,374,762,1255,1730,200,793,670,695,80,1616,1593,885;32;F
97815;1383,787,490,462,1730,70,762,502,80,79,406,354,149,654,138;73;F
97818;1255,762,502,374,588,839,1723,885,728,654,1730;30;F
97892;82,402,105,1616,354,885,854,1582,654,441;21;F
97947;200,793,588,839,1723,1383,1393,1582,490,138,657,1730,1335,1616,654;34;F
97970;1616,1204;55;F
98014;1593,787,138,441,885,374,793,670,200,654,839,695,445,247,1255;28;F
98019;793,1326,1730,354,1383,1204,1180,791,787,762;38;M
98065;149,138,657,793,105,839,1616,885,445,654,1326,695,82,762;39;F
98077;70,502,243,839,1723,852,885,728;47;F
98120;852,462,787,854,1383,654,657,670,762,402,1723,1616,559,490,441;43;F
98154;1326,695,762,1255,791,1204,1593,885,670,1730,1616;25;M
98210;1335,424,243,588,824,559,852,854,654,70,247,82,406,490,657;54;M
98217;79,588,839,824,1204,1593,354;28;M
98236;1593,1383;33;M
98258;670,200,695,70,82,402,502,1335,105,588,824,1593,354,787;26;F
98286;70;35;F
98356;670,793,695,1730,1255,374,80,654,885,839;24;F
98383;1593,79,246,407,70,247,82,762,502,839,1616,559,654,490,138;17;F
98417;1616,1730,1593,1383;38;M
98449;138,793,1730,695,82,1255,839,1616,1593,354,885,149,462,445,490;58;M
98487;80,559,654,70,79,728;38;F
98498;1326,502,490,670,762,80,839,406,1616,791,559,149,728,462,787;29;F
98562;670,200,1730,105,839,1593,885,462,445,654,490,441,138,657,728;65;M
98571;402,246,1723,854,654,424,243,138,79,1616,1335,559,445,70,82;47;F
98620;374;33;M
98733;1180,1593,354,79,138,149,1255,80,1723,1383,407,502;38;M
98759;1593,885,1383,728;43;M
98768;670,1593,1383,1180;45;F
98818;80,462,1593,1383,793,105,670,243,839,852,885,1393,1582,654,441;25;F
98990;138,787,441,657,793,200,1730,402,105,839,1593,354,852,885,445;45;F
99075;793,670,1255,402,1335,588,839,885,787,654,657,441,70,406,559;47;F
99204;1616;26;F
99206;490,793,670,1730,1255,695,150,402,374,1616,445,787,654,854,657;61;F
99213;407,502;54;F
99219;791,374,793,1255,695,670,1730,1593,854,70,402,105,243,852,441;27;F
99243;793,200,762,1335,787,728,441,654,885,406,588,839,70,657,559;73;F
99286;1593,1383,728;12;M
99323;502,407,1616,490,82;46;F
99350;1723,1616,1204,354,149,462,670,839,791,1593,885,1383,854,787;39;M
99376;200,1730,1616,793,70,82,406,559,885,490;33;M
99387;1593,1383;46;M
99388;1593,1383;9;F
99423;502,407;44;M
99429;374,1335,462,490,854,445,149,852,1616,588,1730,407,246,354,138;68;F
99468;728;32;F
99495;105,762,793,670,200,695,402,1335,243,588,445,1393,1582,490,441;71;F
99504;654,854,445,1616,824,588,1335,1255,695,1730,200;70;F
99510;243;73;F
99529;791,1593,200,247,787,1582,441,657,695,502,839,1723,1616,885,445;29;F
99543;138,354;34;F
99562;793,200,695,407,502;38;F
99590;247,105,243,1616,559,654;26;F
99661;1730,424,243,654,728,1723,670,1326,402,105,839,1616,559,885,787;23;M
99754;80,105,588,824,70,374,79,246,1616,559,1204,1593,1383,654,441;37;F
99764;70,670,793,200,1730,82,502,80,407,79,839,354,149,490,138;11;M
99773;787,670,200,70,1326;31;F
99776;70,150,1326,670,793,80,1335,105,588,839,824,1616,1593,654,657;32;F
99799;445,149,852,80,1255,793,1326,1730,670,200,762,374,79,791,462;24;F
99802;1335,149,246,670,839,1383,793,695,80,79,1723,354,787,1180,138;23;M
99847;670,1730,1593,354,787,654,441,657,243,1616;57;F
99921;728,762,502,402,200,885,588,247,1616,79,654,1180,1593,1393,1204;39;M
99940;793,1730,402,839,824,791,354,885,654,1616;29;F
99947;695,1730,200,793,670,762,402,374,839,1616,1593,354,885,854,654;31;M
99961;80,502,407,588,70,105,559,149,1730,824,354,852,854,490,138;66;F
99974;246,200,670,1730,70,762,1616,490;43;F
100014;1730,70,839,1593,1383;45;F
100016;1730,559,490,791,787,70,82,502,407;43;F
100054;670,502,80,407;11;M
100062;657,728;29;M
100086;787,138,657,670,200,695,374,839,824,791,1204,1593,354,885,728;35;F
100103;1335,670,852,445,654,441;37;F
100129;502,80,407,354,138;8;M
100212;79,80,462,1180,138;11;F
100232;588,1723,885;84;M
100261;1593,1383;1;F
100317;670,793,839,445,728;34;F
100345;1326,670,793,200,80,1593,354,1180,138;51;M
100399;670,1593,728;44;F
100424;885,1383,105,670,1730,762,374,1616;31;F
100427;654,490,247,200,1730,1255,1616;26;F
100431;79,424,839,854,1393,246,1616,1204,354,149,1383,1582,654,490,138;36;M
100438;1383,1593;42;F
100456;762,79,243,559,354,149,793,1730,70,402,105,246,406,1383,138;44;F
100477;670,200,1730,1255,407,791,1204,1593,149,445,1383,787,490;27;M
100482;588,787,138,885,657,243,1730;44;M
100515;1730,82,762,839,1723,1616,1593,885,149,1383;45;M
100518;695,762,839,1616,1593,885,654,1723,728;32;F
100520;402,654;37;M
100541;670,793,247,1730,695,839,885;22;F
100545;695,1593,490,441,1255,1326,793,839,588,1393,1582,246,1616,854,654;66;F
100580;82,407,839,1616,354,1393,138;27;M
100601;670,793,728,1730,82,374,839,1616,885,654,490;39;F
100634;793,1730,149,138;36;M
100691;791,200,793,670,243,407,402,695,1326,1255,354,885,654,1723,657;34;F
100695;670,793,200,762,407,839,791,354,462,445,490,657;37;M
100721;793,695,1204,1593,354,762,791,885,1730,200,1326,670,787,138,728;44;F
100723;502;34;F
100729;200,1326,793,670,1730,695,70,82,445,839,1593,354,654,1255;41;M
100807;200,1255,762,1335,246,839,354,885,787,728,588,824,854,490,657;25;M
100830;1730,762,1616,791,885,787;28;M
100850;354,149,138;35;M
100862;1730,793,1326,695,70,82,1255,762,839,1616,559,354,885,445,654;36;M
100906;1255,839,793,200,1616,559,354,1593,885,787,654,490,441,138,657;25;F
100929;695,1393,1180,490,462,82,246,149;36;M
100946;200,1255,490,670,793,462,138,1730,82,762,1616,559;38;F
101008;1730,80,246,839,1616,852,1582,490,138;40;F
101030;70,1326,654,787,670,243,1335,200,559,852,490,695,105,839,138;24;F
101052;105,82,670,1616,885,854,654,138;27;M
101070;82,762,70,654,1593,852,1582,138,839,1723,885,1180,728,490,406;49;F
101079;793,1730,695,1255,374,588,839,1616,791,1204,1593,354,885,787,654;20;F
101133;1723,1383,657,588,490,354,445,138,1730,70,1255,502,374,80,407;42;M
101150;1255,374,79,839,354,1593,462,445,1383,654,670,200,1730,1616,695;47;F
101178;243;58;F
101206;793,200,1730,695,502,1616,1593,1383,787,654;29;F
101287;354,885,445,1180,138,1593,824,374,670,1730,82,1616,1383;36;F
101315;885,1180;34;M
101334;695,200,1255,762,105,407,839,1204,885,354,462,445,1383,1180,490;24;M
101399;695,588,1723,654,728;35;M
101456;1593;38;M
101458;402,105,1616,885,490;65;M
101507;670,793,1326,200,695,1255,374,1204,1593,354,1730,728;21;F
101508;200,70,1204,839;31;M
101529;354,70,1335,243,588,406,885,854,490,1730,1616,654;29;F
101562;657,728,791,1730,1255,839,1593,354,885,787,138,762,695,793;26;M
101576;670,793,247,407,79,791,1593,354,490,200,1730,695,82,1616,445;36;F
101656;670,402,79,839,1723,354,885,1383,1393,1582,149,138,728;41;M
101695;1730,839,1616,885,654;43;F
101843;402,839,406,824,854,787,670,200,1730,1723,1616,1593,445,654,441;35;F
101866;793,200,695,402,105,852,654,490,588,824,1616,441,657,82,1730;38;F
101890;1730,695,82,80,407,79,246,839,1616,1593,354,885,149,462,445;22;F
101898;670,374,406,791,559,1204,354,1383,138,1616,695,1730,490;22;F
101969;247,246,1616,654;25;M
101975;670,793,200,1730,79,246,1616,354,885,854,1393,138,839;28;M
101994;79,105,407,82,200,793,670,247,1730,1616,1204,1593,1582,1180,441;34;F
102048;793,1255,839,1204,885,462;39;M
102069;793,839,885,462;70;F
102082;1616,354,490,200,1730,695,1255,246,1204,445,854,657;41;F
102104;1730,70,402,885,406,1616,559;48;M
102146;1593,1255,852,445,654,490,824,1616,1393,1582,1730,695,1335,246,839;23;F
102190;247,670,657,138,654,1383,354,1616,406,80,793,1730,70,559,1593;30;F
102268;1593,1383,793,200,1730,82,80,407,79,824,1616,354,654,490,138;32;F
102286;490,854,354,1593,1616,791,1730,200,670,374,138;27;F
102290;654,793,1730,70,82,502,80,1723,1582,247,839,1616,559,885,490;14;F
102298;654,1383,354,1593,793,82,762,1616,791,885,787,728,374,670,1730;40;F
102318;82,70,150,695,200,247,1326,793,1255,374,1335,1616,1593,1730,1204;24;F
102325;200,462,1593,243,79,105,80,793,1730,695,402,1616,654,490,657;25;F
102353;82,441,247,1730,1335,588,1723,854,654,657,150,79,406,824,852;64;M
102371;670,824,791,354,1730,82,243,1616,1593,149,854,1393,654,441,138;37;M
102409;670,247,839,1204,1593,354,885,445;29;M
102448;670,839,1616,791,885;39;F
102464;839,82,150;44;F
102469;588,445,793,1730,670,1593,354,885,149,138;31;F
102503;200;35;F
102508;490,588,793,1730,82,762,502,407,1616,1593;50;F
102543;793,200,670,407,791,1593,445,654,490,441,657,1616,762,1730,885;32;F
102553;502,1255,695,1326,670,793,200,1730,762,839,885,787,1582,654,138;51;F
102568;462,445,1383,654,728,374,791,138,670,200,1730,762,1593,885,787;40;F
102575;670,1730,695,82,1593,654,490;21;F
102591;247,200,762,80,1723,1616,885,445;26;F
102619;1593,1383;70;F
102620;654,502,839,885,149,402,1593,354,854,657,793,1730,695,588,1616;24;F
102635;1335,1616,854;32;F
102638;787,354,1593,1204,791,1616,1255,695,1730,200,670,793;43;F
102657;354;21;F
102677;1730,1255,407,105,588,824,1616,1204,1593,354,149,1383,654,490,138;62;M
102685;402,762,1255,1326,670,728,657,885,559,1616,1723,839,588,1730,247;24;F
102712;793,1730,695,1255,762,374,1616,1204,1593,354,654,441;36;F
102716;247,1326,793,1723,791,1593,490,762,728;29;F
102789;657,695,793,670,82,762,502,407,839,791,885,787,1582,490,728;27;M
102802;793,406,728,1730,70,762,839,885,654;28;F
102824;1204,791,79,149,462,1383,490,1255,1180,138,200,1730,502,80,354;36;M
102834;1593,1383;42;F
102861;1180,787,854,462,354,559,791,246,79,80,502,695,1730,247,670;30;F
102885;1326,695,839,1616,1593,885,728;32;F
102900;502,1255,200,247,1326,793,670,1730,695,82,762,80,1616,1593,490;22;F
102933;670,1616,1383,1593;43;M
102936;82;32;M
102944;1326,1255,79,246,1723,824,1616,791,354,885,657;34;M
102960;1730,1593,1383;42;M
103015;1335;43;M
103036;445;47;F
103050;787,354,1204,791,1616,588,793,670,200,1730,374,839,1593,885,138;29;F
103087;247,243,1593,354,490,138,82,1616,852,149,445,654;30;F
103109;1180,138,374,670,793,247,200,1730;22;F
103194;82,502,407;40;F
103234;885,445,1593,1204,80,79,1255,695,1326,793,670,354,462,787,138;21;M
103239;1593,1616,374,670,793,247,1730,1255,502,407,839,354,149,462,138;82;F
103240;695,1255,762,402,1616,885,654,490;35;M
103266;793,762,402,79,839,1723,1204,1593,354,885,445,854,787,1582,654;26;M
103312;1593,1383;40;F
103360;82,502,407;10;M
103372;670,791,885,654,374,82;42;M
103386;559,1204,149,462,1582,654,374,670,200,839,1593,354,1383,1180,138;38;F
103387;1593,354,445,1383,1393,787,654,1180,793,1730,82,1255,762,1616,1204;33;F
103466;1255,1593,654;37;F
103486;1326,670,1730,402,1335,105,424,588,1723,852,854,654,441,1616,824;46;F
103568;445;40;F
103584;695,374,79,839,885,149,1383,1180,728,70,762,1723,406,1616,138;59;M
103611;670,793,1730,695,374,105,791,1593,885,1393,657;27;F
103620;695,1730,839,654;57;F
103653;462,490,79,670,1326,695,149,728,354,588,793,200,1730,762,138;34;M
103657;670,793,200,1730;44;M
103674;654,490,670,793,200,406,791,1326,762,1616,854,728;26;F
103708;1593,1383;45;M
103738;445;30;M
103800;1255,407,791,445,670,793,200,1730,695,70,374,406,1204,1593,462;69;M
103842;559,670,793,200,1730,695,70,80,79,406,1593,354,149,1383,138;52;F
103876;1335,1326,657,138,791,354,80,374,1255,695,1730,200,670,787,1593;32;F
103878;793,502,247,1616,200,695,1255,885,1393;47;M
103886;445;67;F
103939;200,374,105,588,839,824,791,354,885,654,490,670,793,1730,1616;34;F
103945;1204,670,354,728,762,885,793,374,138,1593;34;M
104005;79,1730,407,490,462,502,80,839,354,1393,138;48;M
104040;445;24;M
104043;1593,1383;41;F
104053;150,82,1383,728;44;F
104096;354,793,670,1326,200,1730,695,70,1255,374,246,839,885,138,728;39;F
104107;79,80,502,200,1326,839;54;F
104124;588,695,793;29;F
104127;1326,502,1723,406,559,149,1383,728,670,762,839,1593,885,1180,138;26;F
104132;670,1255,885;34;M
104151;406;34;F
104157;791,374,1326,138,670,793;38;F
104158;1180,200,1326,670,1730,695,1255,407,246,839,1616,885,462,654,657;37;M
104167;1383,1593,1616,839,374,695,200,1326,793,657,1204,762,670,1730,791;26;F
104184;79,445,695;38;M
104194;657,1335,1730,200,247,82,762,588,824,1616,852,885,462,854,654;23;F
104207;1593,1383,728;15;M
104300;402,200,1730,70,82,502,80,407,79,1616,559,354,787,490,138;40;F
104317;1616,791,1326;55;F
104345;670,885;26;M
104367;138,787,1593,1616,793,200,247,839,490,1582,445,762,1730,670,885;25;M
104430;1723,559,149,854,138,787,654,1383,885,1616,824,588,407,402,247;56;M
104463;406,1383,654;36;M
104519;654,670,374,80,1616,354,149,462,854,138;43;M
104560;670,793,695,374,854,1582,654,657,354,1593,1616,1730;29;F
104597;670,762,839,354,149,1383,885,138;23;M
104676;247,200,695,791,885,787;22;M
104748;670,406,885,138;37;M
104754;839,670,200,762,1616,1593,885,854,138;45;F
104776;70,1593,445,854,657,1730,402,406,462,82,839,1616,885,654,490;45;M
104806;728,670,1730,150,1255,762,374,80,424,243,462,787,1180,138;41;F
104815;150,1593,1383;45;M
104826;1593,1383;43;F
104854;793,1730,839,354,490,406,1335,105,1616,1393,1582,445,82,80,407;44;F
104871;793,670,728,490,654,854,445,852,588,1730,695,82,246,824,1616;32;F
104879;70;65;F
104941;1593,1383;44;M
104968;374,502,670,1255,407,824,1616,695,1730,200,247,793,654;19;F
104974;70;68;M
104976;79,791,354,445,787,654,670,793,200,1730,374,80,1204,1593,138;34;F
105056;200,105,839,1616,354,885,1383,138;27;F
105062;1593,354,462,1383,200,793,247,1730,695,105,839,1616,885,787,657;32;F
105066;1593,1383;47;F
105125;490,654,462,885,1593,824,246,374,82,200,793,670,1730,839,1616;28;F
105145;791,787,1180,138,200,1730,150,70,82,246,406,559,149,462;48;M
105159;793,200,70,1616,670,839,82,1255,695,354;40;M
105161;374,670,793,200,588,445,1730,695,1255,839,1593,1204,354,885,138;27;F
105228;374,885,793,670,1326,200,1730,695,1255,588,839,1204,1593,354,138;48;F
105245;670,1326,82,80,1616,791,787,654,490;30;F
105290;407,1723,791,839,243,246,1255,82,1730,247,1616,1593,885,654;23;F
105304;1730,793,670,1326,200,695,1335,246,588,1616,791,1593,787,654,728;57;F
105306;824,246,374,1730,1616,791,559,852,854,1593,793,654,445,695;38;F
105313;670,793,247,200,1730,695,79,1616,559,1593,445,728;19;F
105356;588,1723,791,1204,793,1730,695,80,1616,1593,354,885,445,787,654;35;M
105364;1593,1383;45;F
105366;243,824,559,1204,1593,787,670,354,791,1730,200,793,406,70,695;43;F
105395;200,402,588,441,445,406,1335,150,138,852,354,791,105,70,559;65;F
105403;462,354,839,793,1180,885,1730;36;M
105429;1593,1204,791,1730,793,670,1326,200,695,374,1335,839,1616,885,445;37;F
105525;657,670,200,247,374,407,105,246,824,1616,354,1593,885,1383;23;F
105536;1204,1593,1383,787,1582;40;F
105565;654,657,200,695,138,670,793,1730,1255,374,839,1204,1593,354,885;37;F
105578;441,1582,1393,852,1616,105,80,402,762,1730,839,354,149,1383,138;35;F
105596;200,1730,105,1393,1582,654,79,246,588,839,824,1616,502,354,138;38;F
105602;657,1730,695,762,105,588,839,1616,728,654;24;F
105607;787,728,670,1326,762,374,1335,791;96;F
105615;82,247,200,246,424,824;29;F
105624;1383,854,490,793,1326,1730,695,402,374,80,1616,1204,1593,445,654;24;F
105679;243,105,407,402,82,70,247,200,670,793,1730,695,1616,1593,654;31;F
105682;200,1730,82,588,1616,559,885,1383,787,654;37;F
105684;762,247,670,1593,1616,502,695,1730;23;M
105708;1326;57;M
105718;138,441,1383,791,824,839,762,885;30;M
105720;670,695,70,1616,559,885,445,1383,138;47;M
105741;1335,407,824,1616,791,354,852,885,462,445,854,787,1582,490,138;50;F
105779;445,588,854,670,1326,200,1730,246,824,1616,791,885,787,654,728;61;M
105794;670,793,695,243,839,1616,1593,885,728,657;27;F
105801;79,374,793,670,200,1730,82,80,1616,354,149,1383,654,490,138;34;F
105813;1723,105,1616,824,82,1730,793,1383,1393,654,490,138;33;M
105835;787,654,657,839,588,246,79,407,1335,374,793,695,1255,1616,728;39;F
105864;654,1180,138,670,793,200,1730,695,1255,374,839,1204,1593,354,885;38;M
105902;1593,1204,588,374,1255,695,247,200,762,1730;20;M
105929;1180;37;F
105948;793,762,839,354,138,441,1335,200;70;F
105961;670,1326,885,787,728;63;F
106000;588,824,1616,791,1204,1593,354,885,1383,854,787,1582,654,441,657;25;F
106011;407,149,406,200,80,354,138,1326,1730,502,70,82,1616,559,490;41;M
106013;200,670,1730,1255,82,374,79,1616,791,1204,1593,354,885,462,1383;38;M
106016;1335,670,793,1730,246,824,1616,559,1593,852,854,654,1255,445,695;49;F
106067;670,695,762,80,1616,1593,885;28;F
106101;1593,441,793,200,354,402,70,1730,406,149,1383,1393,1180,654,138;65;F
106147;138,787,246,105,247,1593,1383;23;M
106196;374,1255,695,200,670,793,1730,839,1616,1204,885,149,1383,1393,441;30;M
106202;441,793,200,1730,695,762,502,406,1180,462,445,70,839,559,1593;49;F
106263;80,79,839,1593,441;36;M
106331;402,82,1730,1383,1393,490,138,657,728,793,762,105,839,1616,654;31;M
106341;247;22;M
106348;654,670,1326,247,1255,762,80,839,1593,885,787,1582,1180,695,138;31;F
106371;762,885,1326;47;F
106408;1180,787,149,462,1593,839,1255,200,1326,670,490,793,695,445,138;28;M
106411;670,374,80,79,1616,1383,138;37;F
106418;82,243,1593,885,1383,1393,1582;40;M
106456;354,1204,791,374,1593,1383;20;M
106459;670,793,1326,200,1730,762,588,1723,791,1593,885,854,787,728;46;F
106526;1593,1383;13;F
106563;1326,670,82,200,1730,588,1616,1204,354,149,1383,654,1180,138;50;F
106656;670,200,1730,502,79;57;F
106771;670,1730,402,105,243,1616,854,247,1255,588,654,728;30;F
106823;1593,1383;35;F
106831;885,787,762,374;34;F
106860;1730,80,105,246,424,1616,852,462,654,490;29;F
106876;406,1616,1593,1383,1393,654,138;29;M
106879;670,793,200,695,82,1255,762,374,839,1616,791,1204,1593,354,885;34;M
106960;402,105,654,670,695,762,246,1616,791,1593,354,445,854,787,138;70;F
106971;1616,490,657,200,374,559,354,1255,70,695,1326,670,793,1730,138;53;F
106999;138;69;M
107004;793,695;42;M
107025;1593,1383;48;F
107044;791,374,354,149,728,1255,762,793,670,787,654,70,200,1730,695;46;F
107107;1255,374,885,1730,82,1616,654;32;F
107115;138,82,670,791,200,1730,695,824,1616,354,885,445,854,654,490;37;F
107132;839,791,1204,149,1383,787,445,354,82,1730,793,200,502,407,1593;14;F
107142;695,70,138,462,354,1616,105,80,374,402,1255,1730,200,793,670;69;F
107162;793,200,1730,695,82,402,824,1616,445;32;F
107166;654;30;F
107169;695,1730,1326,793,670,82,80,79,1616,1593,354,885,445,490,657;30;F
107191;885,1204,82,247,793,670,1730,150,407,105,839,354,445,654,138;30;F
107240;1616;25;M
107279;406,1730,70,374;63;F
107286;80,1255,70,407,246,243,839,824,1616,559,354,852,885,441,138;46;F
107300;1383,787,654,200,670,793,762,1616,354,149,728,1730,82,490,138;40;F
107322;200,1616,791,559,839,793,670,374,70;39;M
107370;402,1383,445,1204,670,793,695,150,762,374,407,105,1616,1593,654;27;M
107401;502,407;42;M
107440;839;23;F
107490;1730,762,80,105,852,462;31;F
107503;670,200,695,80,79,1593,354,445,787,1582;46;F
107509;138,839,79,70,80;45;F
107519;200,1730,762,1335,588,839,1616,354,852,149,462,854,787,654,490;74;M
107590;1255;21;M
107604;670,1326,839,1180,1616,1204,1593,885,1383,1393,654,138;51;F
107616;1326,445,787,1730,695,150,70,82,1255,1616,854,441;67;F
107618;200,105,839,1616,559,1593,885;34;F
107620;200,793,1730,402,105,588,1593,885,138,728;50;F
107649;82,1616,791,1204,1593,354,885,654,138,70,406,762,105,559,1383;47;M
107683;82,762,670,138,1326,793,1730,695,70,246,588,1723,1616,1593,441;32;F
107711;791,1730,793,138,1326,762,1593,839,1204,885,1383,1393,1180;50;M
107742;1593,1383;42;M
107917;354,1204,791,374,762,1255,670,839,885,462,445,654;29;M
107968;670,200,80,79,441,839,243,852,1616,559,70,1730,1723,1393,1582;47;F
107997;670,1730,70,82,402,1616,559,462,787,1582,654;50;M
108016;150;46;F
108023;1180,247,200,1730,762,80,839,791,654,138,441,462,885,354,559;16;M
108071;1730,70,82,406,1616,559;36;M
108132;1730,70,82,762,374,588,839,406,791,559,885,462,787,490,728;35;M
108150;1730,695,374,407,839,406,1204,1593,1383,654,70,1616,354,149,138;37;F
108159;1255,354;24;M
108180;728,654,787,1204,588,407,1730,670,793,839,1616,791,1593,445,885;22;F
108213;1593,1383,374;41;M
108255;1393,1582,490,149,200,1204,1593,441,1383,654,1180,138,1730,354,1616;51;F
108288;793,695,82,1204,149,490,670,1730,406,1616,354,657,70,885,654;39;F
108292;787,1255,762,105,791,657,728,200,1730,70,374,406,1616,559,654;54;F
108328;502,793,200,1730,695,374,80,79,839,1616,1204,1593,354,1383,138;37;F
108359;354,1255,445,670,793,200,695,762,839,885,462;41;M
108368;762,1723,559,1593,885,462,728,490;21;F
108371;1730,793,670,885,445,1383,787,1180,138,200,1255,105,1593,354,462;43;M
108389;490,670,243,1616,1593,1730,695,502,407,105,246,354,149,854,138;62;F
108469;824,1204,787,728,670,200,695,762,79,354,885,854,138,839,247;25;F
108504;150;49;M
108511;670,200,1730,70,762,406,1616,559,654;61;F
108514;462,854,1393,728,852,885,654,138,502;47;M
108563;374,406,1616,1383;43;F
108608;79,70,695,1730,200,1326,150,82,502,80,407,1616,354,149,138;49;F
108615;654,657,1326,247,138,793,1730,402,1335,243,824,1616,852,854,441;70;F
108623;793,105,149,1383,787,490,138,1730,762,1723,1616,354,1593,885,654;32;F
108626;1616,424,695,728;53;F
108628;149,654,490,138,200,695,839,1723,1616,462,670,793,82,885,787;42;F
108661;502,407;43;F
108672;1730,1255,105,1616,1593,462,657,1326;62;M
108725;150,70;46;F
108741;150;16;M
108745;1204,1593,1616,791,839,670,793,1730,200,695,1255;72;M
108755;200,695,82,1255,1616,462,654,1730,854;63;F
108771;728,787,445,246,105,200,762,502,839,1616,559,885,854,1393,1582;40;F
108778;138,885,854,654,793,670,402,246,839,1616,1593,852;27;F
108845;1180;23;F
108917;695,70;37;F
108920;406,80,502,1730,246,243,824,1593,354,854,654,138;47;F
108926;1335,246,243,588,839,824,1616,559,852,885,445,854,787,654,490;37;F
108927;150;13;F
108937;82,854,839,588,243,105,402,695,247,762,824,1616,354,852,654;26;F
108940;695,1255,839;29;M
108953;1593,1383;23;M
108954;1730,695,1255,374,791,1204,1593,354,787;25;M
109044;1204,793,791,670,200,762,839,885,657;32;M
109050;82,502,407,559,490;11;M
109056;138;34;F
109065;695,79,1616,1593,885,854,787;42;F
109068;1335,441,762,728,654,490,70,82,105,588,839,1723,406,559,885;59;F
109070;1593,354,445,654,728,1204,588,1255,695,670,793,762,854,1393,1582;20;M
109100;762,695,1730,200,1326,670,793,1255,1335,839,791,354,885,149,138;74;F
109176;247,200,82,246,824,1616,354,1383,854,654;28;F
109207;80,70,839,138;40;M
109220;490;37;M
109257;82,502,407,559,490;8;M
109299;243,852,885,1393,441,1730,246,79,670,82,70,1723,1582,1616,559;12;F
109307;1593,559,1616,1730,839,885;65;M
109338;502,695,1730,200,80,839,885,728;29;F
109446;728,200,1730,70,762,402,243,1616,559,852,149,1393,1582,138,406;56;F
109466;1593,559,407,406,1616,885,445,839,588,70,695,200,1730,1204,1180;43;F
109468;670,793,1730,200,82,243,839,1616,885,654,490;32;F
109469;657,654,787,1383,462,588,374,70,670,793,1730,559;26;M
109479;80,588,490,502,82,70,695,105,79,243,839,1616,852,441,445;29;F
109557;1593,1383;21;M
109559;70,80,839,138;9;M
109599;150;46;F
109611;762,670,793,200,70,80,105,79,424,839,1593,885,1383,728,1616;33;F
109670;1383,1593;47;M
109673;105,839,824,885,462,854,138,1730,70,762,588,791,787,654,728;48;F
109687;247,200,695,354,1593,1255,839;26;M
109695;138;33;F
109718;839,445,1383,787,138,1730,502,246,1616;31;F
109729;70,150,793,1730,695,82,1335,246,588,824,1616,854,654,490,441;33;F
109746;854,1335,1616,793,200,695;29;F
109751;200,1255,885,105,246,852,1730,839,1723,1616,559,1582,654,441,657;53;F
109764;1593,1383;51;F
109802;407,791,1593,149,445,787,654,441,670,793,1730,695,839,1616,885;30;F
109825;149,138,82,79,839,406,1616,885,1593,1383;43;M
109834;854,654,824,839,588,1335,695,1730,200,793,670,1616,791,1593,1204;21;F
109893;441,839,1582,654,138,657,1730,1723,1616,559;15;F
109894;793,247,839,1616,1593,885;22;M
109900;1326,247,1255,407,1616,1593,354,445,1582;20;F
109924;670,1326,200,1730,762,1723,791,1593,885,149,1383,787,728;39;M
109928;502,1326,70,82,80,105,79,839,1616,559,1593,149,1383,654,657;30;F
109938;1180,1593,1204,1616,374,1730,70,82,588,406,354,149,654,138;71;F
109953;1255,70,1730,200,793,670,839,885,149,654,490,441,728,1335,82;41;F
109961;374,762,1255,70,793,670,200,1730,246,354,462,445,854,1393,654;59;F
109976;82,762,1335,354,654,502,246,1180,490,79,80,839,406,149,138;32;F
109977;407,1335,1326,793,1730,695,82,402,374,105,1616,1593,445,490,441;21;F
110012;1326,70,82,1383,1335,200,1593,80,79,246,149,654,490,1180,138;59;F
110015;1730,1335,243;63;F
110054;1255,374,243,588,1204,852,654,793,839,885,490,82,1616,1393,1582;37;F
110109;695,79,424,243,588,839,654,670,793,247,1730,200,246,1616,354;27;F
110174;149,138;26;F
110175;70,80,138;6;F
110188;1204,695,762,402,1335,839,406,885,149,670,1730,1616,354,854,138;33;F
110195;793,670,695,1255,762,1593,854,1393,1582;19;M
110239;670,762,79,588,559,354,885,149,1383,787,138,1616,839,374,728;54;F
110292;791,1723,670,787,138,1326,200,588,852,441;38;F
110304;670,695,490,762,1255;37;M
110312;490,138,728,670,793,200,1730,82,762,839,354,1383,1723,1593,885;40;F
110363;670,200,1730,70,762,588,1723,1616,791,559,885,462,787,490,728;29;F
110415;1723,149,1383,79,1593,1393,1180,1204,445,502,354,82,695,1255,839;10;M
110418;138,1326,70,200,502,1593,462,787,728,670,1204,354,852,1383,1180;48;F
110473;70,80,138;2;F
110474;793,200,839,354,885,149,138;27;M
110556;787,1582,1180,138,670,200,762,80,1204,1593,354,1383;30;M
110574;885,70,374,1393,762,200,82,150,1730,79,246,1723,559,1582,728;9;M
110587;150;46;M
110596;149,105,200,654,695,670,1326,70,1255,374,559,1204,462,787,138;41;M
110625;1730,200,670,793,82,762,424,839,1204,1593,354,885,787,490,138;25;M
110656;374,149,728,670,762,246,839,1616,1593,885,787,1582,654,490,138;51;F
110666;138,1730,150,82,502,407;46;F
110675;70,80,839,138;12;F
110698;793,670,1326,1730,82,1255,1335,1616,1204,1593,445,1383,854,490,138;32;M
110700;695,424,445,654;35;M
110739;1730,246,839,1204,885;37;F
110741;502,407;44;F
110841;79,839,502,407,1616;40;F
110850;445,728,1255,588,657,1730,200,695,82,762,79,839,1616;51;F
110896;70,82,80,79,445;13;M
110898;1326,502,243,1616,1204,354,462,654,1730,852,149,1180,138;31;M
110909;588,200,793,670,695,1255,762,374,354,885,462,854,728;36;M
110934;200,1255,1335,839,1723,824,1616,1593,354,854,490,82,1730,247,654;30;F
111036;80,70,138;14;M
111071;670,793,200,839,1616;22;M
111089;839,791,1204,1593,885,1383,1180,138,657,670,793,695,1255,1616,354;33;M
111125;247,200,1730,695,1255,374,105,246,243,839,406,824,1616,1204,1593;50;F
111134;402,1335,588,839,824,559,462,654,82,1616,854;28;F
111141;149,728,657,793,762,1593,1326,1730,695,354,138,82,490,885,839;18;M
111148;670,1326,200,1730,695,374,407,354,1593,791,1204,445,787,1180,657;29;M
111158;374,1730,150,70,82,402,839,406,1616,559,354,885,149,654,138;60;M
111161;793,1335,407,1593,445,490,138,657,406,588,70,1730,82,1616;26;F
111162;354,787,654,1326,1730,762,502,1616,1204,1593,885,1180,138,1383,839;44;M
111181;728,138,462,354,839,1204,1593,885,149,787,793,670,1255,762,490;19;M
111204;1335,588,559,654,1730,70,502,406,490;37;F
111263;70,80,839,138;17;M
111297;79,80,502,407;9;F
111298;402,559,728,588,824,1616;27;M
111300;200,1730,695,82,70,1255,105,839,406,1616,885,445,490,441;66;F
111306;1593,1383;8;F
111328;490,1383,885,354,1204,588,1730,82,1723,824,1616,654;38;M
111369;150,82,502,407,1616;14;F
111376;1255,559,885,1393,1582;53;M
111438;247,1255,402,424,852,490,1730,762,1335,839,824,1616,445,854;36;F
111443;1326,1730,839,1723,1593,885,787;23;M
111446;246,1593,1383;52;M
111447;445,490,138,670,793,200,695,1255,791,1204,1593,354,885,1383,787;22;M
111467;854,654,490,105,243,839,824,852,441,695,82,588,1616,559,445;47;F
111487;445,79,559,1204,1593,728,354,374,1255,70,793,200,670,1730,695;44;F
111529;1616,1326,793,82,374,1335,105,79,839,824,354,149,854,490,138;43;M
111555;654,670,200,1730,695,70,402,246,406,559,354,149,1383,1180,138;69;F
111587;70,82,1335,246,588,1616;26;M
111717;354,1582,824,243,79,246,1616,490,138,247,80,654,441,502,407;39;F
111718;354,406,149,441,728,490,654,1393,1383,80,82,70,1730,1616,1593;46;F
111720;1582;26;M
111729;105,406,824,1730,82,424,839,559,462,445,490;32;F
111778;1730,138;35;F
111781;200,1730;37;F
111793;502,407;16;M
111850;1723,1616,852,445,854,654,441,670,247,200,762,79,839,885,1393;31;M
111856;1593,1383;25;M
111890;791,407,1255,1730,200,1326,793,670,138,149,354,839,1204,1593,1383;20;M
111926;670,1730,654;28;F
111930;787,1593,1204,791,374,793,670,200,354,1730,839,885;48;M
111936;791,695,1326,138,670,1255,793,1730,374,1204,1593,354,1393,1582,1180;40;F
111943;1593,1383;19;M
111946;791,1204,1593,354,1383,670,200,793,1730,695,82,1616,885,445,654;33;F
111951;1593,1383;3;F
111956;406,728,793,670,1326,200,1730,80,79,1616,149,462,657,490,138;35;F
111998;1616,1593,1383;38;F
112016;1730,200,695,70,105,243,406,1616,559,445,1393,490,1582;54;F
112063;200,1730,695,1255,839,1593,445,1180,657;39;M
112072;246,839,1204,885,1582,1180,490,445,354,1593,1616,424,82,695,670;33;F
112091;462,149,854,787,670,793,200,502,138,839,79,70,247,1730,354;25;F
112102;243,1616,791,1593,354,1383,138;36;F
112108;1326,80,1616,502,407;46;M
112118;1593,1204,791,762,200,670,793,1730,695,1255,374,839,354,787,490;24;F
112120;243,1593,138,1383,588,1730,502,80,79,246,885,1393,441;43;F
112132;1326,200,1255,79,839,1593,354,1383,657,1730;54;M
112166;1616,839,407,374,200,1326,793,1730,1255,695,354,885,1383,138,654;29;M
112188;82,70,1335,243,588,149,200,1255,402,80,79,1204,462,445,854;58;F
112291;354;28;M
112314;1204,200,1730,695,70,402,246,406,559,354,149,1383,654,1180,138;78;F
112316;502,407;6;M
112327;1180,1593,1383,138;39;F
112348;791,149,787,885,839,105,70,670,793,1730,762,374,654,490,728;41;F
112388;1723,787,1730,695,762,424,406,559,1593,654,490,728,670,70,462;26;F
112408;1204,1593,1393,728,1326,1730,695,70,762,824,791,854,787,654,138;31;M
112409;1335,79,588,839,1723,1616,149,441,82,80,354,654,490,138,445;40;F
112444;200,1730,695,1255,839,1593,445,1180,657;40;F
112484;200,1730,695,70,105,243,406,1616,559,445,1393;58;F
112494;1616,793,670,1255;28;F
112500;150,105,80,502,247,839,1616;15;F
112510;70,762,406,824,791,559,1204,354,885,854,787,654,490,138,728;46;M
112546;402;38;M
112555;1616;49;M
112583;402;35;F
112591;670,1335,1255,1723,654,490,854,1593,791,793,1616;34;F
112592;374,1204,791,670,793,1730,839;22;M
112614;354;33;M
112647;852,1593,462,787,654,670,839,138,1383,149,885;33;M
112651;247,200,402,80,105,852,695,82,1616,445,1582;41;F
112693;695,1335,1383,1326,82,1616,1204,1393,1180,441,1730,374,839,1593,885;39;F
112719;402,80,407,1204,885,654,1730,839,1593,354;70;F
112777;354,200,445,1393,1582;32;M
112791;79,839,1616,354,885,1393,654,502,407;49;M
112803;406,1383,1180,138;51;F
112804;200,1730,695,1255,839,1593,445,1180,657;10;F
112808;1593,1383;43;F
112810;82,1730,1255,502,246,243,406,559,1383,1393,407,839,1204,885,1180;54;F
112815;1730,695,1255,1616,885,654;32;F
112821;354,1723,1616;24;F
112828;793,374,1383,657,1616,1335,1255,1730,200,1326,247,246,354,885,138;26;F
112868;424,839,1723,406,852,445,1383,1393,787,1582,490,441,728,1616,885;31;F
112873;670,793,200,695,1255,839,1593,1383,787,138;27;M
112886;246,793,1730,695,839,1616,885;46;F
112899;1730,374,1593,354,490,247,695,105,424,839,1723,1616,885,445,654;33;F
112919;490,657,793,695,1255,374,80,79,839,1616,354,1383,654;33;M
112934;728,138,654,787,149,354,407,200,670,793,695,839,1593,885,445;29;F
112957;854,1383,885,354,1593,1204,791,1616,824,839,1326,793,670,1255,402;35;F
112980;588,839,490,654,854,445,1593,1616,824,80,793,200,1730,695,1335;29;F
113005;1730,695,80,79;35;F
113019;200,1730,70,105,243,406,1616,559,1393,1582,490;72;F
113027;1730,695,374,839,824,1616,1204,1593,354,885,854,787,138,657,728;56;F
113044;852,1180,787,793,424,670,200,762,374,80,839,1723,791,354,728;25;F
113065;200,1730,695,1255,839,1204,1593,445,1180,657;7;F
113079;793,247,762,885,787,1582,654,441;25;F
113155;1593,1383,138;45;M
113166;762,1204,354,793,1255,1616,791,149,462,490,728,670,200,82,374;35;F
113203;1326,402,80,1335,407,246,824,1616,852,149,462,854,1730,200,82;16;F
113219;839,824,852,854,670,793,885,441,1730,82,1616,1593,354,654,138;32;F
113283;502,407;45;F
113319;670,200,1730,824,1616,354,1383,854,654,138;31;F
113332;82,105,1616,885,445;26;F
113354;105,670,793,1730,70,559,1593,354,787;70;F
113370;105,243,839,406,852,885,402,82,70,1616,559;55;F
113379;406,70,1730,1326,670,200,82,80,1616,149,654,839,407,79,354;29;M
113431;247,695,1255,402,839,1616,354,787,657;33;F
113434;243,200,762,445,82,839,1393,1180,354,885,462,1582,490,138,1730;42;M
113482;1593,1383,138;76;F
113520;1204,490,354,462,138,374,1326,1180,1255,200,670,793,1730,695,1593;28;M
113558;374,695,200,1326,762,1335,1616,354,1383,1393,1582,138,670,1730,1593;34;F
113580;670,200,762,1616,885;46;M
113593;1730,70,82,762,406;37;F
113597;1730,502,1335,588,1616;42;M
113634;354,885,728,1593,1730,1255,762,1204,138,490,445,839,1326,82,462;15;M
113709;1593,1383,138;71;M
113746;1326,150,695,80,79,1723,654,490,138,728,82,1616,149,462,445;41;M
113761;728;21;M
113829;138,787,695,1326,670,200,1255,728,762,374,1593,354,462,654,657;31;F
113845;1730,82,80,1723,1616,559,885,1393,654;48;M
113853;839,1593,1383;40;M
113872;1204,1593,1383,138;10;F
113895;79,246,407,502;11;F
113899;1730,839,1593,885,441;49;F
113903;1730,82,1255,502,407,246,243,839,406,559,1204,885,1383,1393,1180;56;M
113914;70,82,1730,1326,793,670,200,762,839,1616,559,1593,354,885,787;41;F
113935;1180,138,1204,1593,441,1383;40;M
113938;1335,243,588,406,559,445,854,654,105;63;F
113945;670,793,200,70,105,839,1204,885,787;47;F
113962;670,793,839,138;20;M
113971;246,105,1335,1326,670,200,1730,70,824,1204,1593,149,1383,490,138;73;F
113994;787,149,354,728,791,839,762,502,246,200,1730,885,406,70,559;30;M
114006;1326,695,762,1723,1204,1593,354,1255,1730,200,793,670,839,885;41;M
114021;1383;47;F
114091;70,82,1616,559,354,654,490;30;F
114122;787,462,791,1723,374,670,1326,839,885;15;M
114131;1204,1593,1383,138;6;M
114144;82,839,1616,791,728;38;F
114165;79,1616,149,1393,138,657,670,793,1730,762,839,1593,354,885,654;32;M
114171;82,657,728,138,490,854,445,1593,243,80,695,654,839,1616,79;39;M
114185;791,824,1616,79,80,402,502,762,82,70,1730,200,247,1326,670;21;F
114197;80,200,1616,791,1730,1593,149,670,793,839,354,885,445,82,695;38;M
114207;839,1723,852,885,1393,1582,654,695,247,502,407,246,424,1616,441;54;F
114240;243,1730,791,462,654,728,762,402,839,70,695,670,1326,793,1616;29;F
114253;793,1255,82,1326,1730,502,1204,462,490;40;F
114254;1326,82,374,138,695,1616,654,793,1730,839,354,885;37;F
114266;695,80,502;45;M
114269;670,200,354,149,1616,1593,138;35;F
114272;462;19;M
114280;138,787,791,374,200,247,670,1730,762,839,1593,885,1582,490,728;56;M
114285;200,1616,654,1582,728,490,1383,885,1593,670,1730,762,374,839,1723;29;F
114323;150,70,82,246,559,885,654,670,793,200,1730,1723,1593,787,490;60;M
114334;445,728;51;F
114337;1616,1593,854,441,728;29;F
114371;670,787,354,1593,885,1616,695,1393,1582;19;M
114372;490,1383,1593;56;M
114379;82,1730,1255,502,246,243,1393,1383,406,559,407,839,1204,885,1180;83;F
114403;1616,1593,885,1582,138;33;F
114410;1730,82,1255,502,407,246,243,839,406,559,1204,1593,885,1383,1180;86;M
114418;791,670,793,200,70,374,105,839,354,885,787;49;M
114437;82,374,246,79,839,791,1180,490,670,1730,824,1204,1593,854,1383;25;M
114463;1593,354,588,852,462,445,1393,854,654,138,402,1335,243,824,1616;37;F
114472;82,1616,1730,839,885,654,490;32;M
114506;149,502,1255,246,1593,728,1616,1730,695,762,1335,588,854,654,657;30;F
114510;839,588,670,1730,1180,793,374,1723,1616,1204,1593,885,1383,854,138;25;M
114528;374,839,885;77;M
114534;1593,354,787,654;24;F
114549;787,1255,247,670,657,149,885,852,1383,854,793,1616,839,1730,138;25;F
114564;1255,374,559,885,1393,654,502,407;50;M
114600;657,150,852,1582,588,243,791,1593,354,1383,138,82,407,1616,445;38;M
114607;200,1255,105,246,445,695;33;M
114615;200,657,445,149,793,247,1255,462,588,1730,762,839,1616,885,654;39;M
114633;1730,82,670,1326,200,70,138;71;F
114634;200,374,1335,354,462,654,138,1180,1393,1383,885,1204,1616,406,1730;51;M
114637;657,588,1730,1616,1593,1383,1204,1180,839,243,200,105;12;F
114688;1730,82,762,374,243,588,839,406,1616,852,885,1393,787,1582,490;66;F
114731;1593,1383;41;M
114774;1326,728;27;F
114853;82,246,791,1593,1383;42;F
114876;82,502,407,885;42;M
114918;1593,1616,728,105,670,762,791,885,787;52;M
114926;374,1326,670,793,200,1730,695,762,839,1204,1593,354,885;32;M
114936;1593,1383;56;F
114949;654,149,1730,502,80,407,79,445;9;F
114986;354,1383,441,657,885,1593,1616,406,374,1255,695,1730,200,793,670;44;F
115031;1255,670,793,200,1593,490,1730,695,70,374,839,1616,354,885,854;25;F
115058;138,80,79;35;F
115081;670,793,200,1730,695,70,1255,402,374,80,105,1616,354,462,138;71;M
115084;82,839,1723,1616,885,490;47;M
115095;793,1723,1616,559;31;F
115163;654,1393,885,354,1204,791,839,588,243,79,762,1255,695,200,670;27;F
115173;1730,1255,80,79,424,1616,559,354;32;F
115192;243,79,105,1335,502,70,150,695,200,247,670,839,854,1616,445;48;F
115222;70,728,490,354,762,200,787,1383,1593,791,79,1730,670,374,138;44;F
115238;490,728,670,793,1730,762,79,839,1616,1593,354,885,654,138,657;30;F
115242;695,79,406,1616,559,1593,1730,149,1383,654,138;60;F
115270;374;38;M
115300;1593,374,82,793,670,1730,502,407,1616,354,138;41;F
115324;138,407,502,762,1255,695,1730,247,200,82,839,1616,885,445,490;26;F
115325;150;15;M
115330;1593,1383;13;F
115381;1730,70,1593,1383,728;44;F
115401;1383,354,1593,1204,791,374,1255,70,1730,1326,670,839,885;29;M
115402;791,374,1255,82,1326,1616,354,670,793,200,1730,695,1383,1204,1593;34;M
115433;490,695,1730,82,502,80,839,1616,885,1383;31;M
115438;1730;50;M
115448;695,854,559,1616,824,588,243,424,1255,1730,402,445,654;26;F
115451;70,82,1255,79,588,824,885,490,657,728,762,1616;31;M
115478;1616,793,200,1730,695,70,402,80,1593,654;20;F
115485;762,793,670,200,1730,839,588,406,1616,1204,1593,885,1383,854,1180;48;M
115494;445,462,149,354,824,588,79,407,374,670,247,82,695,150;45;F
115531;793,670,1730,1255,839,1616;42;M
115552;762,885,787,728,670,200,1730,462,793,654,80,839;36;M
115560;728,670,1730,885,695,793,1616,1255,354,839,762,82,200,1180,1393;45;F
115561;354,138,1730,1616,654;26;F
115564;138,657,728,1730,70,374,1593,793,670,762,559,1180,885,462,839;5;M
115576;1255,695,793,839;25;M
115581;654,1593,1616,695;27;F
115592;502,407,1383,138;45;F
115606;1383,1593;47;M
115648;149,695,374,80,1204,791,793,1730,762,839,1723,354,1593,885,654;25;F
115662;793,1255,402,839,1723,1616,791,1593,670,200,1730,762,885,787;27;M
115665;695,407,79,588,824,1616,1593,354,885,462,654;29;F
115679;1593,1383;11;M
115740;1582,885,559,70,200,1730;26;F
115747;793,695,82,1255,762,402,374,839,1593,354,885,728,1730,1616,490;29;F
115801;670,1326,200,762,1616,654,490,138,728,839,885;31;M
115807;654,243,793,1616;41;M
115827;1593,1383;46;M
115856;793,200,695,402,559,654;43;F
115872;406,1593,149,1383,670,1326,1730,70,1616,559,885,654,441,657,728;61;F
115885;1593,1383;9;F
115896;1593,1383;6;F
115912;70,1383;44;F
115949;728,839,462,885,1180,559,762,793,1593,374,70,1730,670,657,138;37;F
116020;670,793,1326,1730,695,1255,762,80,407,79,839,1204,354,1383,138;3;F
116029;1593,1383;;M
116120;1730,1616,1593,654,150,407;74;F
116121;1616,588,150;75;M
116122;1730,1593,1383,1204,854,1180,354,79,149,138;86;F
116123;1730,1616,1593,793,762,728,695,654,559,406,150,80,200,70,82;75;F
99999916999;728;23;F
99999937954;1730,247,1582;33;F
99999993199;1393,1582,1326,1255,670,1180,1616,839;39;M
99999994132;105,1616,354,445,787,441;17;F